/* glprsm/delete_rsm.c */

/*----------------------------------------------------------------------
-- This file is a part of the GLPK package.
--
-- Copyright (C) 2000, 2001 Andrew Makhorin <mao@mai2.rcnet.ru>,
--                          Department for Applied Informatics,
--                          Moscow Aviation Institute, Moscow, Russia.
--                          All rights reserved.
--
-- This code is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; either version 2 of the License, or
-- (at your option) any later version.
--
-- This software is distributed "as is" in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty
-- of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
-- General Public License for more details.
--
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA.
----------------------------------------------------------------------*/

#include <stddef.h>
#include "glprsm.h"

/*----------------------------------------------------------------------
-- delete_rsm - delete revised simplex method common block.
--
-- *Synopsis*
--
-- #include "glprsm.h"
-- void delete_rsm(RSM *rsm);
--
-- *Description*
--
-- The routine delete_rsm() deletes the revised simplex method common
-- block, which the parameter rsm points to. */

void delete_rsm(RSM *rsm)
{     ufree(rsm->type);
      ufree(rsm->lb);
      ufree(rsm->ub);
      delete_mat(rsm->A);
      ufree(rsm->posx);
      ufree(rsm->indb);
      ufree(rsm->indn);
      ufree(rsm->tagn);
      if (rsm->pfi != NULL) delete_pfi(rsm->pfi);
      if (rsm->rfi != NULL) delete_rfi(rsm->rfi);
      if (rsm->afi != NULL) delete_afi(rsm->afi);
      if (rsm->ufi != NULL) delete_ufi(rsm->ufi);
      ufree(rsm);
      return;
}

/* eof */
