#ifndef	_exec_user_
#define	_exec_user_

/* Module exec */

#include <mach/kern_return.h>
#include <mach/port.h>
#include <mach/message.h>

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/statfs.h>
#include <sys/resource.h>
#include <sys/utsname.h>
#include <hurd/hurd_types.h>

/* Routine exec_exec */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __exec_exec
#if	defined(LINTLIBRARY)
    (execserver, file, filePoly, oldtask, flags, argv, argvCnt, envp, envpCnt, dtable, dtablePoly, dtableCnt, portarray, portarrayPoly, portarrayCnt, intarray, intarrayCnt, deallocnames, deallocnamesCnt, destroynames, destroynamesCnt)
	file_t execserver;
	mach_port_t file;
	mach_msg_type_name_t filePoly;
	mach_port_t oldtask;
	int flags;
	data_t argv;
	mach_msg_type_number_t argvCnt;
	data_t envp;
	mach_msg_type_number_t envpCnt;
	portarray_t dtable;
	mach_msg_type_name_t dtablePoly;
	mach_msg_type_number_t dtableCnt;
	portarray_t portarray;
	mach_msg_type_name_t portarrayPoly;
	mach_msg_type_number_t portarrayCnt;
	intarray_t intarray;
	mach_msg_type_number_t intarrayCnt;
	mach_port_array_t deallocnames;
	mach_msg_type_number_t deallocnamesCnt;
	mach_port_array_t destroynames;
	mach_msg_type_number_t destroynamesCnt;
{ return __exec_exec(execserver, file, filePoly, oldtask, flags, argv, argvCnt, envp, envpCnt, dtable, dtablePoly, dtableCnt, portarray, portarrayPoly, portarrayCnt, intarray, intarrayCnt, deallocnames, deallocnamesCnt, destroynames, destroynamesCnt); }
#else
(
	file_t execserver,
	mach_port_t file,
	mach_msg_type_name_t filePoly,
	mach_port_t oldtask,
	int flags,
	data_t argv,
	mach_msg_type_number_t argvCnt,
	data_t envp,
	mach_msg_type_number_t envpCnt,
	portarray_t dtable,
	mach_msg_type_name_t dtablePoly,
	mach_msg_type_number_t dtableCnt,
	portarray_t portarray,
	mach_msg_type_name_t portarrayPoly,
	mach_msg_type_number_t portarrayCnt,
	intarray_t intarray,
	mach_msg_type_number_t intarrayCnt,
	mach_port_array_t deallocnames,
	mach_msg_type_number_t deallocnamesCnt,
	mach_port_array_t destroynames,
	mach_msg_type_number_t destroynamesCnt
);
#endif

/* Routine exec_init */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __exec_init
#if	defined(LINTLIBRARY)
    (execserver, auth_handle, proc_server, proc_serverPoly)
	file_t execserver;
	auth_t auth_handle;
	mach_port_t proc_server;
	mach_msg_type_name_t proc_serverPoly;
{ return __exec_init(execserver, auth_handle, proc_server, proc_serverPoly); }
#else
(
	file_t execserver,
	auth_t auth_handle,
	mach_port_t proc_server,
	mach_msg_type_name_t proc_serverPoly
);
#endif

/* SimpleRoutine exec_setexecdata */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t __exec_setexecdata
#if	defined(LINTLIBRARY)
    (execserver, ports, portsPoly, portsCnt, ints, intsCnt)
	file_t execserver;
	portarray_t ports;
	mach_msg_type_name_t portsPoly;
	mach_msg_type_number_t portsCnt;
	intarray_t ints;
	mach_msg_type_number_t intsCnt;
{ return __exec_setexecdata(execserver, ports, portsPoly, portsCnt, ints, intsCnt); }
#else
(
	file_t execserver,
	portarray_t ports,
	mach_msg_type_name_t portsPoly,
	mach_msg_type_number_t portsCnt,
	intarray_t ints,
	mach_msg_type_number_t intsCnt
);
#endif


/* Module exec */

#include <mach/kern_return.h>
#include <mach/port.h>
#include <mach/message.h>

#include <mach/std_types.h>
#include <mach/mach_types.h>
#include <device/device_types.h>
#include <device/net_status.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/statfs.h>
#include <sys/resource.h>
#include <sys/utsname.h>
#include <hurd/hurd_types.h>

/* Routine exec_exec */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t exec_exec
#if	defined(LINTLIBRARY)
    (execserver, file, filePoly, oldtask, flags, argv, argvCnt, envp, envpCnt, dtable, dtablePoly, dtableCnt, portarray, portarrayPoly, portarrayCnt, intarray, intarrayCnt, deallocnames, deallocnamesCnt, destroynames, destroynamesCnt)
	file_t execserver;
	mach_port_t file;
	mach_msg_type_name_t filePoly;
	mach_port_t oldtask;
	int flags;
	data_t argv;
	mach_msg_type_number_t argvCnt;
	data_t envp;
	mach_msg_type_number_t envpCnt;
	portarray_t dtable;
	mach_msg_type_name_t dtablePoly;
	mach_msg_type_number_t dtableCnt;
	portarray_t portarray;
	mach_msg_type_name_t portarrayPoly;
	mach_msg_type_number_t portarrayCnt;
	intarray_t intarray;
	mach_msg_type_number_t intarrayCnt;
	mach_port_array_t deallocnames;
	mach_msg_type_number_t deallocnamesCnt;
	mach_port_array_t destroynames;
	mach_msg_type_number_t destroynamesCnt;
{ return exec_exec(execserver, file, filePoly, oldtask, flags, argv, argvCnt, envp, envpCnt, dtable, dtablePoly, dtableCnt, portarray, portarrayPoly, portarrayCnt, intarray, intarrayCnt, deallocnames, deallocnamesCnt, destroynames, destroynamesCnt); }
#else
(
	file_t execserver,
	mach_port_t file,
	mach_msg_type_name_t filePoly,
	mach_port_t oldtask,
	int flags,
	data_t argv,
	mach_msg_type_number_t argvCnt,
	data_t envp,
	mach_msg_type_number_t envpCnt,
	portarray_t dtable,
	mach_msg_type_name_t dtablePoly,
	mach_msg_type_number_t dtableCnt,
	portarray_t portarray,
	mach_msg_type_name_t portarrayPoly,
	mach_msg_type_number_t portarrayCnt,
	intarray_t intarray,
	mach_msg_type_number_t intarrayCnt,
	mach_port_array_t deallocnames,
	mach_msg_type_number_t deallocnamesCnt,
	mach_port_array_t destroynames,
	mach_msg_type_number_t destroynamesCnt
);
#endif

/* Routine exec_init */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t exec_init
#if	defined(LINTLIBRARY)
    (execserver, auth_handle, proc_server, proc_serverPoly)
	file_t execserver;
	auth_t auth_handle;
	mach_port_t proc_server;
	mach_msg_type_name_t proc_serverPoly;
{ return exec_init(execserver, auth_handle, proc_server, proc_serverPoly); }
#else
(
	file_t execserver,
	auth_t auth_handle,
	mach_port_t proc_server,
	mach_msg_type_name_t proc_serverPoly
);
#endif

/* SimpleRoutine exec_setexecdata */
#ifdef	mig_external
mig_external
#else
extern
#endif
kern_return_t exec_setexecdata
#if	defined(LINTLIBRARY)
    (execserver, ports, portsPoly, portsCnt, ints, intsCnt)
	file_t execserver;
	portarray_t ports;
	mach_msg_type_name_t portsPoly;
	mach_msg_type_number_t portsCnt;
	intarray_t ints;
	mach_msg_type_number_t intsCnt;
{ return exec_setexecdata(execserver, ports, portsPoly, portsCnt, ints, intsCnt); }
#else
(
	file_t execserver,
	portarray_t ports,
	mach_msg_type_name_t portsPoly,
	mach_msg_type_number_t portsCnt,
	intarray_t ints,
	mach_msg_type_number_t intsCnt
);
#endif

#endif	/* not defined(_exec_user_) */
