/* cmds.c:
 *
 ****************************************************************
 * Copyright (C) 2003 Tom Lord
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */


#include "tla/libarch/cmd-abrowse.h"
#include "tla/libarch/cmd-add-log.h"
#include "tla/libarch/cmd-add-pristine.h"
#include "tla/libarch/cmd-add-tag.h"
#include "tla/libarch/cmd-ancestry.h"
#include "tla/libarch/cmd-ancestry-graph.h"
#include "tla/libarch/cmd-archive-fixup.h"
#include "tla/libarch/cmd-archive-meta-info.h"
#include "tla/libarch/cmd-archive-mirror.h"
#include "tla/libarch/cmd-archive-setup.h"
#include "tla/libarch/cmd-archive-snapshot.h"
#include "tla/libarch/cmd-archive-version.h"
#include "tla/libarch/cmd-branches.h"
#include "tla/libarch/cmd-buildcfg.h"
#include "tla/libarch/cmd-cachedrevs.h"
#include "tla/libarch/cmd-cacherev.h"
#include "tla/libarch/cmd-cat-archive-log.h"
#include "tla/libarch/cmd-cat-log.h"
#include "tla/libarch/cmd-categories.h"
#include "tla/libarch/cmd-cfgcat.h"
#include "tla/libarch/cmd-changelog.h"
#include "tla/libarch/cmd-changeset.h"
#include "tla/libarch/cmd-cmtrev.h"
#include "tla/libarch/cmd-default-tag.h"
#include "tla/libarch/cmd-delete-tag.h"
#include "tla/libarch/cmd-deltapatch.h"
#include "tla/libarch/cmd-do-changeset.h"
#include "tla/libarch/cmd-file-diffs.h"
#include "tla/libarch/cmd-file-find.h"
#include "tla/libarch/cmd-find-pristine.h"
#include "tla/libarch/cmd-get-patch.h"
#include "tla/libarch/cmd-getrev.h"
#include "tla/libarch/cmd-help.h"
#include "tla/libarch/cmd-imprev.h"
#include "tla/libarch/cmd-init-tree.h"
#include "tla/libarch/cmd-inv-tag.h"
#include "tla/libarch/cmd-join-branch.h"
#include "tla/libarch/cmd-library-add.h"
#include "tla/libarch/cmd-library-archives.h"
#include "tla/libarch/cmd-library-branches.h"
#include "tla/libarch/cmd-library-categories.h"
#include "tla/libarch/cmd-library-file.h"
#include "tla/libarch/cmd-library-find.h"
#include "tla/libarch/cmd-library-log.h"
#include "tla/libarch/cmd-library-remove.h"
#include "tla/libarch/cmd-library-revisions.h"
#include "tla/libarch/cmd-library-versions.h"
#include "tla/libarch/cmd-lock-pristine.h"
#include "tla/libarch/cmd-lock-revision.h"
#include "tla/libarch/cmd-log-for-merge.h"
#include "tla/libarch/cmd-log-ls.h"
#include "tla/libarch/cmd-logs.h"
#include "tla/libarch/cmd-ls-archives.h"
#include "tla/libarch/cmd-ls-pristines.h"
#include "tla/libarch/cmd-make-archive.h"
#include "tla/libarch/cmd-make-branch.h"
#include "tla/libarch/cmd-make-category.h"
#include "tla/libarch/cmd-make-log.h"
#include "tla/libarch/cmd-make-version.h"
#include "tla/libarch/cmd-merges.h"
#include "tla/libarch/cmd-move-tag.h"
#include "tla/libarch/cmd-my-default-archive.h"
#include "tla/libarch/cmd-my-id.h"
#include "tla/libarch/cmd-my-revision-library.h"
#include "tla/libarch/cmd-new-merges.h"
#include "tla/libarch/cmd-parse-package-name.h"
#include "tla/libarch/cmd-redo-changes.h"
#include "tla/libarch/cmd-register-archive.h"
#include "tla/libarch/cmd-remove-log.h"
#include "tla/libarch/cmd-replay.h"
#include "tla/libarch/cmd-revdelta.h"
#include "tla/libarch/cmd-revisions.h"
#include "tla/libarch/cmd-set-tree-version.h"
#include "tla/libarch/cmd-show-changeset.h"
#include "tla/libarch/cmd-srcfind.h"
#include "tla/libarch/cmd-star-merge.h"
#include "tla/libarch/cmd-sync-tree.h"
#include "tla/libarch/cmd-tagging-defaults.h"
#include "tla/libarch/cmd-tagging-method.h"
#include "tla/libarch/cmd-tagrev.h"
#include "tla/libarch/cmd-tree-lint.h"
#include "tla/libarch/cmd-tree-root.h"
#include "tla/libarch/cmd-tree-version.h"
#include "tla/libarch/cmd-uncacherev.h"
#include "tla/libarch/cmd-undo-changes.h"
#include "tla/libarch/cmd-update.h"
#include "tla/libarch/cmd-valid-package-name.h"
#include "tla/libarch/cmd-versions.h"
#include "tla/libarch/cmd-what-changed.h"
#include "tla/libarch/cmd-whats-missing.h"
#include "tla/libarch/cmd-whereis-archive.h"
#include "tla/libarch/cmds.h"



struct arch_command arch_commands[] =
{
  {"help", 0, 0, 0},

  {"help", arch_cmd_help, arch_cmd_help_help, 0},


  {"User Commands", 0, 0, 0},

  {"my-id", arch_cmd_my_id, arch_cmd_my_id_help, 0},
  {"", 0},
  {"my-default-archive", arch_cmd_my_default_archive, arch_cmd_my_default_archive_help, 0},
  {"register-archive", arch_cmd_register_archive, arch_cmd_register_archive_help, 0},
  {"whereis-archive", arch_cmd_whereis_archive, arch_cmd_whereis_archive_help, 0},
  {"ls-archives", arch_cmd_ls_archives, arch_cmd_ls_archives_help, 0},
  {"archives", arch_cmd_ls_archives, arch_cmd_ls_archives_help, "ls-archives"},


  {"Project Tree Commands", 0, 0, 0},

  {"init-tree", arch_cmd_init_tree, arch_cmd_init_tree_help, 0},
  {"tree-root", arch_cmd_tree_root, arch_cmd_tree_root_help, 0},
  {"", 0},
  {"tree-version", arch_cmd_tree_version, arch_cmd_tree_version_help, 0},
  {"set-tree-version", arch_cmd_set_tree_version, arch_cmd_set_tree_version_help, 0},
  {"", 0},
  {"undo-changes", arch_cmd_undo_changes, arch_cmd_undo_changes_help, 0},
  {"undo", arch_cmd_undo_changes, arch_cmd_undo_changes_help, "undo-changes"},
  {"redo-changes", arch_cmd_redo_changes, arch_cmd_redo_changes_help, 0},
  {"redo", arch_cmd_redo_changes, arch_cmd_redo_changes_help, "redo-changes"},
  {"", 0},
  {"what-changed", arch_cmd_what_changed, arch_cmd_what_changed_help, 0},
  {"file-diffs", arch_cmd_file_diffs, arch_cmd_file_diffs_help, 0},


  {"Project Tree Inventory Commands", 0, 0, 0},

  {"srcfind", arch_cmd_srcfind, arch_cmd_srcfind_help, 0},
  {"inventory", arch_cmd_srcfind, arch_cmd_srcfind_help, "srcfind"},
  {"tree-lint", arch_cmd_tree_lint, arch_cmd_tree_lint_help, 0},
  {"inv-tag", arch_cmd_inv_tag, arch_cmd_inv_tag_help, 0},
  {"", 0},
  {"tagging-method", arch_cmd_tagging_method, arch_cmd_tagging_method_help, 0},
  {"", 0},
  {"add-tag", arch_cmd_add_tag, arch_cmd_add_tag_help, 0},
  {"add", arch_cmd_add_tag, arch_cmd_add_tag_help, "add-tag"},
  {"delete-tag", arch_cmd_delete_tag, arch_cmd_delete_tag_help, 0},
  {"delete", arch_cmd_delete_tag, arch_cmd_delete_tag_help, "delete-tag"},
  {"move-tag", arch_cmd_move_tag, arch_cmd_move_tag_help, 0},
  {"move", arch_cmd_move_tag, arch_cmd_move_tag_help, "move-tag"},
  {"default-tag", arch_cmd_default_tag, arch_cmd_default_tag_help, 0},
  {"explicit-default", arch_cmd_default_tag, arch_cmd_default_tag_help, "default-tag"},
  {"", 0},
  {"tagging-defaults", arch_cmd_tagging_defaults, arch_cmd_tagging_defaults_help, 0},


  {"Patch Set Commands", 0, 0, 0},

  {"changeset", arch_cmd_changeset, arch_cmd_changeset_help, 0},
  {"mkpatch", arch_cmd_changeset, arch_cmd_changeset_help, "changeset"},
  {"do-changeset", arch_cmd_do_changeset, arch_cmd_do_changeset_help, 0},
  {"dopatch", arch_cmd_do_changeset, arch_cmd_do_changeset_help, "do-changeset"},
  {"show-changeset", arch_cmd_show_changeset, arch_cmd_show_changeset_help, 0},


  {"Archive Transaction Commands", 0, 0, 0},

  {"make-archive", arch_cmd_make_archive, arch_cmd_make_archive_help, 0},
  {"archive-setup",  arch_cmd_archive_setup,  arch_cmd_archive_setup_help, 0},
  {"", 0},
  {"make-category", arch_cmd_make_category, arch_cmd_make_category_help, 0},
  {"make-branch", arch_cmd_make_branch, arch_cmd_make_branch_help, 0},
  {"make-version", arch_cmd_make_version, arch_cmd_make_version_help, 0},
  {"", 0},
  {"imprev", arch_cmd_imprev, arch_cmd_imprev_help, 0},
  {"import", arch_cmd_imprev, arch_cmd_imprev_help, "imprev"},
  {"cmtrev", arch_cmd_cmtrev, arch_cmd_cmtrev_help, 0},
  {"commit", arch_cmd_cmtrev, arch_cmd_cmtrev_help, "cmtrev"},
  {"", 0},
  {"getrev", arch_cmd_getrev, arch_cmd_getrev_help, 0},
  {"get", arch_cmd_getrev, arch_cmd_getrev_help, "getrev"},
  {"get-patch", arch_cmd_get_patch, arch_cmd_get_patch_help, 0},
  {"", 0},
  {"lock-revision", arch_cmd_lock_revision, arch_cmd_lock_revision_help, 0},
  {"archive-mirror", arch_cmd_archive_mirror, arch_cmd_archive_mirror_help, 0},
  {"push-mirror", arch_cmd_archive_mirror, arch_cmd_archive_mirror_help, "archive-mirror"},


  {"Archive Commands", 0, 0, 0},

  {"abrowse", arch_cmd_abrowse, arch_cmd_abrowse_help, 0},
  {"categories", arch_cmd_categories, arch_cmd_categories_help, 0},
  {"branches", arch_cmd_branches, arch_cmd_branches_help, 0},
  {"versions", arch_cmd_versions, arch_cmd_versions_help, 0},
  {"revisions", arch_cmd_revisions, arch_cmd_revisions_help, 0},
  {"ancestry", arch_cmd_ancestry, arch_cmd_ancestry_help, 0},
  {"ancestry-graph", arch_cmd_ancestry_graph, arch_cmd_ancestry_graph_help, 0},
  {"", 0},
  {"cat-archive-log", arch_cmd_cat_archive_log, arch_cmd_cat_archive_log_help, 0},
  {"", 0},
  {"cacherev", arch_cmd_cacherev, arch_cmd_cacherev_help, 0},
  {"cachedrevs", arch_cmd_cachedrevs, arch_cmd_cachedrevs_help, 0},
  {"uncacherev", arch_cmd_uncacherev, arch_cmd_uncacherev_help, 0},
  {"", 0},
  {"archive-meta-info", arch_cmd_archive_meta_info, arch_cmd_archive_meta_info_help, 0},
  {"archive-snapshot", arch_cmd_archive_snapshot, arch_cmd_archive_snapshot_help, 0},
  {"archive-version", arch_cmd_archive_version, arch_cmd_archive_version_help, 0},
  {"", 0},
  {"archive-fixup", arch_cmd_archive_fixup, arch_cmd_archive_fixup_help, 0},


  {"Patch Log Commands", 0, 0, 0},

  {"make-log", arch_cmd_make_log, arch_cmd_make_log_help, 0},
  {"logs", arch_cmd_logs, arch_cmd_logs_help, 0},
  {"add-log", arch_cmd_add_log, arch_cmd_add_log_help, 0},
  {"remove-log", arch_cmd_remove_log, arch_cmd_remove_log_help, 0},
  {"log-ls", arch_cmd_log_ls, arch_cmd_log_ls_help, 0},
  {"cat-log", arch_cmd_cat_log, arch_cmd_cat_log_help, 0},
  {"", 0},
  {"changelog", arch_cmd_changelog, arch_cmd_changelog_help, 0},
  {"", 0},
  {"log-for-merge", arch_cmd_log_for_merge, arch_cmd_log_for_merge_help, 0},
  {"merges", arch_cmd_merges, arch_cmd_merges_help, 0},
  {"new-merges", arch_cmd_new_merges, arch_cmd_new_merges_help, 0},


  {"Multi-project Configuration Commands", 0, 0, 0},

  {"buildcfg", arch_cmd_buildcfg, arch_cmd_buildcfg_help, 0},
  {"build-config", arch_cmd_buildcfg, arch_cmd_buildcfg_help, "buildcfg"},
  {"cfgcat", arch_cmd_cfgcat, arch_cmd_cfgcat_help, 0},
  {"catcfg", arch_cmd_cfgcat, arch_cmd_cfgcat_help, "cfgcat"},


  {"Commands for Branching and Merging", 0, 0, 0},

  {"tagrev", arch_cmd_tagrev, arch_cmd_tagrev_help, 0},
  {"tag", arch_cmd_tagrev, arch_cmd_tagrev_help, "tagrev"},
  {"", 0},
  {"update", arch_cmd_update, arch_cmd_update_help, 0},
  {"replay", arch_cmd_replay, arch_cmd_replay_help, 0},
  {"star-merge", arch_cmd_star_merge, arch_cmd_star_merge_help, 0},
  {"deltapatch", arch_cmd_deltapatch, arch_cmd_deltapatch_help, 0},
  {"delta-patch", arch_cmd_deltapatch, arch_cmd_deltapatch_help, "deltapatch"},
  {"whats-missing", arch_cmd_whats_missing, arch_cmd_whats_missing_help, 0},
  {"", 0},
  {"join-branch", arch_cmd_join_branch, arch_cmd_join_branch_help, 0},
  {"sync-tree", arch_cmd_sync_tree, arch_cmd_sync_tree_help, 0},
  {"make-sync-tree", arch_cmd_sync_tree, arch_cmd_sync_tree_help, "sync-tree"},
  {"", 0},
  {"revdelta", arch_cmd_revdelta, arch_cmd_revdelta_help, 0},


  {"Local Cache Commands", 0, 0, 0},

  {"what-changed", arch_cmd_what_changed, arch_cmd_what_changed_help, 0},
  {"file-diffs", arch_cmd_file_diffs, arch_cmd_file_diffs_help, 0},
  {"file-find", arch_cmd_file_find, arch_cmd_file_find_help, 0},
  {"", 0},
  {"ls-pristines", arch_cmd_ls_pristines, arch_cmd_ls_pristines_help, 0},
  {"lock-pristine", arch_cmd_lock_pristine, arch_cmd_lock_pristine_help, 0},
  {"add-pristine", arch_cmd_add_pristine, arch_cmd_add_pristine_help, 0},
  {"find-pristine", arch_cmd_find_pristine, arch_cmd_find_pristine_help, 0},


  {"Revision Library Commands", 0, 0, 0},

  {"my-revision-library", arch_cmd_my_revision_library, arch_cmd_my_revision_library_help, 0},
  {"library-find", arch_cmd_library_find, arch_cmd_library_find_help, 0},
  {"library-add", arch_cmd_library_add, arch_cmd_library_add_help, 0},
  {"library-remove", arch_cmd_library_remove, arch_cmd_library_remove_help, 0},
  {"library-archives", arch_cmd_library_archives, arch_cmd_library_archives_help, 0},
  {"library-categories", arch_cmd_library_categories, arch_cmd_library_categories_help, 0},
  {"library-branches", arch_cmd_library_branches, arch_cmd_library_branches_help, 0},
  {"library-versions", arch_cmd_library_versions, arch_cmd_library_versions_help, 0},
  {"library-revisions", arch_cmd_library_revisions, arch_cmd_library_revisions_help, 0},
  {"library-log", arch_cmd_library_log, arch_cmd_library_log_help, 0},
  {"library-file", arch_cmd_library_file, arch_cmd_library_file_help, 0},



  {"Miscellaneous Scripting Support", 0, 0, 0},

  {"parse-package-name", arch_cmd_parse_package_name, arch_cmd_parse_package_name_help, 0},
  {"valid-package-name", arch_cmd_valid_package_name, arch_cmd_valid_package_name_help, 0},


  {0, },
};




/* tag: Tom Lord Tue Jun 10 17:15:53 2003 (cmds.c)
 */
