/* inv-tags.h: file inventory tags
 *
 ****************************************************************
 * Copyright (C) 2002, 2003 Tom Lord
 *
 * See the file "COPYING" for further information about
 * the copyright and warranty status of this work.
 */

#ifndef INCLUDE__LIBARCH__INV_TAGS_H
#define INCLUDE__LIBARCH__INV_TAGS_H


#include "hackerlab/machine/types.h"



enum arch_tagging_method
{
  arch_names_tagging,
  arch_implicit_tagging,
  arch_tagline_tagging,
  arch_explicit_tagging,

  arch_unspecified_tagging,     /* used in make/apply_changeset */
};


/* automatically generated __STDC__ prototypes */
extern t_uchar * arch_log_file_tag (t_uchar * archive, t_uchar * revision);
extern t_uchar * arch_inventory_tag (enum arch_tagging_method method, t_uchar * path);
extern t_uchar * arch_tagging_method_name (enum arch_tagging_method m);
extern enum arch_tagging_method arch_tagging_method_from_name (t_uchar * name);
extern t_uchar * arch_default_tagging_method_contents (enum arch_tagging_method method);
extern t_uchar * arch_tree_tagging_method_file (t_uchar * tree_root);
extern enum arch_tagging_method arch_tree_tagging_method (t_uchar * tree_root, int strict);
extern void arch_set_tree_tagging_method (t_uchar * tree_root,
                                          enum arch_tagging_method method);
extern t_uchar * arch_explicit_tag_file_for (t_uchar * path);
extern t_uchar * arch_generate_tag (void);
extern void arch_add_explicit_tag (t_uchar * path, t_uchar * tag);
extern void arch_delete_explicit_tag (t_uchar * path);
extern void arch_move_explicit_tag (t_uchar * from, t_uchar * to);
extern t_uchar * arch_strong_explicit_dflt_file (t_uchar * dir);
extern t_uchar * arch_weak_explicit_dflt_file (t_uchar * dir);
extern t_uchar * arch_dont_care_explicit_dflt_file (t_uchar * dir);
extern int arch_is_dont_care_explicit_dflt_dir (t_uchar * dir);
extern void arch_delete_strong_explicit_default (t_uchar * dir);
extern void arch_delete_weak_explicit_default (t_uchar * dir);
extern void arch_delete_dont_care_explicit_default (t_uchar * dir);
extern void arch_set_strong_explicit_default (t_uchar * dir, t_uchar * tag);
extern void arch_set_weak_explicit_default (t_uchar * dir, t_uchar * tag);
extern void arch_set_dont_care_explicit_default (t_uchar * dir);
#endif  /* INCLUDE__LIBARCH__INV_TAGS_H */


/* tag: Tom Lord Sat Jan  5 15:26:10 2002 (inv-tags.h)
 */
