# GNU Enterprise Common Library
#
# Copyright 2001-2007 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: __init__.py 9754 2007-07-12 14:15:34Z reinhard $
"""
The GNUe Common Library is a set of Python modules used in the GNUe tools. Many
of the modules can also be used outside GNUe.
"""

from utils import version

try:
    import svnrev
    svn_revision = svnrev.svnrev
except ImportError:
    svn_revision = None

PACKAGE = "GNUe-Common"
TITLE = "GNUe Common Library"

version = version.Version(0, 6, 'final', 9, svn_revision)

VERSION = version.get_version()
HEXVERSION = version.get_hexversion()

__version__ = VERSION
__hexversion__ = HEXVERSION
