#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2009 Free Software Foundation
#
# $Id: CHParser.py 6763 2004-11-30 23:36:21Z jcater $
#
# DESCRIPTION:
"""
Class that contains a SAX-based xml processor for GNUe Reports'
"Char" markup.
"""
#
# NOTES:
#

__all__ = ['loadFile', 'xmlReportHandler', 'getXMLelements']

from gnue.common.datasources import GDataSource
from gnue.common.formatting import GTypecast
from gnue.common.definitions import GParser
from gnue.common.logic import GTrigger
import copy, types




########
########  Please keep this file neat !!!
########




#######################################################
# This method loads a report from an XML file and returns
# a Report object.  If initialize is 1 (default), then
# the report is initialized and ready to go.
#######################################################

def loadFile(buffer, connections=None, initialize=0):
  return GParser.loadXMLObject (buffer, xmlReportHandler, 'CHReport', 'chreport',
           initialize, attributes={})



xmlElements = None


def getXMLelements():

  global xmlElements

  import CHObjects
  import CHReport

  if xmlElements == None:

    #
    #
    xmlElements = {
      'chreport':       {
         'BaseClass': CHReport.CHReport,
         'Required': 1,
         'SingleInstance': 1,
         'Attributes':  {
            'width': {
               'Required': True,
               'Typecast': GTypecast.whole,
               'Description': 'The width of the report in text columns.' },
            'height': {
               'Required': True,
               'Typecast': GTypecast.whole,
               'Description': 'The height of the report in text rows. ' },
            'description':       {
               'Typecast': GTypecast.text }
          },
         'ParentTags':  None
      },

      'titlepage':    {
         'BaseClass': CHObjects.CHTitlePage,
         'SingleInstance': 1,
         'ParentTags':  ('chreport',)
      },

      'summarypage':    {
         'BaseClass': CHObjects.CHSummaryPage,
         'SingleInstance': 1,
         'ParentTags':  ('chreport',)
      },

      'pageheader':    {
         'BaseClass': CHObjects.CHPageHeader,
         'Attributes': {
            'height': {
               'Required': True,
               'Typecast': GTypecast.whole,
               'Description': 'The height of the page header in text rows. ' }
          },
         'SingleInstance': 1,
         'ParentTags':  ('chreport',)
      },

      'pagefooter':    {
         'BaseClass': CHObjects.CHPageFooter,
         'Attributes': {
            'height': {
               'Required': True,
               'Typecast': GTypecast.whole,
               'Description': 'The height of the page footer in text rows. ' },
          },
         'SingleInstance': 1,
         'ParentTags':  ('chreport',)
      },

      'groupheader':    {
         'BaseClass': CHObjects.CHGroupHeader,
         'Attributes': {
            'height': {
               'Required': True,
               'Typecast': GTypecast.whole,
               'Description': 'The height of the group header in text rows. ' },
          },
         'ParentTags':  ('chreport',)
      },

      'groupfooter':    {
         'BaseClass': CHObjects.CHGroupFooter,
         'Attributes': {
            'height': {
               'Required': True,
               'Typecast': GTypecast.whole,
               'Description': 'The height of the group footer in text rows. ' },
          },
         'ParentTags':  ('chreport',)
      },

      'detail':    {
         'BaseClass': CHObjects.CHDetail,
         'Attributes': {
            'height': {
               'Required': True,
               'Typecast': GTypecast.whole,
               'Description': 'The height of the group footer in text rows. ' },
          },
         'SingleInstance': 1,
         'ParentTags':  ('chreport',)
      },

      'label':    {
         'BaseClass': CHObjects.CHLabel,
         'MixedContent': True,
         'KeepWhitespace': False,
         'Attributes': {
            'align': {
               'Typecast': GTypecast.name,
               'ValueSet': {
                  'none': {'Label': _('Not aligned')},
                  'left': {'Label': _('Left')},
                  'right': {'Label': _('Right')},
                  'center': {'Label': _('Centered')} },
               'Default': "none",
               'Description': 'The justification of the label. Can be one of '
                              'the following: {left}, {right}, or {center}. '},
            'condensed': {
               'Typecast': GTypecast.boolean,
               'Default': False,
               'Description': 'The width of the label font. {True}, if the font'
                             +' is condensed.'},
            'bold': {
               'Typecast': GTypecast.boolean,
               'Default': False,
               'Description': 'The font style attribute "bold". '
                              +'{True}, if the label font is bold.'},
            'italic': {
               'Typecast': GTypecast.boolean,
               'Default': False,
               'Description': 'The font style attribute "italic". '
                              +'{True}, if the label font is italic.'},
            'underline': {
               'Typecast': GTypecast.boolean,
               'Default': False,
               'Description': 'The font style attribute "underline". '
                              +'{True}, if the label font is underlined.'},
            'width': {
               'Required': True,
               'Typecast': GTypecast.whole,
               'Description': 'The width of the label in text columns.' },
            'height': {
               'Required': False,
               'Typecast': GTypecast.whole,
               'Description': 'The height of the label in text rows. ' },
            'x': {
               'Required': True,
               'Typecast': GTypecast.whole,
               'Description': 'The column starting position of the label. Based upon leftmost column of report being 0.' },
            'y': {
               'Required': True,
               'Typecast': GTypecast.whole,
               'Description': 'The row starting position of the label. Based upon the top row of the report being 0.' }
          },
         'ParentTags':  ('titlepage',
                         'summarypage',
                         'pageheader',
                         'pagefooter',
                         'groupheader',
                         'groupfooter',
                         'detail',)
      },

    }


  return GParser.buildImportableTags('chreport',xmlElements)


#######################################################
#
# xmlReportHandler
#
# This class is called by the XML parser to
# process the xml file.
#
#######################################################

class xmlReportHandler (GParser.xmlHandler):

  ignore_unknown_namespaces = True
  default_namespace = 'GNUe:Reports:Char'

  def __init__(self):
    GParser.xmlHandler.__init__(self)
    self.xmlElements = getXMLelements()
