# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 3, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2009 Free Software Foundation
#
# $Id: text.py 9958 2009-10-11 18:56:59Z reinhard $
#
# DESCRIPTION:
# Transforms adapter for direct
#
# NOTES:
#

class DirectFormatter:

  def __init__(self, destination, stylesheet, options={}):
    self.dest = destination
    self.options = options

    self._reporttitle = u''
    self._sectiontitle = u''

    try:
      self.encoding = options['encoding']
    except:
      self.encoding = gConfig('textEncoding')

  def writeout(self, text):
    self.dest.write(text.encode(self.encoding,'replace'))


  def BeginReport(self):
    pass


  def EndReport(self):
    pass


  def BeginReportTitle(self):
    pass


  def EndReportTitle(self, reporttitle):
    self._reporttitle = reporttitle


  def BeginSection(self):
    pass


  def EndSection(self):
    pass


  def BeginSectionTitle(self):
    pass


  def EndSectionTitle(self, sectiontitle):
    self._sectiontitle = sectiontitle


  def BeginTable(self):
    pass


  def EndTable(self):
    pass


  def BeginTableHead(self):
    self._head = []
    self._colwidth = []
    self._colalign = []
    self._headwidth = 0


  def EndTableHead(self):
    self.writeout('%s\n' % self._reporttitle.center(self._headwidth))
    self.writeout('%s\n' % ('='*len(self._reporttitle)).center(self._headwidth))
    self.writeout('%s\n\n' % self._sectiontitle.center(self._headwidth))

    self.writeout('%s\n' % ''.join(self._head))
    self.writeout('%s\n' % ('='*self._headwidth))


  def BeginColHead(self):
    pass


  def EndColHead(self, colhead, width, alignment=None):

    # TODO: temporary... should be calculated
    if not width:
      width = 15

    if alignment == 'center':
      ch = colhead.strip().center(width)
    elif alignment == 'right':
      ch = colhead.strip().rjust(width)
    else:
      ch = colhead.strip().ljust(width)
    self._head.append(ch)

    self._colwidth.append(width)
    self._colalign.append(alignment)
    self._headwidth += width


  def BeginRow(self, rowtype=None):
    self._row = []
    self._rowtype = rowtype

  def EndRow(self):
    if self._rowtype == 'subtotal':
      self.writeout('%s\n' % ('-'*self._headwidth))

    self.writeout('%s\n' % ''.join(self._row))

    if self._rowtype == 'subtotal':
      self.writeout('\n')


  def BeginCol(self):
    pass


  def EndCol(self, col, index):
    if self._colalign[index] == 'center':
      c = col.strip().center(self._colwidth[index])
    elif self._colalign[index] == 'right':
      c = col.strip().rjust(self._colwidth[index])
    else:
      c = col.strip().ljust(self._colwidth[index])
    self._row.append(c)
