// Declares some structs and functions for inclusion in C-files only.

/*
Copyright (C) 1996 Free Software Foundation
    written by R.D. Pierce (pierce@math.psu.edu)

This file is part of the GNUSSL software package.  This package is free
software; you can redistribute it and/or modify it under the terms of
the GNU Library General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This software is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU Library General Public License for more details.
You should have received a copy of the GNU Library General Public
License along with this distribution; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

struct c_double_array {
  long unsigned s_;
  double *data_;
};

struct c_double_vector {
  long unsigned s_;
  double *data_;
};

struct c_double_matrix {
  long unsigned r_;
  long unsigned c_;
  double *data_;
};

struct c_complex_array {
  long unsigned s_;
  struct c_complex *data_;
};

struct c_complex_vector {
  long unsigned s_;
  struct c_complex *data_;
};

struct c_complex_matrix {
  long unsigned r_;
  long unsigned c_;
  struct c_complex *data_;
};

long unsigned 
a_elem(long unsigned s); 

long unsigned 
v_elem(long unsigned s); 

long unsigned 
m_elem(long unsigned rows,long unsigned cols,long unsigned r,long unsigned c); 

