// Exercises the functions which depend on Gauss-Jordan elimination and
// LU-decomposition.

/*
Copyright (C) 1996 Free Software Foundation
    written by R.D. Pierce (pierce@math.psu.edu)

This software is free; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free
Software Foundation; either version 2 of the License, or (at your
option) any later version.  This software is distributed in the hope
that it will be useful, but WITHOUT ANY WARRANTY; without even the
implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
You should have received a copy of the GNU General Public
License along with this library; if not, write to the Free Software
Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include<complex.h>
#include<mMatrix.h>
#include<instance.h>
#include<lin_alg.h>

int main(int argc,char **argv) {
  int dim=atoi(argv[1]);
  mMatrix<double_complex,allocator<double_complex> > a(dim,dim),i(dim,dim);
  rand(1);              // seed the random # generator with a known value
  double maxr=(double)0x0fffffff;
  for(int r=1;r<=dim;r++) {  // set a to a random matrix, i to the identity
    for(int c=1;c<=dim;c++) {
      a(r,c)=double_complex(rand()/maxr,rand()/maxr);
      i(r,c)=0.0;
    }
    i(r,r)=1.0;
  }
  mMatrix<double_complex,allocator<double_complex> > b(dim,dim),c(dim,dim);
  b=a;        // copy the random matrix and the identity
  c=i;
  cout << "Test mMatrix is random double_complex, with "<< dim << " rows and columns\n";
  cout << "Test Gauss-Jordan elimination, using the sup norm with abs: \n";
  gauss_jordan(b,c,0.0);       // solve for the inverse
  cout << "Deviation from the identity: " << sup(i-b) << '\n';
  cout << "Deviation from the inverse: " << sup(i-dot(c,a,b)) << '\n';
  b=a;                     // reset the matrices
  c=i;
  cout << "Test LU-decomposition by solving for the inverse:\n";
  lu_solve(b,c,0.0);       // solve for the inverse
  cout << "Deviation from the inverse: " << sup(i-dot(c,a,b)) << '\n';
  cout << "The size of these numbers is essentially the accuracy of the ";
  cout << "routines.\n";
  return 0;
}
