/* html_mode.c
 * For use with GTKeyboard
 * This is a crude version of a quick html tag inserter.
 * Right now all of these functions are included in the item factory that 
 * makes the menu - I'll have to eventually build in submenus and so on,
 * but so far it's pretty small...
 *
 * In order for all of these to be used, you have to have INCLUDE_HTML 
 * defined within master.h - otherwise they won't be compiled in.  Well, they
 * will be compiled in but they won't be used.
 */
/* GTKeyboard - A Graphical Keyboard For X
 * Copyright (C) 1999, 2000 David Allen  
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

#include "master.h"
#include "html.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <errno.h>
#include <signal.h>
#include <ctype.h>

#ifdef MEM_DEBUGGING
#include "mem/memdebug.h"
#endif /* MEM_DEBUGGING */

#ifndef INCLUDE_HTML
#  define INCLUDE_HTML
#endif /* INCLUDE_HTML */
#define HTML_MODE_C

#ifdef INCLUDE_HTML
void html_header(GtkWidget *w, int data)
{
     char close[]="</H1>";
     switch(data)
     {
     case H1:
	  vanilla("<H1>");
	  vanilla("</H1>");
	  cursor_left_x_times(strlen(close));
	  break;
     case H2: 
	  vanilla("<H2>");
	  vanilla("</H2>");
	  cursor_left_x_times(strlen(close));
	  break;
     case H3: 
	  vanilla("<H3>");
	  vanilla("</H3>");
	  cursor_left_x_times(strlen(close));
	  break;
     case H4: 
	  vanilla("<H4>");
	  vanilla("</H4>");
	  cursor_left_x_times(strlen(close));
	  break;
     case H5: 
	  vanilla("<H5>");
	  vanilla("</H5>");
	  cursor_left_x_times(strlen(close));
	  break;
     case H6: 
	  vanilla("<H6>");
	  vanilla("</H6>");
	  cursor_left_x_times(strlen(close));
	  break;
     default:
	  vanilla("Oops.  Bad arg to html_header.  Please report as a bug.\n");
	  break;

     } /* End switch */
} /* End html_header */

void html_comment(void)
{
     char close[]=" ->";
     vanilla("<!-- ");
     vanilla(close);
     cursor_left_x_times(strlen(close));
} /* End html_comment() */

void html_strike(void)
{
     char close[] = "</STRIKE>";
     vanilla("<STRIKE>");
     vanilla(close);
     cursor_left_x_times(strlen(close));
} /* End html_strike() */

void html_nbsp(void)
{
     vanilla("&nbsp;");
} /* End html_nbsp() */

void html_super(void)
{
     char close[]="</SUP>";
     vanilla("<SUP>");
     vanilla(close);
     cursor_left_x_times(strlen(close));
} /* End html_super() */

void html_sub(void)
{
     char close[]="</SUB>";
     vanilla("<SUB>");
     vanilla(close);
     cursor_left_x_times(strlen(close));
} /* End html_sub() */

void html_close_unnamed(void)
{
     char close[]="</>";
     vanilla(close);
     cursor_left();
} /* End html_close_unnamed() */

void html_doctype(void)
{
     vanilla("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 3.2//EN\">\n");
} /* End html_doctype() */

void html_table(void)
{
     char close[]="</TABLE>\n";
     vanilla("<TABLE>\n");
     vanilla(close);
     cursor_left_x_times(strlen(close));
} /* End html_table() */

void html_pre(void)
{
     char close[]="</PRE>";
     vanilla("<PRE>\n");
     vanilla(close);
     cursor_left_x_times(strlen(close));
} /* End html_pre() */

void html_table_row(void)
{
     char close[]="</TR>";
     vanilla("<TR>\n");
     vanilla(close);
     cursor_left_x_times(strlen(close));
} /* End html_table_row() */

void html_internal(GtkWidget *e, gint type)
{
     char buf[512];

     switch(type)
     {
     case HTML_BGCOLOR:
	  sprintf(buf,"BGCOLOR=\"\"");
	  break;
     case HTML_TEXT:
	  sprintf(buf,"TEXT=\"\"");
	  break;
     case HTML_LINK:
	  sprintf(buf,"LINK=\"\"");
	  break;
     default:
	  sprintf(buf,"Error - no type specified. ");
	  break;
     } /* End switch */

     vanilla(buf);
     cursor_left();
} /* End html_internal */

void html_ssi(void)
{
     int x=4;
     vanilla("<!--#exec cgi=\"\"-->");
     while(x>0)
     {      cursor_left();    x--; } /* End while */
} /* End html_ssi() */

void html_www(void)
{
     vanilla("www");
} /* End html_www() */

void html_font_size(void)
{
     char close[] = "></FONT>";
     vanilla("<FONT SIZE=");
     vanilla(close);
     cursor_left_x_times(strlen(close));
} /* End html_font_size() */

void html_font_color(void)
{
     char close[]="\"></FONT>";
     vanilla("<FONT COLOR=\"#");
     vanilla(close);
     cursor_left_x_times(strlen(close));
} /* End html_font_color() */

void html_blink(void)
{
     char close[]="</BLINK> <!-- You should'nt use BLINK.  It's evil -->";
     vanilla("<BLINK>");
     vanilla(close);
     cursor_left_x_times(strlen(close));
} /* End html_blink() */

void html_table_data(void)
{
     char close[]="</TD>";
     vanilla("<TD>");
     vanilla(close);
     cursor_left_x_times(strlen(close));
} /* End html_table_data() */

void html_paragraph(void)
{
     vanilla("<P>");
} /* End html_paragraph() */

void html_list(void)
{
     char list[]="<UL>\n";
     char list1[]="\n</UL>";
     vanilla(list);
     vanilla(list1);
     cursor_left_x_times(strlen(list1));
} /* End html_list() */

void html_list_item(void)
{
     vanilla("<LI>");
} /* End html_list_item() */

void html_linebreak(void)
{
     vanilla("<BR>");
} /* End html_linebreak() */

void html_hr(void)
{
     vanilla("<HR>");
} /* End html_br() */

void html_http(void)
{
     vanilla("http://");
} /* End html_http() */

void html_mailto(void)
{
     vanilla("mailto:");
} /* End html_mailto() */

void html_news(void)
{
     vanilla("news:");
} /* End html_news() */

void html_telnet(void)
{
     vanilla("telnet://");
} /* End html_telnet() */

void html_gopher(void)
{
     vanilla("gopher://");
} /* End html_gopher() */

void html_ftp(void)
{
     vanilla("ftp://");
} /* End html_ftp() */

void html_bold(void)
{
     char bold[]="<B>";
     char bold1[]="</B>";
     vanilla(bold);
     vanilla(bold1);
     cursor_left_x_times(strlen(bold1));
} /* End html_bold() */

void html_em(void)
{
     char em[] = "<EM>";
     char em1[] = "</EM>";
     vanilla(em);
     vanilla(em1);
     cursor_left_x_times(strlen(em1));
} /* End html_em() */

void html_strong(void)
{
     char strong[]="<STRONG>";
     char strong1[]="</STRONG>";
     vanilla(strong);
     vanilla(strong1);
     cursor_left_x_times(strlen(strong1));
} /* End html_strong() */

void html_italics(void)
{
     char it[]="<I>";
     char it1[]="</I>";
     vanilla(it);
     vanilla(it1);
     cursor_left_x_times(strlen(it1));
} /* End html_italics() */

void html_center(void)
{
     char center[]="<CENTER>";
     char center1[]="</CENTER>";
     vanilla(center);
     vanilla(center1);
     cursor_left_x_times(strlen(center1));
} /* End html_center() */

void html_image(void)
{
     char img[]="<IMG SRC=\"\">";
     vanilla(img);
     cursor_left();
     cursor_left();
     cursor_left();
} /* End html_image() */

void html_link(void)
{
     char link[]="<A HREF=\"\"></A>";
     vanilla(link);
     /* Move back 6 spaces to start typing in link target location */
     cursor_left_x_times(4);
} /* End html_link() */

void html_html(void)
{
     char html[]="<HTML>\n";
     vanilla(html);
} /* End html_html() */

void html_html_close(void)
{
     vanilla("\n</HTML>");
} /* End html_html_close() */

void html_body(void)
{
     vanilla("<BODY>\n");
} /* End html_body() */

void html_head(void)
{
     vanilla("<HEAD>\n");
} /* End html_head() */

void html_head_close(void)
{
     vanilla("</HEAD>\n");
} /* End html_head_close() */

void html_title(void)
{
     char *close="</TITLE>";
     vanilla("<TITLE>");
     cursor_left_x_times(strlen(close));
} /* End html_title() */

void html_body_close(void)
{
     vanilla("</BODY>\n");
} /* End html_body_close() */

void html_template(void)
{
     char *one="<HTML>\n<HEAD>\n<TITLE>";
     char *two="Insert your title here</TITLE></HEAD>\n<BODY><P>Document\n</BODY>\n</HTML>\n\n";

     vanilla(one);
     vanilla(two);
     cursor_left_x_times(strlen(two));
} /* End html_template */

#endif /* INCLUDE_HTML */

/* Inserts the text input into output_text widget */
/* Yeah the function name is weird, but I just couldn't stop thinking about
 * plain vanilla text, as in, no colors, no weird fonts, etc.
 */

void vanilla(const char *input)
{
     char buffer[strlen(input) + 1];
     register int x=0;
     KeySym sym = NoSymbol;
     KEY *key;
     strcpy(buffer,input);

     if(options.redirect_window_name)
     {
	  /* This will probably bomb big time if strange characters get
	   * used in the string we got passed.
	   */
	  for(x=0; x<strlen(input); x++)
	  {
	       /* THIS IS AN INEXACT UGLY CONVERSION.  If you're looking for
		* a bug because something isn't displaying correctly, look
		* here.
		*/
	       sym = character_to_keysym(buffer[x]);

	       if(is_uppercase_key(options.keyboard, sym) || 
		  isupper(buffer[x]))
	       {
		    options.SHIFT = ON;    /* Will be turned off by itself */
	       } /* End if */
	       
	       /* Create a key with our desired keysyms */
	       key = gtkeyboard_new_key(sym, sym, sym, NULL);
	       keysym_callback((GtkWidget *)NULL, (gpointer)key);
	       key = gtkeyboard_destroy_key(key);
	  } /* End for */
     } /* End else */
     else
     {
	  if(GUI.main_output_text != (GtkWidget *)NULL)
	  {
	       FREEZE(GUI.main_output_text);
	       options.document_modified = ON;
	       gtk_text_insert(GTK_TEXT(GUI.main_output_text), NULL, 
			       NULL, NULL, input, strlen(input));
	       THAW(GUI.main_output_text);
	  } /* End if */
#ifdef DEBUGGING
	  else
	       g_warning("Fn vanilla: widget is NULL\n");
#endif /* DEBUGGING */
     } /* End else */
} /* End vanilla */

void chocolate(const char *input)
{
     char *error = "Null string sent to fn chocolate:  Did you select the root window to redirect output to?  If not, please notify s2mdalle@titan.vcu.edu of bug.\n\n";

     if(input)
     {
	  if(GUI.status && window && GTK_WIDGET_VISIBLE(window))
	       gtk_text_insert(GTK_TEXT(GUI.status), NULL, NULL, NULL,
			       input, strlen(input));
#ifdef DEBUGGING
	  else
	       g_warning("Fn chocolate:  widget is null\n");
#endif /* DEBUGGING */
     } /* End if */
     else
     {
	  if(GUI.status != (GtkWidget *)NULL && GTK_WIDGET_VISIBLE(window))
	       gtk_text_insert(GTK_TEXT(GUI.status), NULL, NULL, NULL,
			       error, strlen(error));
#ifdef DEBUGGING
	  else
	  {
	       g_warning(
		    "Fn chocolate() error:  GUI.main_output_text==NULL\n");
	       FLUSH_EVERYTHING;
	  } /* End else */
#endif /* DEBUGGING */
     } /* End else */
} /* End chocolate */

/* EOF */





