/* adt.h
 * For GTKeyboard
 * written by David Allen s2mdalle@titan.vcu.edu
 * http://opop.nols.com/
 *
 * This file is released under the terms of the GNU General Public License.
 * Please see COPYING for more details.
 */

#define ADT_H

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <errno.h>
#include <signal.h>
#include <ctype.h>
#include <assert.h>
#include <time.h>
#include <sys/time.h>

#include "user_shortcuts.h"

/* Maximum number of custom colors.  10 is a good number, above that is
 * really not needed per se.
 */
#define MAX_CUSTOM_COLORS         10

/**************************************************************************/

/* ADTs */
/* Program configuration settings */
typedef struct{
     /* Changed to bits in 0.97.3 to save a little space. */
     /* Different program options - initialized in app.c changed in 
      * file_manip.c and messed with elsewhere.
      *
      * See app.c and the initialization code for comments on what they 
      * all mean.
      */
     int REDIRECT_POLICY_IMPLICIT;
     int STATUS_LOGGING;
     int CAPS_LOCK;
     int IGNORE_LAYOUT_FILE;
     int SEND_TO_BOTH_WINDOWS;
     /* int ASK_REMAP_ON_EXIT;            -- Deprecated for now... */
     int BORDERLESS;
     int INFO_POPUPS;
     int SHIFT;
     int ALT_GR;
     int WORD_WRAP;
     int NUMLOCK;
     int ASK_SAVE_ON_EXIT;
     int SHOW_TOOLTIPS;
     int VERBOSE;
     int ALT;
     int CONTROL;
     int RANDOMIZE_XPMS;
     int SHOW_MENU;
     int USE_KEYBOARD;
     int RANDOM_STRING_CHARACTERS;

     int document_modified;
     
     void (*signal_handling)();   /* Function pointer for signal handling    */
     char *home;                  /* Home dir of user running the app.       */
     char *workingfile;           /* Current file. Name of file to save/open */
     char *tempslot;
     char *extrafiles;            /* Extra files, docs, default rcfile, lic. */
     char *redirect_window_name;  /* Window name of redirection location.    */
     char *keyboard_file;
     Window redirect_window;      /* Xlib window structure for redirection.  */
     Window other;                /* Temporary window structure for Xlib     */
     char *shortcuts[SHORTCUTS];  /* User defined shortcuts                  */

     int xpos;                    /* Startup position for the application */
     int ypos;
     int handlerid;               /* Timeout handlerID (follow_focus) */

     KEYBOARD *keyboard;
     KEYBOARD *old_keyboard;

     /* These memory areas won't be used unless PROD isn't defined.
      * When PROD isn't defined, we're not debugging, and they essentially
      * keep track of the number of memory calls that I make.  See also
      * mem_header.h for a full definition of how they're used.
      */
#if defined(GTKEYBOARD_MEMORY_DEBUGGING) || defined(DEBUGGING)
     long MEM;             /* Number of bytes allocated          */
     int gnew;             /* Number of gnew() calls (alloc)     */
     int gnew0;            /* Number of gnew0() calls (alloc)    */
     int gmalloc;          /* Number of g_malloc() calls (alloc) */
     int gstrdup;          /* Number of g_strdup() calls (alloc) */
     int gfree;            /* Number of g_free() calls (free)    */
#endif
} GTKeyboardOptions;

typedef struct {
     GtkWidget *cursor_keys;
     gint show_cursor_keys;
     GtkWidget *keyboard;
     gint show_keyboard;
     GtkWidget *f_keys;
     gint show_f_keys;
     GtkWidget *number_pad;
     gint show_number_pad;
} GTKeyboardKeyboardElements;

typedef struct {
     int toolbar;
     int menubar;
     int keyboard;
     int status;
     int text;
     int buttonbar;
} GTKeyboardElements;

/****************************************************************************/

typedef struct{
     Window xwindow;               /* So we can play with xlib. (our window) */
     GtkWidget *KEYBOARD;          /* Container containing all keyb elements */
     GtkWidget *menubar;
     GtkWidget *keyboard_socket;   /* Widget that keyboard gets stuck into   */
     GtkWidget *bottom_row_buttons;/* Self explanatory?                      */
     GtkWidget *mainbox;           /* main component, pack keyboard here     */
     GtkWidget *s_table;           /* Holds the status window (a table)      */
     GtkWidget *status;            /* Actually holds the status text window  */
     GtkWidget *toolbar;           /* Main toolbar in the main window        */
     GtkWidget *toolbar_gtktb;     /* Actually holds the GtkToolbar          */
     GtkWidget *main_output_text;  /* Holds actual text widget               */
     GtkWidget *master_text;       /* Main text widget - (really a table).   */

     int BUMP_AMOUNT;              /* Value in pixels the window gets bumped */

     int use_handleboxes;

     GTKeyboardKeyboardElements keyboard_elements;

     /* If a field has a comment of "Cleaned" next to it, then it is
      * either deallocated or destroyed in 
      * callbacks.c:gtkeyboard_mem_cleanup() via macro calls.
      */
     char *custom_colors[MAX_CUSTOM_COLORS];    /* Cleaned */
     gchar *fontname;                           /* Cleaned */
     gchar *kfontname;                          /* Cleaned */
     gchar *colorname;                          /* Cleaned */
     gdouble saved_colors[4]; 

     GtkShadowType SHADOW_TYPE;
     GtkPositionType PULLOFFS_SIDE;

     GtkItemFactory *item_factory;              /* Cleaned */
     GtkWidget *popup_menu;                     /* Cleaned */
     GdkCursor *cursor;
     GtkStyle *style;

     /* Style referring to the main output text area */
     GtkStyle *textstyle;                       /* Cleaned */

     /* The default GTK style */
     GtkStyle *deflt;                           /* Cleaned */

     GdkFont *font;                             /* Cleaned */
     
     /* The keyboard widget's style */
     GtkStyle *kstyle;                          /* Cleaned */

     /* Keyboard font */
     GdkFont *kfont;                            /* Cleaned */
     
     GtkTooltips *tooltips;
} GTKeyboardGUI;

/**************************************************************************/

/* ALL of these will be on by default. */
typedef struct{
     int TB_FONT;
     int TB_KEYBOARD_FONT;
     int TB_WINDOW_GRAB;
     int TB_WINDOW_IGNORE;
     int TB_RAISE;
     int TB_LOWER;
     int TB_CUT;
     int TB_COPY;
     int TB_PASTE;
     int TB_NEW;
     int TB_OPEN;
     int TB_SAVE;
     int TB_COLOR;
     int TB_STATUS_REPORT;
     int TB_RESET_STYLE;
     int TB_SHORTCUTS;
     int TB_POSITIONING;
} GTKeyboardToolbar;

typedef struct{
     int width;
     int height;
     int x;
     int y;
} window_dimensions;


