/* misc_cursor.h
 * For use with GTKeyboard
 * written by David Allen
 * s2mdalle@titan.vcu.edu
 * http://opop.nols.com/
 *
 * This file, along with all of GTKeyboard, is licensed under the terms of the
 * GNU General Public License - see COPYING for more details or www.gnu.org
 *
 */

#define MISC_CURSOR_H

#ifndef MASTER_H
#include "master.h"
#endif /* MASTER_H */

#define VLINE 87
#define CTEXT                GTK_TEXT(GUI.main_output_text)
#define GET_POINT            gtk_text_get_point(CTEXT)
#define GET_LENGTH           gtk_text_get_length(CTEXT)
#define SET_POINT(x)         gtk_text_set_point(CTEXT, x)

/* PROTOTYPES */
void update_screen_position                  (void);
void delete_line                             (void);
void cursor_left                             (void);
void cursor_right                            (void);
void cursor_up                               (void);
void cursor_down                             (void);
void cursor_right_x_times                    (size_t input);
void cursor_left_x_times                     (size_t input);
void toggle_wordwrap                         (void);
void toggle_numlock                          (GtkWidget *emitter, 
					      gpointer data);
void delete_key                              (GtkWidget *w, gpointer data);

/* Goto beginning/end of file/line */
void goto_eof                                (void);
void goto_bof                                (void);
void goto_eol                                (void);
void goto_bol                                (void);
