/* shortcuts.c
 * For use with GTKeyboard
 * written by David Allen
 * s2mdalle@titan.vcu.edu http://opop.nols.com/
 *
 * This is just a collection of shortcuts that will end up in a menu to make
 * typing faster.  All that is needed to add to this is to create a new 
 * function, prototype it in include/stylish.h and add a menu item for it
 * in include/ui.h
 *
 * The SC_ in the function names is for shortcut.
 */
/* GTKeyboard - A Graphical Keyboard For X
 * Copyright (C) 1999, 2000 David Allen  
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA  02111-1307, USA.
 */

#include "master.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <errno.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <errno.h>
#include <signal.h>
#include <ctype.h>
#include <time.h>
#include <sys/time.h>

#ifdef MEM_DEBUGGING
#include "mem/memdebug.h"
#endif /* MEM_DEBUGGING */

#ifndef RAND_MAX
#define RAND_MAX 1
#endif

#define SHORTCUTS_C

/* Functions - makes heavy use of vanilla defined in html_mode.c */
/* These should be functions rather than macros so they can be included
 * in the item factories - otherwise not constant complaints from gcc
 */
void SC_report_length(void)
{
     char buffer[512];
     long size = sizeof_text_widget(GUI.main_output_text);
     long KILOBYTE = 1024;

     sprintf(buffer,"Your text area contains %ld characters.",size);
     annoying_popup(buffer);
     gtkeyboard_message(1,buffer,"\n");
     sprintf(buffer,"%ld characters is roughly %ld kilobytes\n",size,
	     (size / KILOBYTE));
     gtkeyboard_message(1,buffer,"\n");
     return;
} /* End SC_report_length */

void SC_timestamp(void)
{
     time_t now;
     struct tm *ptr;
     char sucka[40];
     char *ptr2;
     
     ptr2=&sucka[0];
     
     time(&now);
     ptr=localtime(&now);
     ptr2=asctime(ptr);
     
     chocolate("Inserting timestamp\n");

     vanilla(ptr2);
     vanilla("\n");
} /* End SC_timestamp */

void SC_rose(void)
{
     vanilla(" @}-'-,- ");
} /* End SC_rose() */

void SC_random_string(void)
{
     /* I have NO earthly idea why anybody would use this, but hey, it's 
      * your life, your memory, your CPU.  I'm just here for fun.
      */

     int x=0;
     char Achar;
     char *foobar;
     char *tmp;
     static char choices[]="abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ1234567890-=!@#$%^&*()_+`~[]{}\\|,.<>/?";
     int RANDMAX = strlen(choices);
     char foo[1024];

     foobar = g_new0_(char, (options.RANDOM_STRING_CHARACTERS + 2));
     tmp    = g_new0_(char, 3);

#ifndef HAVE_RAND
#error "You don't have the rand() system call???  And you expect me to compile???"
#endif /* HAVE_RAND */
     
     sprintf(tmp,"%c",choices[(rand() % RANDMAX)]);
     strcpy(foobar,tmp);

     sprintf(foo,"Inserting random string of length %d\n",
	     options.RANDOM_STRING_CHARACTERS);
     gtkeyboard_message(1,foo);

     for(x=1; x<options.RANDOM_STRING_CHARACTERS; x++)
     {
	  Achar = choices[(rand() % RANDMAX)];

	  sprintf(tmp,"%c",Achar);
	  strcat(foobar,tmp);
     } /* End for */

     vanilla(foobar);

     g_free_(tmp);
     g_free_(foobar);
} /* End sc_random_string */

void SC_angle(void)
{
     vanilla("<>");
     cursor_left();
} /* End SC_angle() */

void SC_double_angle(void)
{
     vanilla("<<>>");
     cursor_left();
     cursor_left();
} /* End SC_double_angle() */

void SC_paragraph(void)
{
     vanilla("\n\n\t");
} /* End SC_paragraph() */
 
void SC_hihat(void)
{
     vanilla("^^");
     cursor_left();
} /* End SC_hihat() */

void SC_smiley(void)
{
     vanilla(":)");
} /* End SC_smiley() */

void SC_winky(void)
{
     vanilla(";)");
} /* End SC_winky() */

void SC_quote(void)
{
     vanilla("\"\"");
     cursor_left();
} /* End SC_quote() */

void SC_single_quote(void)
{
     vanilla("''");
     cursor_left();
} /* End SC_single_quote() */

void SC_book_quote(void)
{
     vanilla("`'");
     cursor_left();
} /* End SC_book_quote() */

void SC_backquote(void)
{
     vanilla("``");
     cursor_left();
} /* End SC_backquote() */

void SC_pseudo_underline(void)
{
     vanilla("__");
     cursor_left();
} /* End SC_pseudo_underline() */

void SC_emphasize(void)
{
     vanilla("**");
     cursor_left();
} /* End SC_emphasize() */

void SC_surround(void)
{
     char *sur="--==";
     char *sur2="==--";
     int x;
     
     vanilla(sur);
     vanilla(sur2);
     for(x=0; x<strlen(sur2); x++)
	  cursor_left();
} /* End SC_surround() */

void SC_parens(void)
{
     vanilla("()");
     cursor_left();
} /* End SC_parens() */

/* EOF */
