/* completer.h
 * Written by David Allen
 * <s2mdalle@titan.vcu.edu> http://opop.nols.com/
 * 
 * Released under the terms of the GNU General Public License
 */

#define COMPLETER_H

#ifndef __USE_GNU
#  define __USE_GNU
#endif /* __USE_GNU */

#define ISBLANK(f)                       (f == ' ' || f == '\t' || \
                                          f == '\n' || f == '\r' || \
                                          f == '\v')

#define MAX_COMPLETION_SLOTS                         10

/* This isn't really the maximum word length supported, but the length
 * where words longer than it have practically 0 chance of being completed
 * and should thus be treated just like normal words that will be typed out
 * by the user.
 */
#define MAX_WORD_LENGTH                     10

#define DEFAULT_CACHE_FILENAME              "cache/general-english.cache"

void cacheify_file_dialog                  (GtkWidget *emitter, gpointer data);

/* From is the filename to convert, to is the filename to save the new cache
 * as, and if all_lowercase is true, then words like 'Hello' will be converted
 * to 'hello' for the cache (all lowercase)
 */
int cacheify_file                          (char *from, char *to, 
                                            int all_lowercase);
void completer_update_display              (void);
void completer_eavesdrop_on_letter         (KeySym sym);
void destroy_completer_window              (GtkWidget *emitter, gpointer data);
void completer_window_new                  (void);
