/*
 * Name          : uks.h
 * Author        : Ata Etemadi
 * Institution   : Imperial College of Science, Technology, and Medicine
 * Written on    : Thu Jan 28 17:09:12 1993
 * Modified on   : Sun Dec 11 1994 by A.Fedorov
 * Description   : Define UKS specific constants and functions.
 *
 */
/* ATTRIBUTES NAMES DEFINITIONS */
#define MODENAME "Mode"            /* Mode is string meaning:
                                    * "orbit" -orbit data
                                    * "MF0125" - IMF 125ms resolution
                                    * "MF5000" - IMF 5 sec averaging
                                    */
#define LIMITNAME "TimeLimits"      /* TimeLimits is string meaning
                                    *  Start time UT End time UT of
                                    *  this file in standard for
                                    *  uks nc files notation:
                                    *  yyyydddhhmmss.msc
                                    */
/* CONSTANT DEFINITIONS */
#define LIMITLEN 36                 /* Together with \0 */
#define MODELEN 7                   /* Length of Mode attribute */
#define UTLEN 18                    /* Length of UniversalTime string */
#define NAMELEN 16

#define MAXCHAR    132
#define ERROR_FLAG 999

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
 *                      T Y P E S
 *-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/

/*
 * UKS magnetometer data (magnetic field and orbit) record
 */

struct pips_Time
{
 double timems;      /* time ms from 1980y */
 int year;
 int day;
 int hour;
 int min;
 int sec;
 int msec;
};

struct AMPUFGMRecord {

 struct pips_Time UT;

 int Type;         /* Type of UKS Bfield record                            */
                   /*  1 = x,y,z, GSE position in RE                       */
                   /*  2 = Full res. x,y,z, GSE field values in nT         */
                   /*  3 = 5 sec. average.                                 */
                   /*  4 = Other than 5 sec average x,y,z, GSE field value */
 float x,y,z;      /* UKS data depending on Type                           */

};

struct uksvar         /* Structure holding information about variables */
{
   char    name[NAMELEN];  /* Name of variable */
   int     Id;        /*Id of variable */
   nc_type datatype;  /* netCDF datatype */
   void *fillvalue;   /* Pointer for fillvalue */
};                    /* This is just a tag */

struct _ModeAttr       /* The attributes or DataMode
                       * Not all attributes includes into netCDF file */
{
   /* Mode global attribute */
   char     ModeName[MODELEN]; /*"Orbit ", MF0125, MF5000 are possible */
   double   timeres;   /*time resulution in ms */
   double   timetoller; /* time tolleranse  - the interval about time of
                       * measurement to deside, is there the valid value,
                       * or fill value need */

   /* TimeLimit global attribute */
   char TimeLimit[LIMITLEN]; /* Start Time and End Time of File
                        * "yyyydddhhmmss.msc yyyydddhhmmss.msc\0" */
   double StartTime;
   double EndTime;     /* In ms from 1980 g */
};

struct _UKSdim         /* definition of unlimited dimension of record vars*/
{
    char DimName[NAMELEN];
    int  DimId;
};

/*--------------- End of UKS.H -----------------------------*/
