/* PIPS version 1.01: Parallel Information Processing System 
   Copyright (C) 1994, 95, 96 Free Software Foundation, Inc.

This file is part of GNU PIPS.

GNU PIPS is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

GNU PIPS is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU PIPS; see the file COPYING.  If not, write to
the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA.
*/

/*
 * Name          : pips/src/pipsNewFlagArray.c
 * Author        : Frank Heimes
 * Institution   : Imperial College of Science, Technology, and Medicine
 * Written on    : Thu Oct 13 21:36:52 WET DST 1994
 * Modified on   : 
 * Synopsis      : 
 *
 *   int *pipsNewFlagArray (size, initValue)
 *
 *   int size         IS   The number of flags, the array will contain
 *   int initValue    IS   The value that should be put into the array
 *
 * Description   : 
 *
 *   Allocates 'size' elements of memory, stores 'initvalue' in them
 *   and returns a pointer to the location.
 */

#include "pips.h"   /* PIPS system header file  */

#ifdef __STDC__

int *pipsNewFlagArray (int size, int initValue)

#else

pipsNewFlagArray (size, initValue)
    int size;
    int initValue;

#endif

{
  int *flags = NULL;    /* New array with 'size' flags */
  int i;                /* Index to flags[]            */

/*
 * Allocate Memory for 'size' integers
 */
  flags = (int *) malloc (size * sizeof (int));

/*
 * Set all values initially to 'initValue'
 */
  for (i = 0; i < size; i++)
    flags [i] = initValue;

  return (flags);
} /* pipsNewFlagArray */


/* end pipsNewFlagArray.c */
