/* Source Installer, Copyright (c) 2005,2006,2007 Claudio Fontana

 gui.h - header for interface fundamentals

 This program is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published by
 the Free Software Foundation; either version 3 of the License, or
     (at your option) any later version.

 This program is distributed in the hope that it will be useful,
     but WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
     along with this program (look for the file called COPYING);
     if not, write to the Free Software Foundation, Inc.,
         51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

     You can contact the author (Claudio Fontana) by sending a mail
     to claudio@gnu.org
*/

#ifndef GUI_H
#define GUI_H

enum {
    W_SPLASH,

    W_MAIN,
    W_MAIN_CONTENT, W_MAIN_PANE, W_MAIN_MENUBAR,

    W_MAIN_N
};

extern GtkWidget *w_main[W_MAIN_N];
extern GtkAccelGroup *acc;

void gui_splash(void);
void gui_unsplash(void);

void gui_init(void);
void gui_show(void);
void gui_set_default_size(void);
void gui_maybe_quit(void);

void gui_doevents(char *unused);
void gui_update(void);

void gui_action_add(GtkWidget * w, gpointer data);
void gui_action_remove(GtkWidget * w, gpointer data);
void gui_action_install(GtkWidget * w, gpointer data);
void gui_action_uninstall(GtkWidget * w, gpointer data);
void gui_action_upgrade(GtkWidget * w, gpointer data);

void gui_action_about(GtkWidget * widget, gpointer data);
void gui_action_pref(GtkWidget * widget, gpointer data);
void gui_action_default_size(GtkWidget * unused_w, gpointer unused_d);
void gui_action_export_all(GtkWidget * w, gpointer data);
void gui_action_export_info(GtkWidget * w, gpointer data);
void gui_action_export_bin(GtkWidget * w, gpointer data);

void gui_action_savelog(GtkWidget * w, gpointer unused_data);

void gui_action_stop(GtkWidget * w, gpointer data);

gboolean gui_delete_event(GtkWidget * w, GdkEvent * e, gpointer data);
void gui_destroy(GtkWidget * w, gpointer data);

#endif				/* GUI_H */
