/*
 *   Copyright (C) 1997, 1998, 1999 Loic Dachary
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
#ifndef _WebbaseGetopt_h
#define _WebbaseGetopt_h

#include <getopt.h>
#include <hash.h>

class WebbaseGetopt {
 public:
  WebbaseGetopt();
  virtual ~WebbaseGetopt();

  //
  // Return the array describing the options for this particular package
  //
  virtual struct option* Options() = 0;
  //
  // Generic loop parsing options specific to this package.
  // Call handle_option for each option found.
  //
  void Parse(int argc, char** argv);
  //
  // Handle an option. Returns 1 if the option was recognized
  // or 0 if it was not. If the option was recognized, it is 
  // memorized.
  //
  virtual int HandleOption(struct option* option) { return 0; }

  //
  // Helpers
  //
  //
  // Push options <from> in <to> array.
  //
  static void Merge(struct option to[], struct option from[]);
  //
  // Print the content of <options> on standard output
  //
  static void WebbaseGetopt::Dump(struct option options[]);

  //
  // Archive of options found by Parse
  //
  hash_t* options;
};

#endif /* _WebbaseGetopt_h */
