/*
 *   Copyright (C) 1997, 1998, 1999 Loic Dachary
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */
#ifndef _html_content_h
#define _html_content_h

#include <uri.h>
#include <html_parser.h>

#ifdef __cplusplus
extern "C" {
#endif

/*
 * Possible values of the info callback argument
 */
#define HTML_CONTENT_METANAME		0x01
#define HTML_CONTENT_METACONTENT	0x02
#define HTML_CONTENT_TITLE		0x04
#define HTML_CONTENT_TEXT		0x08
/*
 * Short hand
 */
#define HTML_CONTENT_META		(HTML_CONTENT_METANAME|HTML_CONTENT_METACONTENT)

typedef struct html_content_parsed {
  char* buffer0;
  int buffer0_length;
  int buffer0_size;
  char* buffer1;
  int buffer1_length;
  int buffer1_size;
} html_content_parsed_t;

typedef int (*html_content_callback_t)(int info, html_content_parsed_t* parsed, void* data);

/*
 * Completely define the context of parsing. 
 */
typedef struct html_content {
  html_parser_t parser;
  /*
   * Additional values for html_content_t info field
   */
  /*
   * Strip accents when found
   */
#define HTML_UNACCENT			0x0100
  /*
   * Called whenever a href is recognized
   */
  html_content_callback_t content_callback;
  void* content_data;

} html_content_t;

/*
 * Initialize the arg structure.
 */
void html_content_reset(html_content_t* arg);

/*
 * Translate a string HTML_* into the corresponding
 * token integer.
 */
int html_content_string2token(char* string, int string_length);
/*
 * Translate a token (one or more values) into a readable string.
 */
char* html_content_token2string(int token);

/*
 * Run the href parser according to arg specifications (see above)
 */
int html_content_parse(html_content_t* arg);

/*
 * Main loop for standalone parsers.
 */
int html_content_main(int ac, char **av);

#ifdef __cplusplus
}
#endif

#endif /* _html_content_h */
