#include <stdio.h>
#include <stdarg.h>

int si_debug = 1;
int si_verbose = 1;


int dbg(char * fmt, ...)
{
	va_list ap;
	int ret = 0;

	if (si_debug) {
		va_start(ap, fmt);
		printf("*D: ");
		ret = vprintf(fmt, ap);
		va_end(ap);
	}
	return ret;
}

int vrb(char * fmt, ...)
{
	va_list ap;
	int ret = 0;

	if (si_verbose) {
		va_start(ap, fmt);
		printf("*V: ");
		ret = vprintf(fmt, ap);
		va_end(ap);
	}
	return ret;
}

int err(char * fmt, ...)
{
	va_list ap;
	int ret;
	
	va_start(ap, fmt);
	fprintf(stderr, "*E: ");
	ret = vfprintf(stderr, fmt, ap);
	va_end(ap);

	return ret;
}


