#ifndef _UTIL_H_
#define _UTIL_H_

extern int dbg(char * fmt, ...) 
	__attribute__((format (printf, 1, 2)));
extern int vrb(char * fmt, ...) 
	__attribute__((format (printf, 1, 2)));
extern int err(char * fmt, ...) 
	__attribute__((format (printf, 1, 2)));

extern int si_debug;
extern int si_verbose;


struct record {
	size_t		r_len;
	char		* r_str;
};

struct record_col {
	int		rc_depth;
	int		rc_num;
	int		rc_used;
	char		* rc_name;
	char		* rc_suf;

	char		* rc_first;

	struct record	* rc_records;

	struct record_col	* rc_prev;
	struct record_col	* rc_next;
};


struct si_action;

extern void rc_add(struct si_action * a, struct record_col * rc);
extern void rc_del(struct record_col * rc);

extern int rc_init(struct record_col * rc, int num);
extern void rc_exit(struct record_col * rc);

extern int record_add(struct record_col * rc, char * fmt, ...)
	__attribute__((format (printf, 2, 3)));
extern void record_del(struct record_col * rc);

extern int record_add_pos(struct record_col * rc, int pos, char * fmt, ...)
	__attribute__((format (printf, 3, 4)));
extern void record_del_pos(struct record_col * rc, int pos);

extern int record_find(struct record_col * rc, char * rec);
extern void record_prune(struct record_col * rc, char * rec);

extern int record_first(struct record_col * rc, char * fmt, ...);

extern int record_children(struct si_action * a, struct record_col * rc);
extern int record_attributes(struct si_action * a, struct record_col * rc);
extern int record_links(struct si_action * a, struct record_col * rc);

extern int format_attributes(struct si_action * a, struct record_col * rc,
			     struct sysfs_attr_list * sal);
extern int read_attributes(struct si_action * a, struct record_col * rc);


int record_sol(struct sysfs_object_list * sol, struct record_col * rc);
int record_sal(struct sysfs_attr_list * sal, struct record_col * rc);
int record_sll(struct sysfs_link_list * sll, struct record_col * rc);


#endif	/* _UTIL_H_ */
