/* Generated automatically by the program 'build/genpreds'
   from the machine description file '/home/arnd/git/gcc/gcc/config/c6x/c6x.md'.  */

#ifndef GCC_TM_PREDS_H
#define GCC_TM_PREDS_H

#ifdef HAVE_MACHINE_MODES
extern int general_operand (rtx, machine_mode);
extern int address_operand (rtx, machine_mode);
extern int register_operand (rtx, machine_mode);
extern int pmode_register_operand (rtx, machine_mode);
extern int scratch_operand (rtx, machine_mode);
extern int immediate_operand (rtx, machine_mode);
extern int const_int_operand (rtx, machine_mode);
extern int const_double_operand (rtx, machine_mode);
extern int nonimmediate_operand (rtx, machine_mode);
extern int nonmemory_operand (rtx, machine_mode);
extern int push_operand (rtx, machine_mode);
extern int pop_operand (rtx, machine_mode);
extern int memory_operand (rtx, machine_mode);
extern int indirect_operand (rtx, machine_mode);
extern int ordered_comparison_operator (rtx, machine_mode);
extern int comparison_operator (rtx, machine_mode);
extern int reg_or_const_int_operand (rtx, machine_mode);
extern int const_vector_operand (rtx, machine_mode);
extern int scst5_operand (rtx, machine_mode);
extern int reg_or_ucst4_operand (rtx, machine_mode);
extern int reg_or_scst5_operand (rtx, machine_mode);
extern int reg_or_ucst5_operand (rtx, machine_mode);
extern int addsi_operand (rtx, machine_mode);
extern int andsi_operand (rtx, machine_mode);
extern int iorsi_operand (rtx, machine_mode);
extern int insv_operand (rtx, machine_mode);
extern int c6x_jump_operand (rtx, machine_mode);
extern int c6x_call_operand (rtx, machine_mode);
extern int symbolic_operand (rtx, machine_mode);
extern int const_int_or_symbolic_operand (rtx, machine_mode);
extern int adda_scale_operand (rtx, machine_mode);
extern int suba_scale_operand (rtx, machine_mode);
extern int predicate_operator (rtx, machine_mode);
extern int c6x_comparison_operator (rtx, machine_mode);
extern int non_c6x_comparison_operator (rtx, machine_mode);
extern int c6x_fp_comparison_operator (rtx, machine_mode);
extern int c6x_any_comparison_operand (rtx, machine_mode);
extern int ltugtu_operator (rtx, machine_mode);
extern int eqltgt_operator (rtx, machine_mode);
extern int eqne_operator (rtx, machine_mode);
extern int predicate_register (rtx, machine_mode);
extern int a_register (rtx, machine_mode);
extern int b_register (rtx, machine_mode);
extern int pic_register_operand (rtx, machine_mode);
extern int sdata_symbolic_operand (rtx, machine_mode);
#endif /* HAVE_MACHINE_MODES */

#define CONSTRAINT_NUM_DEFINED_P 1
enum constraint_num
{
  CONSTRAINT__UNKNOWN = 0,
  CONSTRAINT_r,
  CONSTRAINT_a,
  CONSTRAINT_b,
  CONSTRAINT_A,
  CONSTRAINT_B,
  CONSTRAINT_C,
  CONSTRAINT_Da,
  CONSTRAINT_Db,
  CONSTRAINT_Z,
  CONSTRAINT_z,
  CONSTRAINT_Iu4,
  CONSTRAINT_Iu5,
  CONSTRAINT_In5,
  CONSTRAINT_Is5,
  CONSTRAINT_I5x,
  CONSTRAINT_Iux,
  CONSTRAINT_IuB,
  CONSTRAINT_IsB,
  CONSTRAINT_IsC,
  CONSTRAINT_JA,
  CONSTRAINT_JB,
  CONSTRAINT_Jc,
  CONSTRAINT_Js,
  CONSTRAINT_m,
  CONSTRAINT_o,
  CONSTRAINT_Q,
  CONSTRAINT_R,
  CONSTRAINT_T,
  CONSTRAINT_W,
  CONSTRAINT_p,
  CONSTRAINT_S0,
  CONSTRAINT_S1,
  CONSTRAINT_S2,
  CONSTRAINT_Si,
  CONSTRAINT_V,
  CONSTRAINT__l,
  CONSTRAINT__g,
  CONSTRAINT_i,
  CONSTRAINT_s,
  CONSTRAINT_n,
  CONSTRAINT_E,
  CONSTRAINT_F,
  CONSTRAINT_X,
  CONSTRAINT_S3,
  CONSTRAINT__LIMIT
};

extern enum constraint_num lookup_constraint_1 (const char *);
extern const unsigned char lookup_constraint_array[];

/* Return the constraint at the beginning of P, or CONSTRAINT__UNKNOWN if it
   isn't recognized.  */

static inline enum constraint_num
lookup_constraint (const char *p)
{
  unsigned int index = lookup_constraint_array[(unsigned char) *p];
  return (index == UCHAR_MAX
          ? lookup_constraint_1 (p)
          : (enum constraint_num) index);
}

extern bool (*constraint_satisfied_p_array[]) (rtx);

/* Return true if X satisfies constraint C.  */

static inline bool
constraint_satisfied_p (rtx x, enum constraint_num c)
{
  int i = (int) c - (int) CONSTRAINT_Iu4;
  return i >= 0 && constraint_satisfied_p_array[i] (x);
}

static inline bool
insn_extra_register_constraint (enum constraint_num c)
{
  return c >= CONSTRAINT_r && c <= CONSTRAINT_z;
}

static inline bool
insn_extra_memory_constraint (enum constraint_num c)
{
  return c >= CONSTRAINT_m && c <= CONSTRAINT_W;
}

static inline bool
insn_extra_special_memory_constraint (enum constraint_num)
{
  return false;
}

static inline bool
insn_extra_address_constraint (enum constraint_num c)
{
  return c >= CONSTRAINT_p && c <= CONSTRAINT_p;
}

static inline void
insn_extra_constraint_allows_reg_mem (enum constraint_num c,
				      bool *allows_reg, bool *allows_mem)
{
  if (c >= CONSTRAINT_S0 && c <= CONSTRAINT_Si)
    return;
  if (c >= CONSTRAINT_V && c <= CONSTRAINT__g)
    {
      *allows_mem = true;
      return;
    }
  (void) c;
  *allows_reg = true;
  *allows_mem = true;
}

static inline size_t
insn_constraint_len (char fc, const char *str ATTRIBUTE_UNUSED)
{
  switch (fc)
    {
    case 'D': return 2;
    case 'I': return 3;
    case 'J': return 2;
    case 'S': return 2;
    default: break;
    }
  return 1;
}

#define CONSTRAINT_LEN(c_,s_) insn_constraint_len (c_,s_)

extern enum reg_class reg_class_for_constraint_1 (enum constraint_num);

static inline enum reg_class
reg_class_for_constraint (enum constraint_num c)
{
  if (insn_extra_register_constraint (c))
    return reg_class_for_constraint_1 (c);
  return NO_REGS;
}

extern bool insn_const_int_ok_for_constraint (HOST_WIDE_INT, enum constraint_num);
#define CONST_OK_FOR_CONSTRAINT_P(v_,c_,s_) \
    insn_const_int_ok_for_constraint (v_, lookup_constraint (s_))

enum constraint_type
{
  CT_REGISTER,
  CT_CONST_INT,
  CT_MEMORY,
  CT_SPECIAL_MEMORY,
  CT_ADDRESS,
  CT_FIXED_FORM
};

static inline enum constraint_type
get_constraint_type (enum constraint_num c)
{
  if (c >= CONSTRAINT_p)
    {
      if (c >= CONSTRAINT_S0)
        return CT_FIXED_FORM;
      return CT_ADDRESS;
    }
  if (c >= CONSTRAINT_m)
    return CT_MEMORY;
  if (c >= CONSTRAINT_Iu4)
    return CT_CONST_INT;
  return CT_REGISTER;
}
#endif /* tm-preds.h */
