# Before `make install' is performed this script should be runnable with
# `make test'. After `make install' it should work as `perl 1.t'

#########################

# change 'tests => 1' to 'tests => last_test_to_print';

use Test::More tests => 28;
BEGIN { use_ok('Lingua::PT::Inflect') };

#########################

# Insert your test code below, the Test::More module is use()ed here so read
# its man page ( perldoc Test::More ) for help writing this test script.

my %words = (
  '' => '',

  'mesa' => 'mesas',
  'pai' => 'pais',

  'flor' => 'flores',
  'lquene' => 'lquenes',
  'pas' => 'pases',
  'raz' => 'razes',

  'mo' => 'mos',
  'co' => 'ces',
  'leo' => 'lees',

  'homem' => 'homens',
  'tom' => 'tons',

  'casal' => 'casais',
  'boi' => 'bois',
  'paul' => 'pauis',

  'anel' => 'anis',
  'farol' => 'faris',

  'funil' => 'funis',
  'barril' => 'barris',

  'rptil' => 'rpteis',
  'fssil' => 'fsseis',

  'gas' => 'gases',
  'francs' => 'franceses',

  'lpis' => 'lpis',
  'pires' => 'pires',
  'prex' => 'prex',
  'inox' => 'inox',
);

for my $word (keys %words) {
  is(sing2plural($word),$words{$word});
}
