# Generated by default/object.tt
package Paws::Macie2::ObjectCountByEncryptionType;
  use Moose;
  has CustomerManaged => (is => 'ro', isa => 'Int', request_name => 'customerManaged', traits => ['NameInRequest']);
  has KmsManaged => (is => 'ro', isa => 'Int', request_name => 'kmsManaged', traits => ['NameInRequest']);
  has S3Managed => (is => 'ro', isa => 'Int', request_name => 's3Managed', traits => ['NameInRequest']);
  has Unencrypted => (is => 'ro', isa => 'Int', request_name => 'unencrypted', traits => ['NameInRequest']);
  has Unknown => (is => 'ro', isa => 'Int', request_name => 'unknown', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::ObjectCountByEncryptionType

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::ObjectCountByEncryptionType object:

  $service_obj->Method(Att1 => { CustomerManaged => $value, ..., Unknown => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::ObjectCountByEncryptionType object:

  $result = $service_obj->Method(...);
  $result->Att1->CustomerManaged

=head1 DESCRIPTION

Provides information about the number of objects that are in an S3
bucket and use certain types of server-side encryption, use client-side
encryption, or aren't encrypted.

=head1 ATTRIBUTES


=head2 CustomerManaged => Int

The total number of objects that are encrypted with a customer-managed
key. The objects use customer-provided server-side encryption (SSE-C).


=head2 KmsManaged => Int

The total number of objects that are encrypted with an Key Management
Service (KMS) customer master key (CMK). The objects use Amazon Web
Services managed KMS encryption (AWS-KMS) or customer managed KMS
encryption (SSE-KMS).


=head2 S3Managed => Int

The total number of objects that are encrypted with an Amazon S3
managed key. The objects use Amazon S3 managed encryption (SSE-S3).


=head2 Unencrypted => Int

The total number of objects that aren't encrypted or use client-side
encryption.


=head2 Unknown => Int

The total number of objects that Amazon Macie doesn't have current
encryption metadata for. Macie can't provide current data about the
encryption settings for these objects.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

