#!/usr/bin/perl

# Unit testing for PPI, generated by Test::Inline

use strict;
use File::Spec::Functions ':ALL';
BEGIN {
	$|  = 1;
	$^W = 1;
	$PPI::XS_DISABLE = 1;
	$PPI::XS_DISABLE = 1; # Prevent warning
}
use PPI;

# Execute the tests
use Test::More tests => 2;

# =begin testing hash_constructors_dont_contain_packages_rt52259 2
{
my $Document = PPI::Document->new(\<<'END_PERL');
{    package  => "", };
+{   package  => "", };
{   'package' => "", };
+{  'package' => "", };
{   'package' ,  "", };
+{  'package' ,  "", };
END_PERL

isa_ok( $Document, 'PPI::Document' );

my $packages = $Document->find('PPI::Statement::Package');
my $test_name = 'Found no package statements in hash constructors - RT #52259';
if (not $packages) {
	pass $test_name;
} elsif ( not is(scalar @{$packages}, 0, $test_name) ) {
	diag 'Package statements found:';
	diag $_->parent()->parent()->content() foreach @{$packages};
}
}


1;
