/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.util.Map;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.Platform;

public class DesiredCapabilities
extends MutableCapabilities {
    public DesiredCapabilities(String browser, String version, Platform platform) {
        this.setCapability("browserName", browser);
        this.setCapability("version", version);
        this.setCapability("platform", platform);
    }

    public DesiredCapabilities() {
    }

    public DesiredCapabilities(Map<String, ?> rawMap) {
        if (rawMap == null) {
            return;
        }
        rawMap.forEach(this::setCapability);
    }

    public DesiredCapabilities(Capabilities other) {
        this.merge(other);
    }

    public DesiredCapabilities(Capabilities ... others) {
        for (Capabilities caps : others) {
            this.merge(caps);
        }
    }

    public void setBrowserName(String browserName) {
        this.setCapability("browserName", browserName);
    }

    public void setVersion(String version) {
        this.setCapability("version", version);
    }

    public void setPlatform(Platform platform) {
        this.setCapability("platform", platform);
    }

    public void setJavascriptEnabled(boolean javascriptEnabled) {
        this.setCapability("javascriptEnabled", javascriptEnabled);
    }

    public boolean acceptInsecureCerts() {
        if (this.getCapability("acceptInsecureCerts") != null) {
            Object raw = this.getCapability("acceptInsecureCerts");
            if (raw instanceof String) {
                return Boolean.parseBoolean((String)raw);
            }
            if (raw instanceof Boolean) {
                return (Boolean)raw;
            }
        }
        return true;
    }

    public void setAcceptInsecureCerts(boolean acceptInsecureCerts) {
        this.setCapability("acceptInsecureCerts", acceptInsecureCerts);
    }

    @Override
    public DesiredCapabilities merge(Capabilities extraCapabilities) {
        super.merge(extraCapabilities);
        return this;
    }

    public static DesiredCapabilities android() {
        return new DesiredCapabilities("android", "", Platform.ANDROID);
    }

    public static DesiredCapabilities chrome() {
        return new DesiredCapabilities("chrome", "", Platform.ANY);
    }

    public static DesiredCapabilities firefox() {
        DesiredCapabilities capabilities = new DesiredCapabilities("firefox", "", Platform.ANY);
        capabilities.setCapability("acceptInsecureCerts", true);
        return capabilities;
    }

    public static DesiredCapabilities htmlUnit() {
        return new DesiredCapabilities("htmlunit", "", Platform.ANY);
    }

    public static DesiredCapabilities edge() {
        return new DesiredCapabilities("MicrosoftEdge", "", Platform.WINDOWS);
    }

    public static DesiredCapabilities internetExplorer() {
        DesiredCapabilities capabilities = new DesiredCapabilities("internet explorer", "", Platform.WINDOWS);
        capabilities.setCapability("ensureCleanSession", true);
        return capabilities;
    }

    public static DesiredCapabilities iphone() {
        return new DesiredCapabilities("iPhone", "", Platform.MAC);
    }

    public static DesiredCapabilities ipad() {
        return new DesiredCapabilities("iPad", "", Platform.MAC);
    }

    @Deprecated
    public static DesiredCapabilities opera() {
        return new DesiredCapabilities("opera", "", Platform.ANY);
    }

    public static DesiredCapabilities operaBlink() {
        return new DesiredCapabilities("operablink", "", Platform.ANY);
    }

    public static DesiredCapabilities safari() {
        return new DesiredCapabilities("safari", "", Platform.MAC);
    }

    @Deprecated
    public static DesiredCapabilities phantomjs() {
        return new DesiredCapabilities("phantomjs", "", Platform.ANY);
    }
}

