#! /usr/bin/perl -w
################################################################################
#
# rib.t (Test the PML 'replace if blank' function)
#
################################################################################
#
# Includes
#
################################################################################
use strict;
use Test;
################################################################################
#
# Setup
#
################################################################################
BEGIN {
	plan test => 4
} use PML;
################################################################################
#
# Start
#
################################################################################
my ($parser, @code, $output);

$parser = new PML;
@code = <DATA>;
$parser->parse(\@code); ok(1);
$output = $parser->execute;

if ($output =~ /0/) {
	ok(0);
} else {
	ok(1);
}

foreach (1..2) {
	if ($output =~ /$_/) {
		ok(1);
	} else {
		ok(0);
	}
}
################################################################################
#                              END-OF-SCRIPT                                   #
################################################################################
__END__
#
# This is PML for Testing
#
#
# 0 is bad and numbers are good

@rib(1) {}
@rib(0) {2}
