# Generated by default/object.tt
package Paws::DMS::EndpointSetting;
  use Moose;
  has Applicability => (is => 'ro', isa => 'Str');
  has EnumValues => (is => 'ro', isa => 'ArrayRef[Str|Undef]');
  has IntValueMax => (is => 'ro', isa => 'Int');
  has IntValueMin => (is => 'ro', isa => 'Int');
  has Name => (is => 'ro', isa => 'Str');
  has Sensitive => (is => 'ro', isa => 'Bool');
  has Type => (is => 'ro', isa => 'Str');
  has Units => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::DMS::EndpointSetting

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DMS::EndpointSetting object:

  $service_obj->Method(Att1 => { Applicability => $value, ..., Units => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DMS::EndpointSetting object:

  $result = $service_obj->Method(...);
  $result->Att1->Applicability

=head1 DESCRIPTION

Endpoint settings.

=head1 ATTRIBUTES


=head2 Applicability => Str

The relevance or validity of an endpoint setting for an engine name and
its endpoint type.


=head2 EnumValues => ArrayRef[Str|Undef]

Enumerated values to use for this endpoint.


=head2 IntValueMax => Int

The maximum value of an endpoint setting that is of type C<int>.


=head2 IntValueMin => Int

The minimum value of an endpoint setting that is of type C<int>.


=head2 Name => Str

The name that you want to give the endpoint settings.


=head2 Sensitive => Bool

A value that marks this endpoint setting as sensitive.


=head2 Type => Str

The type of endpoint. Valid values are C<source> and C<target>.


=head2 Units => Str

The unit of measure for this endpoint setting.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DMS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

