/*
This file is part of Ext JS 3.4

Copyright (c) 2011-2013 Sencha Inc

Contact:  http://www.sencha.com/contact

GNU General Public License Usage
This file may be used under the terms of the GNU General Public License version 3.0 as
published by the Free Software Foundation and appearing in the file LICENSE included in the
packaging of this file.

Please review the following information to ensure the GNU General Public License version 3.0
requirements will be met: http://www.gnu.org/copyleft/gpl.html.

If you are unsure which license is appropriate for your use, please contact the sales department
at http://www.sencha.com/contact.

Build date: 2013-04-03 15:07:25
*/
Ext.data.JsonP.Ext_XTemplate({"alternateClassNames":[],"aliases":{},"enum":null,"parentMixins":[],"tagname":"class","subclasses":[],"extends":"Ext.Template","uses":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/Ext.Template' rel='Ext.Template' class='docClass'>Ext.Template</a><div class='subclass '><strong>Ext.XTemplate</strong></div></div><h4>Files</h4><div class='dependency'><a href='source/XTemplate.html#Ext-XTemplate' target='_blank'>XTemplate.js</a></div></pre><div class='doc-contents'><p>A template class that supports advanced functionality like:<div class=\"mdetail-params\"><ul>\n<li>Autofilling arrays using templates and sub-templates</li>\n<li>Conditional processing with basic comparison operators</li>\n<li>Basic math function support</li>\n<li>Execute arbitrary inline code with special built-in template variables</li>\n<li>Custom member functions</li>\n<li>Many special tags and built-in operators that aren't defined as part of\nthe API, but are supported in the templates that can be created</li>\n</ul></div></p>\n\n\n<p>XTemplate provides the templating mechanism built into:<div class=\"mdetail-params\"><ul>\n<li><a href=\"#!/api/Ext.DataView\" rel=\"Ext.DataView\" class=\"docClass\">Ext.DataView</a></li>\n<li>Ext.ListView</li>\n<li><a href=\"#!/api/Ext.form.ComboBox\" rel=\"Ext.form.ComboBox\" class=\"docClass\">Ext.form.ComboBox</a></li>\n<li><a href=\"#!/api/Ext.grid.TemplateColumn\" rel=\"Ext.grid.TemplateColumn\" class=\"docClass\">Ext.grid.TemplateColumn</a></li>\n<li><a href=\"#!/api/Ext.grid.GroupingView\" rel=\"Ext.grid.GroupingView\" class=\"docClass\">Ext.grid.GroupingView</a></li>\n<li><a href=\"#!/api/Ext.menu.Item\" rel=\"Ext.menu.Item\" class=\"docClass\">Ext.menu.Item</a></li>\n<li><a href=\"#!/api/Ext.layout.MenuLayout\" rel=\"Ext.layout.MenuLayout\" class=\"docClass\">Ext.layout.MenuLayout</a></li>\n<li><a href=\"#!/api/Ext.ColorPalette\" rel=\"Ext.ColorPalette\" class=\"docClass\">Ext.ColorPalette</a></li>\n</ul></div></p>\n\n\n\n\n<p>For example usage see the constructor.</p>\n\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-compiled' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Template' rel='Ext.Template' class='defined-in docClass'>Ext.Template</a><br/><a href='source/Template.html#Ext-Template-cfg-compiled' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Template-cfg-compiled' class='name expandable'>compiled</a><span> : Boolean</span></div><div class='description'><div class='short'>Specify true to compile the template\nimmediately (see compile). ...</div><div class='long'><p>Specify <tt>true</tt> to compile the template\nimmediately (see <code><a href=\"#!/api/Ext.Template-method-compile\" rel=\"Ext.Template-method-compile\" class=\"docClass\">compile</a></code>).\nDefaults to <tt>false</tt>.</p>\n</div></div></div><div id='cfg-disableFormats' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Template' rel='Ext.Template' class='defined-in docClass'>Ext.Template</a><br/><a href='source/Template-more.html#Ext-Template-cfg-disableFormats' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Template-cfg-disableFormats' class='name expandable'>disableFormats</a><span> : Boolean</span></div><div class='description'><div class='short'>Specify true to disable format\nfunctions in the template. ...</div><div class='long'><p>Specify <tt>true</tt> to disable format\nfunctions in the template. If the template does not contain\n<a href=\"#!/api/Ext.util.Format\" rel=\"Ext.util.Format\" class=\"docClass\">format functions</a>, setting <code>disableFormats</code>\nto true will reduce <code><a href=\"#!/api/Ext.Template-method-apply\" rel=\"Ext.Template-method-apply\" class=\"docClass\">apply</a></code> time. Defaults to <tt>false</tt>.</p>\n\n<pre><code>var t = new <a href=\"#!/api/Ext.Template\" rel=\"Ext.Template\" class=\"docClass\">Ext.Template</a>(\n    '&lt;div name=\"{id}\"&gt;',\n        '&lt;span class=\"{cls}\"&gt;{name} {value}&lt;/span&gt;',\n    '&lt;/div&gt;',\n    {\n        compiled: true,      // <a href=\"#!/api/Ext.Template-method-compile\" rel=\"Ext.Template-method-compile\" class=\"docClass\">compile</a> immediately\n        disableFormats: true // reduce <code><a href=\"#!/api/Ext.Template-method-apply\" rel=\"Ext.Template-method-apply\" class=\"docClass\">apply</a></code> time since no formatting\n    }\n);\n</code></pre>\n\n\n<p>For a list of available format functions, see <a href=\"#!/api/Ext.util.Format\" rel=\"Ext.util.Format\" class=\"docClass\">Ext.util.Format</a>.</p>\n<p>Defaults to: <code>false</code></p></div></div></div><div id='cfg-re' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Template' rel='Ext.Template' class='defined-in docClass'>Ext.Template</a><br/><a href='source/Template.html#Ext-Template-cfg-re' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Template-cfg-re' class='name expandable'>re</a><span> : RegExp</span></div><div class='description'><div class='short'>The regular expression used to match template variables. ...</div><div class='long'><p>The regular expression used to match template variables.\nDefaults to:</p>\n\n<pre><code>re : /\\{([\\w\\-]+)\\}/g                                     // for Ext Core\nre : /\\{([\\w\\-]+)(?:\\:([\\w\\.]*)(?:\\((.*?)?\\))?)?\\}/g      // for Ext JS\n</code></pre>\n\n<p>Defaults to: <code>/\\{([\\w\\-]+)\\}/g</code></p></div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-html' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Template' rel='Ext.Template' class='defined-in docClass'>Ext.Template</a><br/><a href='source/Template.html#Ext-Template-property-html' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Template-property-html' class='name not-expandable'>html</a><span> : Object</span><strong class='private signature' >private</strong></div><div class='description'><div class='short'>\n</div><div class='long'>\n</div></div></div></div></div><div class='members-section'><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Instance Methods</h3><div id='method-constructor' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.XTemplate'>Ext.XTemplate</span><br/><a href='source/XTemplate.html#Ext-XTemplate-method-constructor' target='_blank' class='view-source'>view source</a></div><strong class='new-keyword'>new</strong><a href='#!/api/Ext.XTemplate-method-constructor' class='name expandable'>Ext.XTemplate</a>( <span class='pre'>config</span> ) : <a href=\"#!/api/Ext.XTemplate\" rel=\"Ext.XTemplate\" class=\"docClass\">Ext.XTemplate</a></div><div class='description'><div class='short'>The Ext.Template constructor describes\nthe acceptable parameters to pass to the constructor. ...</div><div class='long'><p>The Ext.Template constructor describes\nthe acceptable parameters to pass to the constructor. The following\nexamples demonstrate all of the supported features.</p></p>\n\n<div class=\"mdetail-params\"><ul>\n\n<li><b><u>Sample Data</u></b>\n<div class=\"sub-desc\">\n<p>This is the data object used for reference in each code example:</p>\n<pre><code>var data = {\n    name: 'Jack Slocum',\n    title: 'Lead Developer',\n    company: 'Ext JS, LLC',\n    email: 'jack@extjs.com',\n    address: '4 Red Bulls Drive',\n    city: 'Cleveland',\n    state: 'Ohio',\n    zip: '44102',\n    drinks: ['Red Bull', 'Coffee', 'Water'],\n    kids: [{\n        name: 'Sara Grace',\n        age:3\n    },{\n        name: 'Zachary',\n        age:2\n    },{\n        name: 'John James',\n        age:0\n    }]\n};\n</code></pre>\n</div>\n</li>\n\n\n<li><b><u>Auto filling of arrays</u></b>\n<div class=\"sub-desc\">\n<p>The <b><tt>tpl</tt></b> tag and the <b><tt>for</tt></b> operator are used\nto process the provided data object:\n<ul>\n<li>If the value specified in <tt>for</tt> is an array, it will auto-fill,\nrepeating the template block inside the <tt>tpl</tt> tag for each item in the\narray.</li>\n<li>If <tt>for=\".\"</tt> is specified, the data object provided is examined.</li>\n<li>While processing an array, the special variable <tt>{#}</tt>\nwill provide the current array index + 1 (starts at 1, not 0).</li>\n</ul>\n</p>\n<pre><code>&lt;tpl <b>for</b>=\".\">...&lt;/tpl>       // loop through array at root node\n&lt;tpl <b>for</b>=\"foo\">...&lt;/tpl>     // loop through array at foo node\n&lt;tpl <b>for</b>=\"foo.bar\">...&lt;/tpl> // loop through array at foo.bar node\n</code></pre>\nUsing the sample data above:\n<pre><code>var tpl = new <a href=\"#!/api/Ext.XTemplate\" rel=\"Ext.XTemplate\" class=\"docClass\">Ext.XTemplate</a>(\n    '&lt;p>Kids: ',\n    '&lt;tpl <b>for</b>=\".\">',       // process the data.kids node\n        '&lt;p>{#}. {name}&lt;/p>',  // use current array index to autonumber\n    '&lt;/tpl>&lt;/p>'\n);\ntpl.overwrite(panel.body, data.kids); // pass the kids property of the data object\n</code></pre>\n<p>An example illustrating how the <b><tt>for</tt></b> property can be leveraged\nto access specified members of the provided data object to populate the template:</p>\n<pre><code>var tpl = new <a href=\"#!/api/Ext.XTemplate\" rel=\"Ext.XTemplate\" class=\"docClass\">Ext.XTemplate</a>(\n    '&lt;p>Name: {name}&lt;/p>',\n    '&lt;p>Title: {title}&lt;/p>',\n    '&lt;p>Company: {company}&lt;/p>',\n    '&lt;p>Kids: ',\n    '&lt;tpl <b>for=\"kids\"</b>>',     // interrogate the kids property within the data\n        '&lt;p>{name}&lt;/p>',\n    '&lt;/tpl>&lt;/p>'\n);\ntpl.overwrite(panel.body, data);  // pass the root node of the data object\n</code></pre>\n<p>Flat arrays that contain values (and not objects) can be auto-rendered\nusing the special <b><tt>{.}</tt></b> variable inside a loop.  This variable\nwill represent the value of the array at the current index:</p>\n<pre><code>var tpl = new <a href=\"#!/api/Ext.XTemplate\" rel=\"Ext.XTemplate\" class=\"docClass\">Ext.XTemplate</a>(\n    '&lt;p>{name}\\&#39;s favorite beverages:&lt;/p>',\n    '&lt;tpl for=\"drinks\">',\n       '&lt;div> - {.}&lt;/div>',\n    '&lt;/tpl>'\n);\ntpl.overwrite(panel.body, data);\n</code></pre>\n<p>When processing a sub-template, for example while looping through a child array,\nyou can access the parent object's members via the <b><tt>parent</tt></b> object:</p>\n<pre><code>var tpl = new <a href=\"#!/api/Ext.XTemplate\" rel=\"Ext.XTemplate\" class=\"docClass\">Ext.XTemplate</a>(\n    '&lt;p>Name: {name}&lt;/p>',\n    '&lt;p>Kids: ',\n    '&lt;tpl for=\"kids\">',\n        '&lt;tpl if=\"age > 1\">',\n            '&lt;p>{name}&lt;/p>',\n            '&lt;p>Dad: {<b>parent</b>.name}&lt;/p>',\n        '&lt;/tpl>',\n    '&lt;/tpl>&lt;/p>'\n);\ntpl.overwrite(panel.body, data);\n</code></pre>\n</div>\n</li>\n\n\n<li><b><u>Conditional processing with basic comparison operators</u></b>\n<div class=\"sub-desc\">\n<p>The <b><tt>tpl</tt></b> tag and the <b><tt>if</tt></b> operator are used\nto provide conditional checks for deciding whether or not to render specific\nparts of the template. Notes:<div class=\"sub-desc\"><ul>\n<li>Double quotes must be encoded if used within the conditional</li>\n<li>There is no <tt>else</tt> operator &mdash; if needed, two opposite\n<tt>if</tt> statements should be used.</li>\n</ul></div>\n<pre><code>&lt;tpl if=\"age &gt; 1 &amp;&amp; age &lt; 10\">Child&lt;/tpl>\n&lt;tpl if=\"age >= 10 && age < 18\">Teenager&lt;/tpl>\n&lt;tpl <b>if</b>=\"this.isGirl(name)\">...&lt;/tpl>\n&lt;tpl <b>if</b>=\"id==\\'download\\'\">...&lt;/tpl>\n&lt;tpl <b>if</b>=\"needsIcon\">&lt;img src=\"{icon}\" class=\"{iconCls}\"/>&lt;/tpl>\n// no good:\n&lt;tpl if=\"name == \"Jack\"\">Hello&lt;/tpl>\n// encode &#34; if it is part of the condition, e.g.\n&lt;tpl if=\"name == &#38;quot;Jack&#38;quot;\">Hello&lt;/tpl>\n</code></pre>\nUsing the sample data above:\n<pre><code>var tpl = new <a href=\"#!/api/Ext.XTemplate\" rel=\"Ext.XTemplate\" class=\"docClass\">Ext.XTemplate</a>(\n    '&lt;p>Name: {name}&lt;/p>',\n    '&lt;p>Kids: ',\n    '&lt;tpl for=\"kids\">',\n        '&lt;tpl if=\"age > 1\">',\n            '&lt;p>{name}&lt;/p>',\n        '&lt;/tpl>',\n    '&lt;/tpl>&lt;/p>'\n);\ntpl.overwrite(panel.body, data);\n</code></pre>\n</div>\n</li>\n\n\n<li><b><u>Basic math support</u></b>\n<div class=\"sub-desc\">\n<p>The following basic math operators may be applied directly on numeric\ndata values:</p>\n<pre>+ - * /\n</pre>\nFor example:\n<pre><code>var tpl = new <a href=\"#!/api/Ext.XTemplate\" rel=\"Ext.XTemplate\" class=\"docClass\">Ext.XTemplate</a>(\n    '&lt;p>Name: {name}&lt;/p>',\n    '&lt;p>Kids: ',\n    '&lt;tpl for=\"kids\">',\n        '&lt;tpl if=\"age &amp;gt; 1\">',  // <-- Note that the &gt; is encoded\n            '&lt;p>{#}: {name}&lt;/p>',  // <-- Auto-number each item\n            '&lt;p>In 5 Years: {age+5}&lt;/p>',  // <-- Basic math\n            '&lt;p>Dad: {parent.name}&lt;/p>',\n        '&lt;/tpl>',\n    '&lt;/tpl>&lt;/p>'\n);\ntpl.overwrite(panel.body, data);\n</code></pre>\n</div>\n</li>\n\n\n<li><b><u>Execute arbitrary inline code with special built-in template variables</u></b>\n<div class=\"sub-desc\">\n<p>Anything between <code>{[ ... ]}</code> is considered code to be executed\nin the scope of the template. There are some special variables available in that code:\n<ul>\n<li><b><tt>values</tt></b>: The values in the current scope. If you are using\nscope changing sub-templates, you can change what <tt>values</tt> is.</li>\n<li><b><tt>parent</tt></b>: The scope (values) of the ancestor template.</li>\n<li><b><tt>xindex</tt></b>: If you are in a looping template, the index of the\nloop you are in (1-based).</li>\n<li><b><tt>xcount</tt></b>: If you are in a looping template, the total length\nof the array you are looping.</li>\n<li><b><tt>fm</tt></b>: An alias for <tt><a href=\"#!/api/Ext.util.Format\" rel=\"Ext.util.Format\" class=\"docClass\">Ext.util.Format</a></tt>.</li>\n</ul>\nThis example demonstrates basic row striping using an inline code block and the\n<tt>xindex</tt> variable:</p>\n<pre><code>var tpl = new <a href=\"#!/api/Ext.XTemplate\" rel=\"Ext.XTemplate\" class=\"docClass\">Ext.XTemplate</a>(\n    '&lt;p>Name: {name}&lt;/p>',\n    '&lt;p>Company: {[values.company.toUpperCase() + \", \" + values.title]}&lt;/p>',\n    '&lt;p>Kids: ',\n    '&lt;tpl for=\"kids\">',\n       '&lt;div class=\"{[xindex % 2 === 0 ? \"even\" : \"odd\"]}\">',\n        '{name}',\n        '&lt;/div>',\n    '&lt;/tpl>&lt;/p>'\n);\ntpl.overwrite(panel.body, data);\n</code></pre>\n</div>\n</li>\n\n<li><b><u>Template member functions</u></b>\n<div class=\"sub-desc\">\n<p>One or more member functions can be specified in a configuration\nobject passed into the XTemplate constructor for more complex processing:</p>\n<pre><code>var tpl = new <a href=\"#!/api/Ext.XTemplate\" rel=\"Ext.XTemplate\" class=\"docClass\">Ext.XTemplate</a>(\n    '&lt;p>Name: {name}&lt;/p>',\n    '&lt;p>Kids: ',\n    '&lt;tpl for=\"kids\">',\n        '&lt;tpl if=\"this.isGirl(name)\">',\n            '&lt;p>Girl: {name} - {age}&lt;/p>',\n        '&lt;/tpl>',\n        // use opposite if statement to simulate 'else' processing:\n        '&lt;tpl if=\"this.isGirl(name) == false\">',\n            '&lt;p>Boy: {name} - {age}&lt;/p>',\n        '&lt;/tpl>',\n        '&lt;tpl if=\"this.isBaby(age)\">',\n            '&lt;p>{name} is a baby!&lt;/p>',\n        '&lt;/tpl>',\n    '&lt;/tpl>&lt;/p>',\n    {\n        // XTemplate configuration:\n        compiled: true,\n        disableFormats: true,\n        // member functions:\n        isGirl: function(name){\n            return name == 'Sara Grace';\n        },\n        isBaby: function(age){\n            return age < 1;\n        }\n    }\n);\ntpl.overwrite(panel.body, data);\n</code></pre>\n</div>\n</li>\n\n</ul></div>\n\n</p><h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Mixed<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.XTemplate\" rel=\"Ext.XTemplate\" class=\"docClass\">Ext.XTemplate</a></span><div class='sub-desc'>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.Template-method-constructor' rel='Ext.Template-method-constructor' class='docClass'>Ext.Template.constructor</a></p></div></div></div><div id='method-append' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Template' rel='Ext.Template' class='defined-in docClass'>Ext.Template</a><br/><a href='source/Template.html#Ext-Template-method-append' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Template-method-append' class='name expandable'>append</a>( <span class='pre'>el, values, [returnElement]</span> ) : HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Applies the supplied values to the template and appends\nthe new node(s) to the specified el. ...</div><div class='long'><p>Applies the supplied <code>values</code> to the template and appends\nthe new node(s) to the specified <code>el</code>.</p>\n\n<p>For example usage see the constructor.</p>\n\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : Mixed<div class='sub-desc'><p>The context element</p>\n</div></li><li><span class='pre'>values</span> : Object/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The template values. Can be an array if the params are numeric (i.e. <code>{0}</code>)\nor an object (i.e. <code>{foo: 'bar'}</code>).</p>\n</div></li><li><span class='pre'>returnElement</span> : Boolean (optional)<div class='sub-desc'><p>true to return an <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> (defaults to undefined)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The new node or Element</p>\n</div></li></ul></div></div></div><div id='method-apply' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.XTemplate'>Ext.XTemplate</span><br/><a href='source/XTemplate.html#Ext-XTemplate-method-apply' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.XTemplate-method-apply' class='name expandable'>apply</a>( <span class='pre'>values</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Alias for applyTemplate\nReturns an HTML fragment of this template with the specified values applied. ...</div><div class='long'><p>Alias for <a href=\"#!/api/Ext.XTemplate-method-applyTemplate\" rel=\"Ext.XTemplate-method-applyTemplate\" class=\"docClass\">applyTemplate</a>\nReturns an HTML fragment of this template with the specified values applied.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>values</span> : Object/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The template values. Can be an array if your params are numeric (i.e. {0}) or an object (i.e. {foo: 'bar'})</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The HTML fragment</p>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.Template-method-apply' rel='Ext.Template-method-apply' class='docClass'>Ext.Template.apply</a></p></div></div></div><div id='method-applyTemplate' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.XTemplate'>Ext.XTemplate</span><br/><a href='source/XTemplate.html#Ext-XTemplate-method-applyTemplate' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.XTemplate-method-applyTemplate' class='name expandable'>applyTemplate</a>( <span class='pre'>values</span> ) : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></div><div class='description'><div class='short'>Returns an HTML fragment of this template with the specified values applied. ...</div><div class='long'><p>Returns an HTML fragment of this template with the specified values applied.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>values</span> : Object<div class='sub-desc'><p>The template values. Can be an array if your params are numeric (i.e. {0}) or an object (i.e. {foo: 'bar'})</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a></span><div class='sub-desc'><p>The HTML fragment</p>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.Template-method-applyTemplate' rel='Ext.Template-method-applyTemplate' class='docClass'>Ext.Template.applyTemplate</a></p></div></div></div><div id='method-compile' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.XTemplate'>Ext.XTemplate</span><br/><a href='source/XTemplate.html#Ext-XTemplate-method-compile' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.XTemplate-method-compile' class='name expandable'>compile</a>( <span class='pre'></span> ) : <a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a><strong class='chainable signature' >chainable</strong></div><div class='description'><div class='short'>Compile the template to a function for optimized performance. ...</div><div class='long'><p>Compile the template to a function for optimized performance.  Recommended if the template will be used frequently.</p>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Function\" rel=\"Function\" class=\"docClass\">Function</a></span><div class='sub-desc'><p>The compiled function</p>\n</div></li></ul><p>Overrides: <a href='#!/api/Ext.Template-method-compile' rel='Ext.Template-method-compile' class='docClass'>Ext.Template.compile</a></p></div></div></div><div id='method-insertAfter' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Template' rel='Ext.Template' class='defined-in docClass'>Ext.Template</a><br/><a href='source/Template.html#Ext-Template-method-insertAfter' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Template-method-insertAfter' class='name expandable'>insertAfter</a>( <span class='pre'>el, values, [returnElement]</span> ) : HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Applies the supplied values to the template and inserts the new node(s) after el. ...</div><div class='long'><p>Applies the supplied values to the template and inserts the new node(s) after el.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : Mixed<div class='sub-desc'><p>The context element</p>\n</div></li><li><span class='pre'>values</span> : Object/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The template values. Can be an array if your params are numeric (i.e. {0}) or an object (i.e. {foo: 'bar'})</p>\n</div></li><li><span class='pre'>returnElement</span> : Boolean (optional)<div class='sub-desc'><p>true to return a <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> (defaults to undefined)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The new node or Element</p>\n</div></li></ul></div></div></div><div id='method-insertBefore' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Template' rel='Ext.Template' class='defined-in docClass'>Ext.Template</a><br/><a href='source/Template.html#Ext-Template-method-insertBefore' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Template-method-insertBefore' class='name expandable'>insertBefore</a>( <span class='pre'>el, values, [returnElement]</span> ) : HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Applies the supplied values to the template and inserts the new node(s) before el. ...</div><div class='long'><p>Applies the supplied values to the template and inserts the new node(s) before el.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : Mixed<div class='sub-desc'><p>The context element</p>\n</div></li><li><span class='pre'>values</span> : Object/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The template values. Can be an array if your params are numeric (i.e. {0}) or an object (i.e. {foo: 'bar'})</p>\n</div></li><li><span class='pre'>returnElement</span> : Boolean (optional)<div class='sub-desc'><p>true to return a <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> (defaults to undefined)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The new node or Element</p>\n</div></li></ul></div></div></div><div id='method-insertFirst' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Template' rel='Ext.Template' class='defined-in docClass'>Ext.Template</a><br/><a href='source/Template.html#Ext-Template-method-insertFirst' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Template-method-insertFirst' class='name expandable'>insertFirst</a>( <span class='pre'>el, values, [returnElement]</span> ) : HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Applies the supplied values to the template and inserts the new node(s) as the first child of el. ...</div><div class='long'><p>Applies the supplied values to the template and inserts the new node(s) as the first child of el.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : Mixed<div class='sub-desc'><p>The context element</p>\n</div></li><li><span class='pre'>values</span> : Object/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The template values. Can be an array if your params are numeric (i.e. {0}) or an object (i.e. {foo: 'bar'})</p>\n</div></li><li><span class='pre'>returnElement</span> : Boolean (optional)<div class='sub-desc'><p>true to return a <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> (defaults to undefined)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The new node or Element</p>\n</div></li></ul></div></div></div><div id='method-overwrite' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/Ext.Template' rel='Ext.Template' class='defined-in docClass'>Ext.Template</a><br/><a href='source/Template.html#Ext-Template-method-overwrite' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.Template-method-overwrite' class='name expandable'>overwrite</a>( <span class='pre'>el, values, [returnElement]</span> ) : HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></div><div class='description'><div class='short'>Applies the supplied values to the template and overwrites the content of el with the new node(s). ...</div><div class='long'><p>Applies the supplied values to the template and overwrites the content of el with the new node(s).</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : Mixed<div class='sub-desc'><p>The context element</p>\n</div></li><li><span class='pre'>values</span> : Object/<a href=\"#!/api/Array\" rel=\"Array\" class=\"docClass\">Array</a><div class='sub-desc'><p>The template values. Can be an array if your params are numeric (i.e. {0}) or an object (i.e. {foo: 'bar'})</p>\n</div></li><li><span class='pre'>returnElement</span> : Boolean (optional)<div class='sub-desc'><p>true to return a <a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a> (defaults to undefined)</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>HTMLElement/<a href=\"#!/api/Ext.Element\" rel=\"Ext.Element\" class=\"docClass\">Ext.Element</a></span><div class='sub-desc'><p>The new node or Element</p>\n</div></li></ul></div></div></div></div><div class='subsection'><div class='definedBy'>Defined By</div><h4 class='members-subtitle'>Static Methods</h3><div id='static-method-from' class='member first-child not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='Ext.XTemplate'>Ext.XTemplate</span><br/><a href='source/XTemplate.html#Ext-XTemplate-static-method-from' target='_blank' class='view-source'>view source</a></div><a href='#!/api/Ext.XTemplate-static-method-from' class='name expandable'>from</a>( <span class='pre'>el</span> ) : <a href=\"#!/api/Ext.Template\" rel=\"Ext.Template\" class=\"docClass\">Ext.Template</a><strong class='static signature' >static</strong></div><div class='description'><div class='short'>Creates a template from the passed element's value (display:none textarea, preferred) or innerHTML. ...</div><div class='long'><p>Creates a template from the passed element's value (<i>display:none</i> textarea, preferred) or innerHTML.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>el</span> : <a href=\"#!/api/String\" rel=\"String\" class=\"docClass\">String</a>/HTMLElement<div class='sub-desc'><p>A DOM element or its id</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'><a href=\"#!/api/Ext.Template\" rel=\"Ext.Template\" class=\"docClass\">Ext.Template</a></span><div class='sub-desc'><p>The created template</p>\n</div></li></ul></div></div></div></div></div></div></div>","superclasses":["Ext.Template"],"meta":{},"requires":[],"html_meta":{},"statics":{"property":[],"cfg":[],"css_var":[],"method":[{"tagname":"method","owner":"Ext.XTemplate","meta":{"static":true},"name":"from","id":"static-method-from"}],"event":[],"css_mixin":[]},"files":[{"href":"XTemplate.html#Ext-XTemplate","filename":"XTemplate.js"}],"linenr":1,"members":{"property":[{"tagname":"property","owner":"Ext.Template","meta":{"private":true},"name":"html","id":"property-html"}],"cfg":[{"tagname":"cfg","owner":"Ext.Template","meta":{},"name":"compiled","id":"cfg-compiled"},{"tagname":"cfg","owner":"Ext.Template","meta":{},"name":"disableFormats","id":"cfg-disableFormats"},{"tagname":"cfg","owner":"Ext.Template","meta":{},"name":"re","id":"cfg-re"}],"css_var":[],"method":[{"tagname":"method","owner":"Ext.XTemplate","meta":{},"name":"constructor","id":"method-constructor"},{"tagname":"method","owner":"Ext.Template","meta":{},"name":"append","id":"method-append"},{"tagname":"method","owner":"Ext.XTemplate","meta":{},"name":"apply","id":"method-apply"},{"tagname":"method","owner":"Ext.XTemplate","meta":{},"name":"applyTemplate","id":"method-applyTemplate"},{"tagname":"method","owner":"Ext.XTemplate","meta":{"chainable":true},"name":"compile","id":"method-compile"},{"tagname":"method","owner":"Ext.Template","meta":{},"name":"insertAfter","id":"method-insertAfter"},{"tagname":"method","owner":"Ext.Template","meta":{},"name":"insertBefore","id":"method-insertBefore"},{"tagname":"method","owner":"Ext.Template","meta":{},"name":"insertFirst","id":"method-insertFirst"},{"tagname":"method","owner":"Ext.Template","meta":{},"name":"overwrite","id":"method-overwrite"}],"event":[],"css_mixin":[]},"inheritable":null,"private":null,"component":false,"name":"Ext.XTemplate","singleton":false,"override":null,"inheritdoc":null,"id":"class-Ext.XTemplate","mixins":[],"mixedInto":[]});