# Generated by default/object.tt
package Paws::AmplifyBackend::UpdateBackendAuthResourceConfig;
  use Moose;
  has AuthResources => (is => 'ro', isa => 'Str', request_name => 'authResources', traits => ['NameInRequest'], required => 1);
  has IdentityPoolConfigs => (is => 'ro', isa => 'Paws::AmplifyBackend::UpdateBackendAuthIdentityPoolConfig', request_name => 'identityPoolConfigs', traits => ['NameInRequest']);
  has Service => (is => 'ro', isa => 'Str', request_name => 'service', traits => ['NameInRequest'], required => 1);
  has UserPoolConfigs => (is => 'ro', isa => 'Paws::AmplifyBackend::UpdateBackendAuthUserPoolConfig', request_name => 'userPoolConfigs', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AmplifyBackend::UpdateBackendAuthResourceConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AmplifyBackend::UpdateBackendAuthResourceConfig object:

  $service_obj->Method(Att1 => { AuthResources => $value, ..., UserPoolConfigs => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AmplifyBackend::UpdateBackendAuthResourceConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->AuthResources

=head1 DESCRIPTION

Defines the resource configuration when updating an authentication
resource in your Amplify project.

=head1 ATTRIBUTES


=head2 B<REQUIRED> AuthResources => Str

Defines the service name to use when configuring an authentication
resource in your Amplify project.


=head2 IdentityPoolConfigs => L<Paws::AmplifyBackend::UpdateBackendAuthIdentityPoolConfig>

Describes the authorization configuration for the Amazon Cognito
identity pool, provisioned as a part of your auth resource in the
Amplify project.


=head2 B<REQUIRED> Service => Str

Defines the service name to use when configuring an authentication
resource in your Amplify project.


=head2 B<REQUIRED> UserPoolConfigs => L<Paws::AmplifyBackend::UpdateBackendAuthUserPoolConfig>

Describes the authentication configuration for the Amazon Cognito user
pool, provisioned as a part of your auth resource in the Amplify
project.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AmplifyBackend>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

