use strict;
use warnings;

use Test::More import => [ qw( is isa_ok ok ) ], tests => 5;

my $class = 'Foo';
my $role  = 'MooX::Role::HasLogger';

eval qq{
  package $class;

  use Log::Log4perl                ();
  use Moo;
  use MooX::TypeTiny;
  use Types::Standard              qw( HasMethods );
  use MooX::Role::HasLogger::Types qw( Logger );
  use namespace::clean;

  with qw( $role );

  has '+logger' => ( isa => ( Logger ) & ( HasMethods [ qw( category ) ] ) );

  sub build_logger { Log::Log4perl->get_logger( ref shift ) }

  1
};

is $@, '', "Moo class '$class' created dynamically" or die "\n";

is __PACKAGE__, 'main', "current package is 'main'";
ok $class->does( $role ), "class '$class' consumes role '$role'";

isa_ok my $logger = $class->new->logger, 'Log::Log4perl::Logger';
is $class, $logger->category, "custom logger has 'category' attribute with value '$class'"
