#!perl
#
# $Id: Makefile.PL,v 0.1 2015/01/14 10:07:56 dankogai Exp dankogai $
#
use 5.008001;
use strict;
use warnings;
use ExtUtils::MakeMaker;

my $subdir   = 'lib/FreeBSD/amd64/Ptrace';
my $syscall_h = '/usr/include/sys/syscall.h';
if (! -d $subdir ) {
    mkdir "./$subdir" or die "$subdir:$!";
}
warn "making $subdir/Syscall.pm\n";
open my $wfh, '>', "$subdir/Syscall.pm" or die "$subdir/Syscall.pm:$!";
open my $rfh, '<', $syscall_h          or die "$syscall_h:$!";
print $wfh <<'EOT';
# This file is automatically generated. do not edit!
package FreeBSD::amd64::Ptrace::Syscall;
require Exporter;
our @ISA = qw/Exporter/;
our @EXPORT = qw/%SYSCALL %SYS/;
our @EXPORT_TAGS = ( 'all' => [ @EXPORT_OK, @EXPORT ] );
our @EXPORT_OK = @EXPORT;
our %SYS = (
EOT
while (<$rfh>) {
    /^#define\s+SYS_(\w+)\s+(\d+)/o or next;
    print $wfh "\t$2 => '$1',\n";
}
print $wfh <<EOT;
);
our %SYSCALL = reverse %SYSCALL;
1;
EOT


# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.
WriteMakefile(
    NAME                => 'FreeBSD::amd64::Ptrace',
    AUTHOR              => 'Dan Kogai <dankogai@dan.co.jp>',
    VERSION_FROM        => 'lib/FreeBSD/amd64/Ptrace.pm',
    ABSTRACT_FROM       => 'lib/FreeBSD/amd64/Ptrace.pm',
    PL_FILES            => {},
    PREREQ_PM => {
        'Test::More' => 0,
    },
    dist                => { COMPRESS => 'gzip -9f', SUFFIX => 'gz', },
    clean               => { FILES => 'FreeBSD-amd64-Ptrace-*' },
    );
