#!/usr/bin/perl

use Test::Simple tests=> 2;
use Statistics::SPC;

my $test_data = [
	[49920,49920,44052,43364,43364],
	[49920,49920,42980,42980,42980],
	[42980,42980,43364,43364,43364],
	[43364,43364,44976,43364,43364],
	[43364,43364,43364,43364,43364],
	[43364,43364,43364,43364,43364],
	[43364,43364,49920,43364,43364],
	[43364,43364,43364,43364,43364],
	[43364,43364,44976,43364,43364],
	[43364,43364,43364,43364,43364],
	[43364,43364,49920,43364,43364],
	[43364,43748,43748,44976,47908],
	[44052,44052,44052,44052,44052],
	[44052,44052,44052,44052,44052],
	[44052,44052,44052,44052,44976]
];

my $spc = new Statistics::SPC;
$spc->n(5);
$spc->Uspec(5000000);
$spc->Lspec(44000);
$does_not_meet_spec = $spc->history($test_data);
ok($does_not_meet_spec > 0, "out of control Lspec");
$spc->Uspec(42000);
$spc->Lspec(40000);
$does_not_meet_spec = $spc->history($test_data);
ok($does_not_meet_spec > 0, "out of control Uspec");
