/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.client;

import com.rabbitmq.client.Address;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.DefaultSaslConfig;
import com.rabbitmq.client.NullTrustManager;
import com.rabbitmq.client.SaslConfig;
import com.rabbitmq.client.impl.AMQConnection;
import com.rabbitmq.client.impl.FrameHandler;
import com.rabbitmq.client.impl.SocketFrameHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectionFactory
implements Cloneable {
    public static final String DEFAULT_USER = "guest";
    public static final String DEFAULT_PASS = "guest";
    public static final String DEFAULT_VHOST = "/";
    public static final int DEFAULT_CHANNEL_MAX = 0;
    public static final int DEFAULT_FRAME_MAX = 0;
    public static final int DEFAULT_HEARTBEAT = 0;
    public static final String DEFAULT_HOST = "localhost";
    public static final int USE_DEFAULT_PORT = -1;
    public static final int DEFAULT_AMQP_PORT = 5672;
    public static final int DEFAULT_AMQP_OVER_SSL_PORT = 5671;
    public static final String DEFAULT_SSL_PROTOCOL = "SSLv3";
    private String username = "guest";
    private String password = "guest";
    private String virtualHost = "/";
    private String host = "localhost";
    private int port = -1;
    private int requestedChannelMax = 0;
    private int requestedFrameMax = 0;
    private int requestedHeartbeat = 0;
    private Map<String, Object> _clientProperties = AMQConnection.defaultClientProperties();
    private SocketFactory factory = SocketFactory.getDefault();
    private SaslConfig saslConfig = new DefaultSaslConfig(this);

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    private int portOrDefault(int port) {
        if (port != -1) {
            return port;
        }
        if (this.isSSL()) {
            return 5671;
        }
        return 5672;
    }

    public int getPort() {
        return this.portOrDefault(this.port);
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public int getRequestedChannelMax() {
        return this.requestedChannelMax;
    }

    public void setRequestedChannelMax(int requestedChannelMax) {
        this.requestedChannelMax = requestedChannelMax;
    }

    public int getRequestedFrameMax() {
        return this.requestedFrameMax;
    }

    public void setRequestedFrameMax(int requestedFrameMax) {
        this.requestedFrameMax = requestedFrameMax;
    }

    public int getRequestedHeartbeat() {
        return this.requestedHeartbeat;
    }

    public void setRequestedHeartbeat(int requestedHeartbeat) {
        this.requestedHeartbeat = requestedHeartbeat;
    }

    public Map<String, Object> getClientProperties() {
        return this._clientProperties;
    }

    public void setClientProperties(Map<String, Object> clientProperties) {
        this._clientProperties = clientProperties;
    }

    public SaslConfig getSaslConfig() {
        return this.saslConfig;
    }

    public void setSaslConfig(SaslConfig saslConfig) {
        this.saslConfig = saslConfig;
    }

    public SocketFactory getSocketFactory() {
        return this.factory;
    }

    public void setSocketFactory(SocketFactory factory) {
        this.factory = factory;
    }

    public boolean isSSL() {
        return this.getSocketFactory() instanceof SSLSocketFactory;
    }

    public void useSslProtocol() throws NoSuchAlgorithmException, KeyManagementException {
        this.useSslProtocol(DEFAULT_SSL_PROTOCOL);
    }

    public void useSslProtocol(String protocol) throws NoSuchAlgorithmException, KeyManagementException {
        this.useSslProtocol(protocol, new NullTrustManager());
    }

    public void useSslProtocol(String protocol, TrustManager trustManager) throws NoSuchAlgorithmException, KeyManagementException {
        SSLContext c = SSLContext.getInstance(protocol);
        c.init(null, new TrustManager[]{trustManager}, null);
        this.useSslProtocol(c);
    }

    public void useSslProtocol(SSLContext context) {
        this.setSocketFactory(context.getSocketFactory());
    }

    protected FrameHandler createFrameHandler(Address addr) throws IOException {
        String hostName = addr.getHost();
        int portNumber = this.portOrDefault(addr.getPort());
        Socket socket = this.factory.createSocket();
        this.configureSocket(socket);
        socket.connect(new InetSocketAddress(hostName, portNumber));
        return this.createFrameHandler(socket);
    }

    protected FrameHandler createFrameHandler(Socket sock) throws IOException {
        return new SocketFrameHandler(sock);
    }

    protected void configureSocket(Socket socket) throws IOException {
        socket.setTcpNoDelay(true);
    }

    public Connection newConnection(Address[] addrs) throws IOException {
        IOException lastException = null;
        for (Address addr : addrs) {
            try {
                FrameHandler frameHandler = this.createFrameHandler(addr);
                AMQConnection conn = new AMQConnection(this, frameHandler);
                conn.start();
                return conn;
            }
            catch (IOException e) {
                lastException = e;
            }
        }
        if (lastException == null) {
            throw new IOException("failed to connect");
        }
        throw lastException;
    }

    public Connection newConnection() throws IOException {
        return this.newConnection(new Address[]{new Address(this.getHost(), this.getPort())});
    }

    public ConnectionFactory clone() {
        try {
            return (ConnectionFactory)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new Error(e);
        }
    }
}

