package Net::Amazon::EMR::ListInstanceGroupsResult;
use Moose;
with 'Net::Amazon::EMR::Role::AttrHash';
use Net::Amazon::EMR::Coercions;
use Net::Amazon::EMR::InstanceGroup;


has 'InstanceGroups' => ( is => 'ro',
                            isa => 'Net::Amazon::EMR::Type::ArrayRefofInstanceGroup',
                            coerce => 1 );

has 'Marker' => ( is => 'ro',
                  isa => 'Str',
              );


__PACKAGE__->meta->make_immutable();

1;

__END__

=head1 NAME

Net::Amazon::EMR::ListInstanceGroupsResult

=head1 DESCRIPTION

Implements the ListInstanceGroups result type described at L<http://docs.amazonwebservices.com/ElasticMapReduce/latest/API/API_ListInstanceGroups.html>.

=head1 AUTHOR

Jon Schutz 

L<http://notes.jschutz.net>

=head1 DOCUMENTATION, LICENSE AND COPYRIGHT

See L<Net::Amazon::EMR>.

=cut
