package Test::MobileAgent::Docomo;

use strict;
use warnings;
use base 'Test::MobileAgent::Base';

sub _modify_headers {
  my ($class, %headers) = @_;

  if (exists $headers{_USER_ID}) {
    $headers{HTTP_X_DCMGUID} = delete $headers{_USER_ID};
  }

  # should be able to be empty to test guid-related behavior
  $headers{HTTP_X_DCMGUID} = 'DCMGUID' unless defined $headers{HTTP_X_DCMGUID};

  my $serial = delete $headers{_SERIAL_NUMBER} || '';

  if ($serial) {
    my $padding = '1234567890' x 2;
    my $ua = $headers{HTTP_USER_AGENT};
    my ($main, $extra) = split / /, $ua, 2;
    if ($extra and substr($extra, 0, 1) ne '(') {
      # looks like foma
      $serial = substr("$serial$padding", 0, 15);
      my $card_id = delete $headers{_CARD_ID} || '';
      $card_id = substr("$card_id$padding;", 0, 20);

      $extra =~ s/;ser\w{15}/;ser$serial/;
      $extra =~ s/;icc\w{20}/;icc$card_id/;
      unless ($extra =~ /;ser/) {
        $extra =~ s/(c\d+)/$1;ser${serial};icc${card_id}/;
      }
      $headers{HTTP_USER_AGENT} = "$main $extra";
    }
    else {
      $serial = substr("$serial$padding", 0, 11);

      $main =~ s|/ser\w{11}|/ser$serial|;
      unless ($main =~ m|/ser\w{11}|) {
        $main .= "/" unless $main =~ m|^[^/]+/[^/}+/[^/]+/.+|;
        $main .= "/ser$serial";
      }
      $headers{HTTP_USER_AGENT} = $main;
      $headers{HTTP_USER_AGENT} .= " $extra" if $extra;
    }
  }

  return %headers;
}

# this list is borrowed from HTTP::MobileAgent's t/02_docomo.t
# last updated: Fri Jan 14 14:56:46 2011
sub _list {q{
DoCoMo/1.0/633S/c20
DoCoMo/1.0/641P/c10
DoCoMo/1.0/641S/c10
DoCoMo/1.0/642S/c20
DoCoMo/1.0/Agent
DoCoMo/1.0/D209i
DoCoMo/1.0/D209i/c10
DoCoMo/1.0/D210i/c10
DoCoMo/1.0/D211i/c10
DoCoMo/1.0/D251i/c10
DoCoMo/1.0/D501i
DoCoMo/1.0/D501i/c5
DoCoMo/1.0/D502i
DoCoMo/1.0/D502i/c10
DoCoMo/1.0/D503i
DoCoMo/1.0/D503i/c10
DoCoMo/1.0/D503i/c5
DoCoMo/1.0/D503iS/c10
DoCoMo/1.0/D503iS/c5
DoCoMo/1.0/D504i/c10
DoCoMo/1.0/F504i/c10/TB
DoCoMo/1.0/D504i/c10/TJ
DoCoMo/1.0/D504i/c30/TD
DoCoMo/1.0/D505i/c20/TC/W20H10
DoCoMo/1.0/ER209i
DoCoMo/1.0/ER209i/c15
DoCoMo/1.0/F209i
DoCoMo/1.0/F209i/c10
DoCoMo/1.0/F210i/c10
DoCoMo/1.0/F211i/c10
DoCoMo/1.0/F212i/c10/TB
DoCoMo/1.0/F251i/c10/TB
DoCoMo/1.0/F501i
DoCoMo/1.0/F502i
DoCoMo/1.0/F502i/c10
DoCoMo/1.0/F502it
DoCoMo/1.0/F502it/c10
DoCoMo/1.0/F503i
DoCoMo/1.0/F503i/c10
DoCoMo/1.0/F503i/c32
DoCoMo/1.0/F503iS
DoCoMo/1.0/F503iS/c10
DoCoMo/1.0/F504i/c10/TB
DoCoMo/1.0/F504i/c10/TJ
DoCoMo/1.0/F661i/c10/TB
DoCoMo/1.0/F671i/c10
DoCoMo/1.0/F671iS/c10/TB
DoCoMo/1.0/GigaCode (http://gigacode.net/)
DoCoMo/1.0/KO209i
DoCoMo/1.0/KO210i
DoCoMo/1.0/KO210i/c10
DoCoMo/1.0/N209i
DoCoMo/1.0/N209i/c08
DoCoMo/1.0/N210i
DoCoMo/1.0/N210i/c10
DoCoMo/1.0/N211i/c10
DoCoMo/1.0/N501i
DoCoMo/1.0/N502i
DoCoMo/1.0/N502i/c08
DoCoMo/1.0/N502it
DoCoMo/1.0/N502it/c10
DoCoMo/1.0/N503i
DoCoMo/1.0/N503i/c10
DoCoMo/1.0/N503i/c30
DoCoMo/1.0/N503i/c5
DoCoMo/1.0/N503i/c5/serNNEBJ608187
DoCoMo/1.0/N503iS
DoCoMo/1.0/N503iS/c10
DoCoMo/1.0/N503iS/c5
DoCoMo/1.0/N504i/c10
DoCoMo/1.0/N504i/c10/TB
DoCoMo/1.0/N504i/c10/TJ
DoCoMo/1.0/N504i/c10/TJ/c0
DoCoMo/1.0/N821i
DoCoMo/1.0/N821i/c08
DoCoMo/1.0/NM502i
DoCoMo/1.0/NM502i/c10
DoCoMo/1.0/P209i
DoCoMo/1.0/P209i/c10
DoCoMo/1.0/P209is
DoCoMo/1.0/P209is (Google CHTML Proxy/1.0)
DoCoMo/1.0/P209is/c10
DoCoMo/1.0/P210i
DoCoMo/1.0/P210i/c10
DoCoMo/1.0/P211i/c10
DoCoMo/1.0/P501i
DoCoMo/1.0/P502i
DoCoMo/1.0/P502i/c10
DoCoMo/1.0/P502i/c10 (Google CHTML Proxy/1.0)
DoCoMo/1.0/P502i_mEB-PD555
DoCoMo/1.0/P503i
DoCoMo/1.0/P503i/c10
DoCoMo/1.0/P503i/c10/
DoCoMo/1.0/P503i/c10/serNMABH200331
DoCoMo/1.0/P503iS
DoCoMo/1.0/P503iS/c10
DoCoMo/1.0/P503iS/c10/serNMAUA482012
DoCoMo/1.0/P504i/c10
DoCoMo/1.0/P504i/c10/TB
DoCoMo/1.0/P751v/c100/s64/kPHS-K
DoCoMo/1.0/P821i
DoCoMo/1.0/P821i/c08
DoCoMo/1.0/PacketMeter/c10
DoCoMo/1.0/R209i
DoCoMo/1.0/R211i/c10
DoCoMo/1.0/R691i
DoCoMo/1.0/R692i/c10
DoCoMo/1.0/SH251i/c10
DoCoMo/1.0/SH505i2/c20/TB/W20H10
DoCoMo/1.0/SH712m/c10
DoCoMo/1.0/SH821i
DoCoMo/1.0/SH821i/c10
DoCoMo/1.0/SO210i/c10
DoCoMo/1.0/SO211i/c10
DoCoMo/1.0/SO502i
DoCoMo/1.0/SO502iWM/c10
DoCoMo/1.0/SO503i
DoCoMo/1.0/SO503i/c10
DoCoMo/1.0/SO503i/c10/serNSOBD506895
DoCoMo/1.0/SO503i/c10/serNSOBD597705
DoCoMo/1.0/SO503iS/c10
DoCoMo/1.0/SO504i/c10
DoCoMo/1.0/SO504i/c10/TB
DoCoMo/1.0/TEST/c10
DoCoMo/1.0/TF502i
DoCoMo/1.0/X503i/c10
DoCoMo/1.0/eggy/c300/s32/kPHS-K
DoCoMo/1.0/eggy/c300/s64/kPHS-K
DoCoMo/1.0/ex_idisplay/c10
DoCoMo/1.0/ex_ps_test00/c10
DoCoMo/1.0/iYappo
DoCoMo/1.0/p503is/c10
DoCoMo/1.0/test
DoCoMo/1.0/test/c10
DoCoMo/1.0/test/c10/TB
DoCoMo/1.1/P711m/c10
DoCoMo/2.0 D2101V(c100)
DoCoMo/2.0 MST_v_P2101V(c100)
DoCoMo/2.0 MST_v_SH2101V(c100)
DoCoMo/2.0 N2001(c10)
DoCoMo/2.0 N2001(c10;ser350200000307969;icc8981100000200188565F)
DoCoMo/2.0 N2001(c10;ser0123456789abcde;icc01234567890123456789)
DoCoMo/2.0 N2002(c100)
DoCoMo/2.0 N2051(c100;TB)
DoCoMo/2.0 P07A3(c500;TB;W24H15)
DoCoMo/2.0 P2002(c100)
DoCoMo/2.0 P2101V
DoCoMo/2.0 P2101V(c100)
DoCoMo/2.0 T2101V(c100)
DoCoMo/2.0/N502i
DoCoMo/2.0/N502it
DoCoMo/2.0/N503i
DoCoMo/3.0/N503
DoCoMo/2.0 N06A3(c500;TB;W24H16)
DoCoMo/2.0 N04A(c100;TB;W24H16)
DoCoMo/2.0 N08A(c500;TB;W24H16)
DoCoMo/1.0/P651ps
DoCoMo/1.0/N211iS/c10
DoCoMo/1.0/P211iS/c10
DoCoMo/1.0/SH251iS/c10
DoCoMo/1.0/F504iS/c10/TB
DoCoMo/1.0/N504iS/c10/TB
DoCoMo/1.0/P504iS/c10/TB
DoCoMo/1.0/D251iS/c10/TB
DoCoMo/1.0/N251i/c10/TB
DoCoMo/1.0/N251iS/c10/TB
DoCoMo/1.0/P251iS/c10/TB
DoCoMo/1.0/SO212i/c10/TB
DoCoMo/1.0/F672i/c10/TB
DoCoMo/1.0/SO213i/c10/TB
DoCoMo/1.0/SO213iS/c10/TB
DoCoMo/1.0/SO213iWR/c10/TB
DoCoMo/2.0 F2051(c100;TB)
DoCoMo/2.0 P2102V(c100;TB)
DoCoMo/2.0 F2102V(c100;TB)
DoCoMo/2.0 N2102V(c100;TB)
DoCoMo/2.0 N2701(c100;TB)
DoCoMo/2.0 NM850iG(c100;TB;W22H10)
DoCoMo/2.0 NM705i(c100;TB;W15H13)
DoCoMo/2.0 NM706i(c100;TB;W15H13)
DoCoMo/1.0/D505i/c20/TB/W20H10
DoCoMo/1.0/SO505i/c20/TB/W21H09
DoCoMo/1.0/SH505i/c20/TB/W24H12
DoCoMo/1.0/N505i/c20/TB/W20H10
DoCoMo/1.0/F505i/c20/TB/W20H10
DoCoMo/1.0/P505i/c20/TB/W20H10
DoCoMo/1.0/D505iS/c20/TB/W20H10
DoCoMo/1.0/P505iS/c20/TB/W20H10
DoCoMo/1.0/N505iS/c20/TB/W20H10
DoCoMo/1.0/SO505iS/c20/TB/W20H10
DoCoMo/1.0/SH505iS/c20/TB/W24H12
DoCoMo/1.0/F505iGPS/c20/TB/W20H10
DoCoMo/1.0/D252i/c10/TB/W25H12
DoCoMo/1.0/SH252i/c20/TB/W24H12
DoCoMo/1.0/P252i/c10/TB/W22H10
DoCoMo/1.0/N252i/c10/TB/W22H10
DoCoMo/1.0/P252iS/c10/TB/W22H10
DoCoMo/1.0/D506i/c20/TB/W20H10
DoCoMo/1.0/F506i/c20/TB/W20H10
DoCoMo/1.0/N506i/c20/TB/W20H11
DoCoMo/1.0/P506iC/c20/TB/W20H10
DoCoMo/1.0/SH506iC/c20/TB/W24H12
DoCoMo/1.0/SO506iC/c20/TB/W20H10
DoCoMo/1.0/N506iS/c20/TB/W20H11
DoCoMo/1.0/SO506i/c20/TB/W20H10
DoCoMo/1.0/SO506iS/c20/TB/W20H10
DoCoMo/1.0/N506iS2/c20/TB/W20H11
DoCoMo/1.0/P506iC/c20/TB/W20H10
DoCoMo/1.0/D253i/c10/TB/W17H09
DoCoMo/1.0/N253i/c10/TB/W20H10
DoCoMo/1.0/P253i/c10/TB/W22H10
DoCoMo/1.0/D253iWM/c10/TB/W27H08
DoCoMo/1.0/P253iS/c10/TB/W22H10
DoCoMo/1.0/P213i/c10/TB/W22H10
DoCoMo/2.0 F900i(c100;TB;W22H12)
DoCoMo/2.0 N900i(c100;TB;W24H12)
DoCoMo/2.0 P900i(c100;TB;W24H11)
DoCoMo/2.0 SH900i(c100;TB;W24H12)
DoCoMo/2.0 F900iT(c100;TB;W22H12)
DoCoMo/2.0 P900iV(c100;TB;W24H11)
DoCoMo/2.0 N900iS(c100;TB;W24H12)
DoCoMo/2.0 D900i(c100;TB;W20H10)
DoCoMo/2.0 F900iC(c100;TB;W22H12)
DoCoMo/2.0 N900iL(c100;TB;W24H12)
DoCoMo/2.0 N900iG(c100;TB;W24H12)
DoCoMo/2.0 F880iES(c100;TB;W20H08)
DoCoMo/2.0 SH901iC(c100;TB;W24H12)
DoCoMo/2.0 F901iC(c100;TB;W23H12)
DoCoMo/2.0 N901iC(c100;TB;W24H12)
DoCoMo/2.0 D901i(c100;TB;W23H12)
DoCoMo/2.0 P901i(c100;TB;W24H12)
DoCoMo/2.0 SH901iS(c100;TB;W24H12)
DoCoMo/2.0 F901iS(c100;TB;W23H12)
DoCoMo/2.0 D901iS(c100;TB;W23H12)
DoCoMo/2.0 P901iS(c100;TB;W24H12)
DoCoMo/2.0 N901iS(c100;TB;W24H12)
DoCoMo/2.0 P901iTV(c100;TB;W24H12)
DoCoMo/2.0 F700i(c100;TB;W23H12)
DoCoMo/2.0 SH700i(c100;TB;W24H12)
DoCoMo/2.0 N700i(c100;TB;W24H12)
DoCoMo/2.0 P700i(c100;TB;W24H12)
DoCoMo/2.0 F700iS(c100;TB;W23H12)
DoCoMo/2.0 SH700iS(c100;TB;W24H12)
DoCoMo/2.0 SA700iS(c100;TB;W24H12)
DoCoMo/2.0 SH851i(c100;TB;W24H12)
DoCoMo/2.0 P851i(c100;TB;W24H12)
DoCoMo/2.0 F881iES(c100;TB;W20H08)
DoCoMo/2.0 D701i(c100;TB;W23H12)
DoCoMo/2.0 N701i(c100;TB;W24H12)
DoCoMo/2.0 P701iD(c100;TB;W24H12)
DoCoMo/2.0 D701iWM(c100;TB;W23H12)
DoCoMo/2.0 N701iECO(c100;TB;W24H12)
DoCoMo/2.0 SA800i(c100;TB;W24H12)
DoCoMo/2.0 L600i(c100;TB;W21H11)
DoCoMo/2.0 N600i(c100;TB;W21H11)
DoCoMo/2.0 L601i(c100;TB;W21H11)
DoCoMo/2.0 M702iS(c100;TB;W24H13)
DoCoMo/2.0 M702iG(c100;TB;W24H13)
DoCoMo/2.0 L602i(c100;TB;W21H11)
DoCoMo/2.0 F902i(c100;TB;W23H12)
DoCoMo/2.0 D902i(c100;TB;W23H16)
DoCoMo/2.0 N902i(c100;TB;W24H12)
DoCoMo/2.0 P902i(c100;TB;W24H12)
DoCoMo/2.0 SH902i(c100;TB;W24H12)
DoCoMo/2.0 SO902i(c100;TB;W24H12)
DoCoMo/2.0 SH902iS(c100;TB;W24H12)
DoCoMo/2.0 P902iS(c100;TB;W24H12)
DoCoMo/2.0 N902iS(c100;TB;W24H12)
DoCoMo/2.0 D902iS(c100;TB;W23H16)
DoCoMo/2.0 F902iS(c100;TB;W23H12)
DoCoMo/2.0 SO902iWP+(c100;TB;W24H12)
DoCoMo/2.0 SH902iSL(c100;TB;W24H12)
DoCoMo/2.0 N902iX(c100;TB;W24H12)
DoCoMo/2.0 N902iL(c100;TB;W24H12)
DoCoMo/2.0 P702i(c100;TB;W24H12)
DoCoMo/2.0 N702iD(c100;TB;W24H12)
DoCoMo/2.0 F702iD(c100;TB;W23H12)
DoCoMo/2.0 SH702iD(c100;TB;W24H12)
DoCoMo/2.0 D702i(c100;TB;W23H12)
DoCoMo/2.0 SO702i(c100;TB;W24H12)
DoCoMo/2.0 D702iBCL(c100;TB;W23H12)
DoCoMo/2.0 SA702i(c100;TB;W24H12)
DoCoMo/2.0 SH702iS(c100;TB;W24H12)
DoCoMo/2.0 N702iS(c100;TB;W24H12)
DoCoMo/2.0 P702iD(c100;TB;W24H12)
DoCoMo/2.0 D702iF(c100;TB;W23H12)
DoCoMo/2.0 D851iWM(c100;TB;W23H16)
DoCoMo/2.0 F882iES(c100;TB;W20H08)
DoCoMo/2.0 N601i(c100;TB;W24H12)
DoCoMo/2.0 D800iDS(c100;TB;W23H12)
DoCoMo/2.0 P703imyu(c100;TB;W24H12)
DoCoMo/2.0 F883i(c100;TB;W20H08)
DoCoMo/2.0 F883iS(c100;TB;W20H08)
DoCoMo/2.0 P704imyu(c100;TB;W20H10)
DoCoMo/2.0 L704i(c100;TB;W24H14)
DoCoMo/2.0 L705i(c100;TB;W16H09)
DoCoMo/2.0 L705iX(c100;TB;W24H14)
DoCoMo/2.0 L852i(c100;TB;W24H14)
DoCoMo/2.0 L706ie(c100;TB;W16H09)
DoCoMo/2.0 L01A(c100;TB;W24H17)
DoCoMo/2.0 L03A(c100;TB;W16H09)
DoCoMo/2.0 L04A(c100;TB;W24H15)
DoCoMo/2.0 L06A(c100;TB;W24H15)
DoCoMo/2.0 L02B(c100;TB;W24H16)
DoCoMo/2.0 SH903i(c100;TB;W24H16)
DoCoMo/2.0 P903i(c100;TB;W24H12)
DoCoMo/2.0 N903i(c100;TB;W24H12)
DoCoMo/2.0 D903i(c100;TB;W23H16)
DoCoMo/2.0 F903i(c100;TB;W23H12)
DoCoMo/2.0 SO903i(c100;TB;W24H18)
DoCoMo/2.0 D903iTV(c100;TB;W23H16)
DoCoMo/2.0 F903iX(c100;TB;W23H12)
DoCoMo/2.0 P903iTV(c100;TB;W24H15)
DoCoMo/2.0 SH903iTV(c100;TB;W24H16)
DoCoMo/2.0 F903iBSC(c100;TB;W23H12)
DoCoMo/2.0 P903iX(c100;TB;W24H12)
DoCoMo/2.0 SO903iTV(c100;TB;W24H18)
DoCoMo/2.0 N703iD(c100;TB;W24H12)
DoCoMo/2.0 F703i(c100;TB;W23H12)
DoCoMo/2.0 P703i(c100;TB;W24H12)
DoCoMo/2.0 D703i(c100;TB;W23H12)
DoCoMo/2.0 SH703i(c100;TB;W24H12)
DoCoMo/2.0 N703imyu(c100;TB;W24H12)
DoCoMo/2.0 SO703i(c100;TB;W24H18)
DoCoMo/2.0 SH904i(c100;TB;W24H16)
DoCoMo/2.0 N904i(c100;TB;W24H16)
DoCoMo/2.0 F904i(c100;TB;W24H17)
DoCoMo/2.0 D904i(c100;TB;W24H12)
DoCoMo/2.0 P904i(c100;TB;W24H15)
DoCoMo/2.0 SO704i(c100;TB;W24H18)
DoCoMo/2.0 F704i(c100;TB;W23H12)
DoCoMo/2.0 N704imyu(c100;TB;W24H12)
DoCoMo/2.0 SH704i(c100;TB;W24H16)
DoCoMo/2.0 D704i(c100;TB;W23H12)
DoCoMo/2.0 P704i(c100;TB;W24H12)
DoCoMo/2.0 F883iES(c100;TB;W20H08)
DoCoMo/2.0 F883iESS(c100;TB;W20H08)
DoCoMo/2.0 F801i(c100;TB;W24H17)
DoCoMo/2.0 F705i(c100;TB;W24H17)
DoCoMo/2.0 D705i(c100;TB;W24H16)
DoCoMo/2.0 D705imyu(c100;TB;W24H12)
DoCoMo/2.0 SH705i(c100;TB;W24H16)
DoCoMo/2.0 SH705i2(c100;TB;W20H13)
DoCoMo/2.0 SH706ie(c100;TB;W20H13)
DoCoMo/2.0 F05A(c100;TB;W24H17)
DoCoMo/2.0 SH905i(c100;TB;W24H16)
DoCoMo/2.0 D905i(c100;TB;W24H17)
DoCoMo/2.0 N905i(c100;TB;W24H16)
DoCoMo/2.0 P905i(c100;TB;W24H15)
DoCoMo/2.0 F905i(c100;TB;W24H17)
DoCoMo/2.0 SO905i(c100;TB;W24H18)
DoCoMo/2.0 N905imyu(c100;TB;W24H16)
DoCoMo/2.0 N905iBiz(c100;TB;W24H16)
DoCoMo/2.0 SH905iTV(c100;TB;W24H16)
DoCoMo/2.0 SO905iCS(c100;TB;W24H18)
DoCoMo/2.0 F905iBiz(c100;TB;W24H17)
DoCoMo/2.0 P905iTV(c100;TB;W24H15)
DoCoMo/2.0 P705i(c100;TB;W24H15)
DoCoMo/2.0 N705i(c100;TB;W24H16)
DoCoMo/2.0 N705imyu(c100;TB;W24H16)
DoCoMo/2.0 P705imyu(c100;TB;W24H15)
DoCoMo/2.0 SO705i(c100;TB;W24H16)
DoCoMo/2.0 P705iCL(c100;TB;W16H10)
DoCoMo/2.0 F884i(c100;TB;W20H11)
DoCoMo/2.0 F884iES(c100;TB;W20H8)
DoCoMo/2.0 N906iL(c100;TB;W24H16)
DoCoMo/2.0 N706i(c100;TB;W24H16)
DoCoMo/2.0 SO706i(c100;TB;W24H16)
DoCoMo/2.0 P706imyu(c100;TB;W24H15)
DoCoMo/2.0 N706ie(c100;TB;W20H13)
DoCoMo/2.0 N706i2(c100;TB;W24H16)
DoCoMo/2.0 N03A(c100;TB;W24H16)
DoCoMo/2.0 N05A(c100;TB;W20H13)
DoCoMo/2.0 F07A(c100;TB;W20H08)
DoCoMo/2.0 F10A(c100;TB;W20H09)
DoCoMo/2.0 P906i(c100;TB;W24H15)
DoCoMo/2.0 SO906i(c100;TB;W24H18)
DoCoMo/2.0 SH906i(c100;TB;W24H16)
DoCoMo/2.0 N906imyu(c100;TB;W24H16)
DoCoMo/2.0 F906i(c100;TB;W24H17)
DoCoMo/2.0 N906i(c100;TB;W24H16)
DoCoMo/2.0 SH906iTV(c100;TB;W20H13)
DoCoMo/2.0 F706i(c100;TB;W24H17)
DoCoMo/2.0 SH706i(c100;TB;W24H16)
DoCoMo/2.0 P706ie(c100;TB;W20H13)
DoCoMo/2.0 SH706iw(c100;TB;W24H16)
DoCoMo/2.0 F01A(c100;TB;W24H17)
DoCoMo/2.0 F02A(c100;TB;W24H17)
DoCoMo/2.0 F03A(c100;TB;W24H17)
DoCoMo/2.0 F04A(c100;TB;W24H17)
DoCoMo/2.0 F06A(c100;TB;W24H17)
DoCoMo/2.0 P01A(c100;TB;W24H15)
DoCoMo/2.0 P02A(c100;TB;W24H15)
DoCoMo/2.0 P03A(c100;TB;W24H15)
DoCoMo/2.0 P04A(c100;TB;W24H15)
DoCoMo/2.0 P05A(c100;TB;W24H15)
DoCoMo/2.0 P06A(c100;TB;W20H13)
DoCoMo/2.0 P10A(c100;TB;W24H15)
DoCoMo/2.0 SH01A(c100;TB;W24H16)
DoCoMo/2.0 SH02A(c100;TB;W24H16)
DoCoMo/2.0 SH03A(c100;TB;W24H16)
DoCoMo/2.0 SH04A(c100;TB;W24H16)
DoCoMo/2.0 N01A(c100;TB;W24H16)
DoCoMo/2.0 N02A(c100;TB;W24H16)
DoCoMo/2.0 P08A3(c500;TB;W24H15)
DoCoMo/2.0 P09A3(c500;TB;W24H15)
DoCoMo/2.0 N07A3(c500;TB;W24H16)
DoCoMo/2.0 N08A3(c500;TB;W24H16)
DoCoMo/2.0 N09A3(c500;TB;W24H16)
DoCoMo/2.0 F08A3(c500;TB;W24H16)
DoCoMo/2.0 F09A3(c500;TB;W24H16)
DoCoMo/2.0 SH05A3(c500;TB;W24H14)
DoCoMo/2.0 SH06A3(c500;TB;W24H14)
DoCoMo/2.0 SH07A3(c500;TB;W24H14)
DoCoMo/2.0 SH08A(c500;TB;W24H14)
DoCoMo/2.0 SH01B(c500;TB;W24H16)
DoCoMo/2.0 SH02B(c500;TB;W24H16)
DoCoMo/2.0 SH04B(c500;TB;W24H14)
DoCoMo/2.0 F01B(c500;TB;W24H16)
DoCoMo/2.0 F02B(c500;TB;W24H16)
DoCoMo/2.0 F03B(c500;TB;W24H16)
DoCoMo/2.0 P01B(c500;TB;W24H15)
DoCoMo/2.0 N01B(c500;TB;W24H16)
DoCoMo/2.0 N02B(c500;TB;W24H16)
}}

1;

__END__

=head1 NAME

Test::MobileAgent::Docomo

=head1 SEE ALSO

See L<HTTP::MobileAgent>'s t/02_docomo.t, from which the data is borrowed.

=head1 AUTHOR

Kenichi Ishigaki, E<lt>ishigaki@cpan.orgE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2009 by Kenichi Ishigaki.

This program is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=cut
