#!/usr/bin/env raku

use Terminal::ANSI::OO;

my $t = Terminal::ANSI::OO.new;

$t.save-screen;
$t.clear-screen;
$t.home;

$t.hide-cursor;

sub scroll($row,$col = 1, $height = 7) {
  $t.print-at: $row,$col, "━" x 20;
  $t.print-at: $row + $height,$col, "━" x 20;
  my $on = $row;
  for 1..40_000 {
    $t.atomically: {
      $t.set-scroll-region($row + 1,$row + $height - 1);
      $t.scroll-up if $on >= $row + $height - 1;
      $t.print-at: ++$on min $row + $height - 1, $col, "this is line $_";
      $t.reset-scroll-region;
    }
  }
}

start scroll(2);
start scroll(12,10,10);
scroll(24);

$t.show-cursor;
$t.restore-screen;
