/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.IsoFile;
import com.coremedia.iso.boxes.Box;
import com.coremedia.iso.boxes.OriginalFormatBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SchemeTypeBox;
import com.coremedia.iso.boxes.sampleentry.AudioSampleEntry;
import com.coremedia.iso.boxes.sampleentry.VisualSampleEntry;
import com.googlecode.mp4parser.MemoryDataSourceImpl;
import com.googlecode.mp4parser.authoring.AbstractTrack;
import com.googlecode.mp4parser.authoring.Sample;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import com.googlecode.mp4parser.authoring.tracks.CencEncryptedTrack;
import com.googlecode.mp4parser.boxes.cenc.CencDecryptingSampleList;
import com.googlecode.mp4parser.boxes.mp4.samplegrouping.CencSampleEncryptionInformationGroupEntry;
import com.googlecode.mp4parser.boxes.mp4.samplegrouping.GroupEntry;
import com.googlecode.mp4parser.util.Path;
import com.googlecode.mp4parser.util.RangeStartMap;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.channels.Channels;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.crypto.SecretKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CencDecryptingTrackImpl
extends AbstractTrack {
    CencDecryptingSampleList samples;
    Track original;
    RangeStartMap<Integer, SecretKey> indexToKey = new RangeStartMap();

    public CencDecryptingTrackImpl(CencEncryptedTrack original, SecretKey sk) {
        this(original, Collections.singletonMap(original.getDefaultKeyId(), sk));
    }

    public CencDecryptingTrackImpl(CencEncryptedTrack original, Map<UUID, SecretKey> keys) {
        super("dec(" + original.getName() + ")");
        this.original = original;
        SchemeTypeBox schm = (SchemeTypeBox)Path.getPath(original.getSampleDescriptionBox(), "enc./sinf/schm");
        if (!"cenc".equals(schm.getSchemeType()) && !"cbc1".equals(schm.getSchemeType())) {
            throw new RuntimeException("You can only use the CencDecryptingTrackImpl with CENC (cenc or cbc1) encrypted tracks");
        }
        ArrayList<CencSampleEncryptionInformationGroupEntry> groupEntries = new ArrayList<CencSampleEncryptionInformationGroupEntry>();
        for (Map.Entry<GroupEntry, long[]> groupEntry : original.getSampleGroups().entrySet()) {
            if (groupEntry.getKey() instanceof CencSampleEncryptionInformationGroupEntry) {
                groupEntries.add((CencSampleEncryptionInformationGroupEntry)groupEntry.getKey());
                continue;
            }
            this.getSampleGroups().put(groupEntry.getKey(), groupEntry.getValue());
        }
        int lastSampleGroupDescriptionIndex = -1;
        int i = 0;
        while (i < original.getSamples().size()) {
            int index = 0;
            int j = 0;
            while (j < groupEntries.size()) {
                GroupEntry groupEntry = (GroupEntry)groupEntries.get(j);
                long[] sampleNums = original.getSampleGroups().get(groupEntry);
                if (Arrays.binarySearch(sampleNums, (long)i) >= 0) {
                    index = j + 1;
                }
                ++j;
            }
            if (lastSampleGroupDescriptionIndex != index) {
                if (index == 0) {
                    this.indexToKey.put(i, keys.get(original.getDefaultKeyId()));
                } else if (((CencSampleEncryptionInformationGroupEntry)groupEntries.get(index - 1)).isEncrypted()) {
                    SecretKey sk = keys.get(((CencSampleEncryptionInformationGroupEntry)groupEntries.get(index - 1)).getKid());
                    if (sk == null) {
                        throw new RuntimeException("Key " + ((CencSampleEncryptionInformationGroupEntry)groupEntries.get(index - 1)).getKid() + " was not supplied for decryption");
                    }
                    this.indexToKey.put(i, sk);
                } else {
                    this.indexToKey.put(i, null);
                }
                lastSampleGroupDescriptionIndex = index;
            }
            ++i;
        }
        this.samples = new CencDecryptingSampleList(this.indexToKey, original.getSamples(), original.getSampleEncryptionEntries(), schm.getSchemeType());
    }

    @Override
    public void close() throws IOException {
        this.original.close();
    }

    @Override
    public long[] getSyncSamples() {
        return this.original.getSyncSamples();
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        SampleDescriptionBox stsd;
        OriginalFormatBox frma = (OriginalFormatBox)Path.getPath(this.original.getSampleDescriptionBox(), "enc./sinf/frma");
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            this.original.getSampleDescriptionBox().getBox(Channels.newChannel(baos));
            stsd = (SampleDescriptionBox)new IsoFile(new MemoryDataSourceImpl(baos.toByteArray())).getBoxes().get(0);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Dumping stsd to memory failed");
        }
        if (stsd.getSampleEntry() instanceof AudioSampleEntry) {
            ((AudioSampleEntry)stsd.getSampleEntry()).setType(frma.getDataFormat());
        } else if (stsd.getSampleEntry() instanceof VisualSampleEntry) {
            ((VisualSampleEntry)stsd.getSampleEntry()).setType(frma.getDataFormat());
        } else {
            throw new RuntimeException("I don't know " + stsd.getSampleEntry().getType());
        }
        LinkedList<Box> nuBoxes = new LinkedList<Box>();
        for (Box box : stsd.getSampleEntry().getBoxes()) {
            if (box.getType().equals("sinf")) continue;
            nuBoxes.add(box);
        }
        stsd.getSampleEntry().setBoxes(nuBoxes);
        return stsd;
    }

    @Override
    public long[] getSampleDurations() {
        return this.original.getSampleDurations();
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.original.getTrackMetaData();
    }

    @Override
    public String getHandler() {
        return this.original.getHandler();
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }
}

