/*
 * Decompiled with CFR 0.152.
 */
package com.healthmarketscience.jackcess;

import com.healthmarketscience.jackcess.Column;
import com.healthmarketscience.jackcess.DataType;
import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.PropertyMap;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.TableBuilder;
import com.healthmarketscience.jackcess.impl.ColumnImpl;
import com.healthmarketscience.jackcess.impl.DatabaseImpl;
import com.healthmarketscience.jackcess.impl.JetFormat;
import com.healthmarketscience.jackcess.impl.PropertyMapImpl;
import com.healthmarketscience.jackcess.impl.TableImpl;
import com.healthmarketscience.jackcess.impl.TableUpdater;
import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnBuilder {
    private String _name;
    private DataType _type;
    private Short _length;
    private Byte _precision;
    private Byte _scale;
    private boolean _autoNumber;
    private boolean _compressedUnicode;
    private boolean _calculated;
    private boolean _hyperlink;
    private short _columnNumber;
    private ColumnImpl.SortOrder _sortOrder;
    private Map<String, PropertyMap.Property> _props;

    public ColumnBuilder(String name) {
        this(name, null);
    }

    public ColumnBuilder(String name, DataType type) {
        this._name = name;
        this._type = type;
    }

    public String getName() {
        return this._name;
    }

    public ColumnBuilder setType(DataType type) {
        this._type = type;
        return this;
    }

    public DataType getType() {
        return this._type;
    }

    public ColumnBuilder setSQLType(int type) throws SQLException {
        return this.setSQLType(type, 0, null);
    }

    public ColumnBuilder setSQLType(int type, int lengthInUnits) throws SQLException {
        return this.setSQLType(type, lengthInUnits, null);
    }

    public ColumnBuilder setSQLType(int type, int lengthInUnits, Database.FileFormat fileFormat) throws SQLException {
        return this.setType(DataType.fromSQLType(type, lengthInUnits, fileFormat));
    }

    public ColumnBuilder setPrecision(int newPrecision) {
        this._precision = (byte)newPrecision;
        return this;
    }

    public byte getPrecision() {
        return this._precision != null ? this._precision : (byte)this._type.getDefaultPrecision();
    }

    public ColumnBuilder setMaxPrecision() {
        if (this._type.getHasScalePrecision()) {
            this.setPrecision(this._type.getMaxPrecision());
        }
        return this;
    }

    public ColumnBuilder setScale(int newScale) {
        this._scale = (byte)newScale;
        return this;
    }

    public byte getScale() {
        return this._scale != null ? this._scale : (byte)this._type.getDefaultScale();
    }

    public ColumnBuilder setMaxScale() {
        if (this._type.getHasScalePrecision()) {
            this.setScale(this._type.getMaxScale());
        }
        return this;
    }

    public ColumnBuilder setLength(int length) {
        this._length = (short)length;
        return this;
    }

    public short getLength() {
        return this._length != null ? this._length : (short)(!this._type.isVariableLength() ? this._type.getFixedSize() : this._type.getDefaultSize());
    }

    public ColumnBuilder setLengthInUnits(int unitLength) {
        return this.setLength(this._type.getUnitSize() * unitLength);
    }

    public ColumnBuilder setMaxLength() {
        if (this._type.isVariableLength()) {
            this.setLength(this._type.getMaxSize());
        }
        return this;
    }

    public ColumnBuilder setAutoNumber(boolean autoNumber) {
        this._autoNumber = autoNumber;
        return this;
    }

    public boolean isAutoNumber() {
        return this._autoNumber;
    }

    public ColumnBuilder setCompressedUnicode(boolean compressedUnicode) {
        this._compressedUnicode = compressedUnicode;
        return this;
    }

    public boolean isCompressedUnicode() {
        return this._compressedUnicode;
    }

    public ColumnBuilder setCalculated(boolean calculated) {
        this._calculated = calculated;
        return this;
    }

    public boolean isCalculated() {
        return this._calculated;
    }

    public ColumnBuilder setCalculatedInfo(String expression) {
        this.setCalculated(true);
        this.putProperty("Expression", expression);
        return this.putProperty("ResultType", this.getType().getValue());
    }

    public boolean isVariableLength() {
        return this.getType().isVariableLength() || this.isCalculated();
    }

    public ColumnBuilder setHyperlink(boolean hyperlink) {
        this._hyperlink = hyperlink;
        return this;
    }

    public boolean isHyperlink() {
        return this._hyperlink;
    }

    public ColumnBuilder putProperty(String name, Object value) {
        return this.putProperty(name, null, value);
    }

    public ColumnBuilder putProperty(String name, DataType type, Object value) {
        this.setProperty(name, PropertyMapImpl.createProperty(name, type, value));
        return this;
    }

    public Map<String, PropertyMap.Property> getProperties() {
        return this._props;
    }

    private void setProperty(String name, PropertyMap.Property prop) {
        if (prop == null) {
            return;
        }
        if (this._props == null) {
            this._props = new HashMap<String, PropertyMap.Property>();
        }
        this._props.put(name, prop);
    }

    private PropertyMap.Property getProperty(String name) {
        return this._props != null ? this._props.get(name) : null;
    }

    public ColumnBuilder setFromColumn(Column template) throws IOException {
        DataType type = template.getType();
        this.setType(type);
        this.setLength(template.getLength());
        this.setAutoNumber(template.isAutoNumber());
        if (type.getHasScalePrecision()) {
            this.setScale(template.getScale());
            this.setPrecision(template.getPrecision());
        }
        this.setCalculated(template.isCalculated());
        this.setCompressedUnicode(template.isCompressedUnicode());
        this.setHyperlink(template.isHyperlink());
        if (template instanceof ColumnImpl) {
            this.setTextSortOrder(((ColumnImpl)template).getTextSortOrder());
        }
        PropertyMap colProps = template.getProperties();
        for (PropertyMap.Property colProp : colProps) {
            if ("GUID".equalsIgnoreCase(colProp.getName())) continue;
            this.setProperty(colProp.getName(), colProp);
        }
        return this;
    }

    public ColumnBuilder setFromColumn(ColumnBuilder template) {
        DataType type;
        this._type = type = template.getType();
        this._length = template._length;
        this._autoNumber = template._autoNumber;
        if (type.getHasScalePrecision()) {
            this._scale = template._scale;
            this._precision = template._precision;
        }
        this._calculated = template._calculated;
        this._compressedUnicode = template._compressedUnicode;
        this._hyperlink = template._hyperlink;
        this._sortOrder = template._sortOrder;
        if (template._props != null) {
            this._props = new HashMap<String, PropertyMap.Property>(template._props);
        }
        return this;
    }

    public ColumnBuilder escapeName() {
        this._name = TableBuilder.escapeIdentifier(this._name);
        return this;
    }

    public short getColumnNumber() {
        return this._columnNumber;
    }

    public void setColumnNumber(short newColumnNumber) {
        this._columnNumber = newColumnNumber;
    }

    public ColumnImpl.SortOrder getTextSortOrder() {
        return this._sortOrder;
    }

    public void setTextSortOrder(ColumnImpl.SortOrder newTextSortOrder) {
        this._sortOrder = newTextSortOrder;
    }

    public void validate(JetFormat format) {
        DatabaseImpl.validateIdentifierName(this.getName(), format.MAX_COLUMN_NAME_LENGTH, "column");
        if (this.getType() == null) {
            throw new IllegalArgumentException(this.withErrorContext("must have type"));
        }
        if (this.getType().isUnsupported()) {
            throw new IllegalArgumentException(this.withErrorContext("Cannot create column with unsupported type " + (Object)((Object)this.getType())));
        }
        if (!format.isSupportedDataType(this.getType())) {
            throw new IllegalArgumentException(this.withErrorContext("Database format " + format + " does not support type " + (Object)((Object)this.getType())));
        }
        if (!this.getType().isVariableLength()) {
            if (this.getLength() < this.getType().getFixedSize()) {
                throw new IllegalArgumentException(this.withErrorContext("Invalid fixed length size " + this.getLength()));
            }
        } else if (!this.getType().isLongValue() && !this.getType().isValidSize(this.getLength())) {
            throw new IllegalArgumentException(this.withErrorContext("Var length must be from " + this.getType().getMinSize() + " to " + this.getType().getMaxSize() + " inclusive, found " + this.getLength()));
        }
        if (this.getType().getHasScalePrecision()) {
            if (!this.getType().isValidScale(this.getScale())) {
                throw new IllegalArgumentException(this.withErrorContext("Scale must be from " + this.getType().getMinScale() + " to " + this.getType().getMaxScale() + " inclusive, found " + this.getScale()));
            }
            if (!this.getType().isValidPrecision(this.getPrecision())) {
                throw new IllegalArgumentException(this.withErrorContext("Precision must be from " + this.getType().getMinPrecision() + " to " + this.getType().getMaxPrecision() + " inclusive, found " + this.getPrecision()));
            }
        }
        if (this.isAutoNumber() && !this.getType().mayBeAutoNumber()) {
            throw new IllegalArgumentException(this.withErrorContext("Auto number column must be long integer or guid"));
        }
        if (this.isCompressedUnicode() && !this.getType().isTextual()) {
            throw new IllegalArgumentException(this.withErrorContext("Only textual columns allow unicode compression (text/memo)"));
        }
        if (this.isHyperlink() && this.getType() != DataType.MEMO) {
            throw new IllegalArgumentException(this.withErrorContext("Only memo columns can be hyperlinks"));
        }
        if (this.isCalculated()) {
            if (!format.isSupportedCalculatedDataType(this.getType())) {
                throw new IllegalArgumentException(this.withErrorContext("Database format " + format + " does not support calculated type " + (Object)((Object)this.getType())));
            }
            if (this.getProperty("Expression") == null) {
                throw new IllegalArgumentException(this.withErrorContext("No expression provided for calculated type " + (Object)((Object)this.getType())));
            }
            if (this.getProperty("ResultType") == null) {
                this.putProperty("ResultType", this.getType().getValue());
            }
        }
    }

    public ColumnBuilder toColumn() {
        return this;
    }

    public Column addToTable(Table table) throws IOException {
        return new TableUpdater((TableImpl)table).addColumn(this);
    }

    private String withErrorContext(String msg) {
        return msg + "(Column=" + this.getName() + ")";
    }
}

