###################################################
# Samba4 parser generator for swig wrappers
# Copyright tpot@samba.org 2004,2005
# released under the GNU GPL

package Parse::Pidl::Samba::SWIG;

use vars qw($VERSION);
$VERSION = '0.01';

use strict;

sub pidl($)
{
	print OUT shift;
}

#####################################################################
# rewrite autogenerated header file
sub RewriteHeader($$$)
{
    my($idl) = shift;
    my($input) = shift;
    my($output) = shift;

    open(IN, "<$input") || die "can't open $input for reading";
    open(OUT, ">$output") || die "can't open $output for writing";    

    pidl "%{\n";
    pidl "#define data_in in\n";
    pidl "#define data_out out\n";
    pidl "%}\n\n";
   
    while(<IN>) {

	# Rename dom_sid2 to dom_sid as we don't care about the difference
	# for the swig wrappers.

	s/dom_sid2/dom_sid/g;

	# Copy structure and union definitions

	if (/^(struct|union) .*? {$/ .. /^\};$/) {
	    s/\} (in|out);/\} data_$1;/; # "in" is a Python keyword
	    pidl $_;
	    next;
	}

	# Copy dcerpc functions

	pidl $_ if /^NTSTATUS dcerpc_.*?\(struct dcerpc_pipe/;

	# Copy interface definitions

        pidl $_ 
	    if /^\#define DCERPC_.*?_UUID/ or /^\#define DCERPC_.*?_VERSION/;
    }

    close(OUT);   
}

#####################################################################
# rewrite autogenerated header file
sub RewriteC($$$)
{
    my($idl) = shift;
    my($input) = shift;
    my($output) = shift;

    open(IN, "<$input") || die "can't open $input for reading";
    open(OUT, ">>$output") || die "can't open $output for writing";    
   
    while(<IN>) {
    }

    close(OUT);   
}

1;
