#!perl
#   ---------------------------------------------------------------------- copyright and license ---
#
#   file: t/dist-zilla-build-synopsis.t
#
#   Copyright © 2015, 2016 Van de Bugger.
#
#   This file is part of perl-Test-Dist-Zilla.
#
#   perl-Test-Dist-Zilla is free software: you can redistribute it and/or modify it under the terms
#   of the GNU General Public License as published by the Free Software Foundation, either version
#   3 of the License, or (at your option) any later version.
#
#   perl-Test-Dist-Zilla is distributed in the hope that it will be useful, but WITHOUT ANY
#   WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
#   PURPOSE. See the GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License along with
#   perl-Test-Dist-Zilla. If not, see <http://www.gnu.org/licenses/>.
#
#   ---------------------------------------------------------------------- copyright and license ---

#   This test is also used as a synopsis for `Test::Dist::Zilla::Build`.                    # DNI
#   Note: All lines containing `# DNI` will not be included.                                # DNI

# Let's test Manifest Dist::Zilla plugin:

use strict;
use warnings;

use if $ENV{AUTOMATED_TESTING}, 'Test::DiagINC'; use Path::Tiny;
use Test::Deep qw{ cmp_deeply re };
use Test::More;
use Test::Routine;
use Test::Routine::Util;

with 'Test::Dist::Zilla::Build';

sub _build_message_filter {
    return sub {
        map(
            { $_ =~ s{^\[.*?\] }{}; $_; }   # Drop plugin name from messages.
            grep( { $_ =~ qr{^\Q[Manifest]\E } } @_ )
                # We are interested only in messages printed by the plugin.
        );
    };
};

test Manifest => sub {
    my ( $self ) = @_;
    my $expected = $self->{ expected };
    $self->skip_if_exception;
    if ( not exists( $expected->{ manifest } ) ) {
        plan skip_all => 'no expected manifest';
    };
    my $built_in = path( $self->tzil->built_in );
    my @manifest = $built_in->child( 'MANIFEST' )->lines( { chomp => 1 } );
    my $comment = shift( @manifest );
    like(
        $comment,
        qr{
            ^ \# \Q This file was automatically generated by \E
            Dist::Zilla::Plugin::Manifest
        }x,
        'first line is a comment',
    );
    cmp_deeply( \@manifest, $expected->{ manifest }, 'manifest body' )
        or do { diag( "MANIFEST:" ); diag( "    $_" ) for @manifest; };
};

run_me 'Positive test' => {
    # exception and messages are checked by Build test (defined in
    # Test::Dist::Zilla::Build), manifest content is checked by
    # Manifest test defined above.
    plugins => [                        # Plugins to use.
        'GatherDir',
        'Manifest',
        'MetaJSON',
    ],
    files => {                          # Files to add.
        'lib/Dummy.pm' => 'package Dummy; 1;',
    },
    expected => {                       # Expected outcome.
        # exception is not specified => successful build is expected.
        messages => [],                 # No messages from the plugin expected.
        manifest => [                   # Expected content of MANIFEST.
            'MANIFEST',
            'META.json',
            'dist.ini',
            'lib/Dummy.pm',
        ],
    },
};

done_testing;

# end of file #
