#line 1 "inc/Module/Build/Compat.pm - /Library/Perl/5.8.6/Module/Build/Compat.pm"
package Module::Build::Compat;

use strict;
use vars qw($VERSION);
$VERSION = '0.03';

use File::Spec;
use IO::File;
use Config;
use Module::Build;
use Data::Dumper;

my %makefile_to_build = 
  (
   TEST_VERBOSE => 'verbose',
   VERBINST     => 'verbose',
   INC     => sub { map {('--extra_compiler_flags', "-I$_")} Module::Build->split_like_shell(shift) },
   POLLUTE => sub { ('--extra_compiler_flags', '-DPERL_POLLUTE') },
   INSTALLDIRS => sub {local $_ = shift; 'installdirs=' . (/^perl$/ ? 'core' : $_) },
   PREFIX => sub {die "Sorry, PREFIX is not supported.  See the Module::Build\n".
		      "documentation for 'destdir' or 'install_base' instead.\n"},
   LIB => sub { ('--install_path', 'lib='.shift()) },
  );



sub create_makefile_pl {
  my ($package, $type, $build, %args) = @_;
  
  die "Don't know how to build Makefile.PL of type '$type'"
    unless $type =~ /^(small|passthrough|traditional)$/;

  my $fh;
  if ($args{fh}) {
    $fh = $args{fh};
  } else {
    $args{file} ||= 'Makefile.PL';
    $fh = IO::File->new("> $args{file}") or die "Can't write $args{file}: $!";
  }

  print {$fh} "# Note: this file was auto-generated by ", __PACKAGE__, " version $VERSION\n";
  my $subclass_dir = File::Spec->catdir($build->config_dir, 'lib');
  $subclass_dir =~ s/([\'\\])/\\$1/g;
  
  if ($type eq 'small') {
    printf {$fh} <<'EOF', $subclass_dir, ref($build), ref($build);
    use Module::Build::Compat 0.02;
    use lib '%s';
    Module::Build::Compat->run_build_pl(args => \@ARGV);
    require %s;
    Module::Build::Compat->write_makefile(build_class => '%s');
EOF

  } elsif ($type eq 'passthrough') {
    printf {$fh} <<'EOF', $subclass_dir, ref($build), ref($build);
    
    unless (eval "use Module::Build::Compat 0.02; 1" ) {
      print "This module requires Module::Build to install itself.\n";
      
      require ExtUtils::MakeMaker;
      my $yn = ExtUtils::MakeMaker::prompt
	('  Install Module::Build now from CPAN?', 'y');
      
      unless ($yn =~ /^y/i) {
	die " *** Cannot install without Module::Build.  Exiting ...\n";
      }
      
      require Cwd;
      require File::Spec;
      require CPAN;
      
      # Save this 'cause CPAN will chdir all over the place.
      my $cwd = Cwd::cwd();
      my $makefile = File::Spec->rel2abs($0);
      
      CPAN::Shell->install('Module::Build::Compat')
	or die " *** Cannot install without Module::Build.  Exiting ...\n";
      
      chdir $cwd or die "Cannot chdir() back to $cwd: $!";
    }
    eval "use Module::Build::Compat 0.02; 1" or die $@;
    use lib '%s';
    Module::Build::Compat->run_build_pl(args => \@ARGV);
    require %s;
    Module::Build::Compat->write_makefile(build_class => '%s');
EOF
    
  } elsif ($type eq 'traditional') {

    my (%MM_Args, %prereq);
    if (eval "use Tie::IxHash; 1") {
      tie %MM_Args, 'Tie::IxHash'; # Don't care if it fails here
      tie %prereq,  'Tie::IxHash'; # Don't care if it fails here
    }
    
    my %name = ($build->module_name
		? (NAME => $build->module_name)
		: (DISTNAME => $build->dist_name));
    
    my %version = ($build->dist_version_from
		   ? (VERSION_FROM => $build->dist_version_from)
		   : (VERSION      => $build->dist_version)
		  );
    %MM_Args = (%name, %version);
    
    %prereq = ( %{$build->requires}, %{$build->build_requires} );
    %prereq = map {$_, $prereq{$_}} sort keys %prereq;
    
    delete $prereq{perl};
    $MM_Args{PREREQ_PM} = \%prereq;
    
    $MM_Args{INSTALLDIRS} = $build->installdirs eq 'core' ? 'perl' : $build->installdirs;
    
    $MM_Args{EXE_FILES} = [ sort keys %{$build->script_files} ] if $build->script_files;
    
    $MM_Args{PL_FILES} = {};
    
    local $Data::Dumper::Terse = 1;
    my $args = Data::Dumper::Dumper(\%MM_Args);
    $args =~ s/\{(.*)\}/($1)/s;
    
    print $fh <<"EOF";
use ExtUtils::MakeMaker;
WriteMakefile
$args;
EOF
  }
}


sub makefile_to_build_args {
  shift;
  my @out;
  foreach my $arg (@_) {
    my ($key, $val) = ($arg =~ /^(\w+)=(.+)/ ? ($1, $2) :
		       die "Malformed argument '$arg'");

    # Do tilde-expansion if it looks like a tilde prefixed path
    ( $val ) = glob( $val ) if $val =~ /^~/;

    if (exists $makefile_to_build{$key}) {
      my $trans = $makefile_to_build{$key};
      push @out, ref($trans) ? $trans->($val) : "$trans=$val";
    } elsif (exists $Config{lc($key)}) {
      push @out, 'config=' . lc($key) . "=$val";
    } else {
      # Assume M::B can handle it in lowercase form
      push @out, "\L$key\E=$val";
    }
  }
  return @out;
}

sub makefile_to_build_macros {
  my @out;
  while (my ($macro, $trans) = each %makefile_to_build) {
    # On some platforms (e.g. Cygwin with 'make'), the mere presence
    # of "EXPORT: FOO" in the Makefile will make $ENV{FOO} defined.
    # Therefore we check length() too.
    next unless exists $ENV{$macro} && length $ENV{$macro};
    my $val = $ENV{$macro};
    push @out, ref($trans) ? $trans->($val) : ($trans => $val);
  }
  return @out;
}

sub run_build_pl {
  my ($pack, %in) = @_;
  $in{script} ||= 'Build.PL';
  my @args = $in{args} ? $pack->makefile_to_build_args(@{$in{args}}) : ();
  print "# running $in{script} @args\n";
  Module::Build->run_perl_script($in{script}, [], \@args) or die "Couldn't run $in{script}: $!";
}

sub fake_makefile {
  my ($self, %args) = @_;
  unless (exists $args{build_class}) {
    warn "Unknown 'build_class', defaulting to 'Module::Build'\n";
    $args{build_class} = 'Module::Build';
  }

  my $perl = $args{build_class}->find_perl_interpreter;
  my $os_type = $args{build_class}->os_type;
  my $noop = ($os_type eq 'Windows' ? 'rem>nul' :
	      $os_type eq 'VMS'     ? 'Continue' :
	      'true');
  my $Build = 'Build --makefile_env_macros 1';

  # Start with a couple special actions
  my $maketext = <<"EOF";
all : force_do_it
	$perl $Build
realclean : force_do_it
	$perl $Build realclean
	$perl -e unlink -e shift $args{makefile}

force_do_it :
	@ $noop
EOF

  foreach my $action ($args{build_class}->known_actions) {
    next if $action =~ /^(all|realclean|force_do_it)$/;  # Don't double-define
    $maketext .= <<"EOF";
$action : force_do_it
	$perl $Build $action
EOF
  }
  
  $maketext .= "\n.EXPORT : " . join(' ', keys %makefile_to_build) . "\n\n";
  
  return $maketext;
}

sub fake_prereqs {
  my $file = File::Spec->catfile('_build', 'prereqs');
  my $fh = IO::File->new("< $file") or die "Can't read $file: $!";
  my $prereqs = eval do {local $/; <$fh>};
  close $fh;
  
  my @prereq;
  foreach my $section (qw/build_requires requires/) {
    foreach (keys %{$prereqs->{$section}}) {
      next if $_ eq 'perl';
      push @prereq, "$_=>q[$prereqs->{$section}{$_}]";
    }
  }

  return unless @prereq;
  return "#     PREREQ_PM => { " . join(", ", @prereq) . " }\n\n";
}


sub write_makefile {
  my ($pack, %in) = @_;
  $in{makefile} ||= 'Makefile';
  open  MAKE, "> $in{makefile}" or die "Cannot write $in{makefile}: $!";
  print MAKE $pack->fake_prereqs;
  print MAKE $pack->fake_makefile(%in);
  close MAKE;
}

1;
__END__


#line 412
