# Generated by default/object.tt
package Paws::FraudDetector::ModelVersionDetail;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str', request_name => 'arn', traits => ['NameInRequest']);
  has CreatedTime => (is => 'ro', isa => 'Str', request_name => 'createdTime', traits => ['NameInRequest']);
  has ExternalEventsDetail => (is => 'ro', isa => 'Paws::FraudDetector::ExternalEventsDetail', request_name => 'externalEventsDetail', traits => ['NameInRequest']);
  has LastUpdatedTime => (is => 'ro', isa => 'Str', request_name => 'lastUpdatedTime', traits => ['NameInRequest']);
  has ModelId => (is => 'ro', isa => 'Str', request_name => 'modelId', traits => ['NameInRequest']);
  has ModelType => (is => 'ro', isa => 'Str', request_name => 'modelType', traits => ['NameInRequest']);
  has ModelVersionNumber => (is => 'ro', isa => 'Str', request_name => 'modelVersionNumber', traits => ['NameInRequest']);
  has Status => (is => 'ro', isa => 'Str', request_name => 'status', traits => ['NameInRequest']);
  has TrainingDataSchema => (is => 'ro', isa => 'Paws::FraudDetector::TrainingDataSchema', request_name => 'trainingDataSchema', traits => ['NameInRequest']);
  has TrainingDataSource => (is => 'ro', isa => 'Str', request_name => 'trainingDataSource', traits => ['NameInRequest']);
  has TrainingResult => (is => 'ro', isa => 'Paws::FraudDetector::TrainingResult', request_name => 'trainingResult', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::FraudDetector::ModelVersionDetail

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::FraudDetector::ModelVersionDetail object:

  $service_obj->Method(Att1 => { Arn => $value, ..., TrainingResult => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::FraudDetector::ModelVersionDetail object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

The details of the model version.

=head1 ATTRIBUTES


=head2 Arn => Str

The model version ARN.


=head2 CreatedTime => Str

The timestamp when the model was created.


=head2 ExternalEventsDetail => L<Paws::FraudDetector::ExternalEventsDetail>

The event details.


=head2 LastUpdatedTime => Str

The timestamp when the model was last updated.


=head2 ModelId => Str

The model ID.


=head2 ModelType => Str

The model type.


=head2 ModelVersionNumber => Str

The model version number.


=head2 Status => Str

The status of the model version.


=head2 TrainingDataSchema => L<Paws::FraudDetector::TrainingDataSchema>

The training data schema.


=head2 TrainingDataSource => Str

The model version training data source.


=head2 TrainingResult => L<Paws::FraudDetector::TrainingResult>

The training results.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::FraudDetector>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

