  use strict;
  use warnings;
  
  use OpenMP::Simple;
  use OpenMP::Environment;
  
  use Inline (
      C    => 'DATA',
      with => qw/OpenMP::Simple/,
  );
  
  my $env = OpenMP::Environment->new;
  
  for my $num_threads ( 1 .. 8 ) {
      my $current_value = $env->omp_num_threads($num_threads);
      $env->assert_omp_environment;   # validates OpenMP related variables in %ENV
      printf "The number of threads (%0d) spawned in
                 the OpenMP runtime via OMP_NUM_THREADS\n", $num_threads;
  }
  
  __DATA__
  __C__

  /* C function parallelized with OpenMP */
  int _get_num_threads() {
    PerlOMP_UPDATE_WITH_ENV__NUM_THREADS /* MACRO from OpenMP::Simple */
    int ret = 0;
    #pragma omp parallel
    {
      #pragma omp single
      ret = omp_get_num_threads();
    }
    return ret;
  }
