use warnings;
use strict;

use Test::More tests => 196;

BEGIN { use_ok "Data::Pond", qw(pond_read_datum pond_write_datum); }

is_deeply pond_read_datum($_), eval($_) foreach
	'""',
	'"abc"',
	'"a b"',
	"\"a'b\"",
	'"a\tb"',
	'"a\nb"',
	"\"a\\\\b\"",
	"\"a\\\"b\"",
	"\"a\\\$b\"",
	"\"a\\\*b\"",
	'"a\xe3b"',
	'"a\x00b"',
	'"a\x7fb"',
	'"a\x80b"',
	'"a\xa0b"',
	'"a\x{123}b"',
	"\"a\x{123}b\"",
	'"a\123b"',
	'"a\12b"',
	'"a\1b"',
	' "abc" ',
	"''",
	"'abc'",
	"'a\"bc'",
	"'a\\bc'",
	"'a\\'bc'",
	"'a\\\\bc'",
	"'a\\\"bc'",
	"'a\x{123}b'",
	" 'abc' ",
	'123',
	'7',
	'0',
	'"0123"',
	'"00"',
	'"1234567890"',
	' 123 ',
	'[]',
	'[1]',
	'[ 1 ]',
	'[1,]',
	'[ 1 , ]',
	'["a",2]',
	'["a",2,]',
	'["a",[2],]',
	' [ "a" , [ 2 ] , ] ',
	'{}',
	'{1,2}',
	'{1,2,}',
	' { 1 , 2 , } ',
	'{a=>b=>}',
	' { a => b => } ',
	'{a=>[],b=>123}',
	'{a=>[],b=>123,}',
	'{" foo",123}';

is pond_write_datum(pond_read_datum($_), {unicode=>1}), $_ foreach
	'""',
	'"abc"',
	'"a b"',
	"\"a'b\"",
	'"a\tb"',
	'"a\nb"',
	"\"a\\\\b\"",
	"\"a\\\"b\"",
	"\"a\\\$b\"",
	"\"a*b\"",
	"\"a\xe3b\"",
	'"a\x00b"',
	'"a\x7fb"',
	'"a\x80b"',
	'"a\xa0b"',
	"\"a\x{123}b\"",
	'123',
	'7',
	'0',
	'"0123"',
	'"00"',
	'"1234567890"',
	'[]',
	'[1]',
	'["a",2]',
	'["a",[2]]',
	'{}',
	'{1=>2}',
	'{a=>"b"}',
	'{a=>[],b=>123}',
	'{a=>[],b=>"0123"}',
	'{a=>[],b=>"00"}',
	'{a=>[],b=>"1234567890"}',
	'{" foo"=>123}',
	"{\"z\x{123}Z\"=>[\"a\x{123}A\"]}";

is pond_write_datum(pond_read_datum($_), {indent=>0, unicode=>1}), $_ foreach
	'""',
	'"abc"',
	'"a b"',
	"\"a'b\"",
	'"a\tb"',
	'"a\nb"',
	"\"a\\\\b\"",
	"\"a\\\"b\"",
	"\"a\\\$b\"",
	"\"a*b\"",
	"\"a\xe3b\"",
	'"a\x00b"',
	'"a\x7fb"',
	'"a\x80b"',
	'"a\xa0b"',
	"\"a\x{123}b\"",
	'123',
	'7',
	'0',
	'"0123"',
	'"00"',
	'"1234567890"',
	'[]',
	"[\n    1,\n]",
	"[\n    \"a\",\n    2,\n]",
	"[\n    \"a\",\n    [\n        2,\n    ],\n]",
	"{}",
	"{\n    1 => 2,\n}",
	"{\n    a => \"b\",\n}",
	"{\n    a => [],\n    b => 123,\n}",
	"{\n    a => [],\n    b => \"0123\",\n}",
	"{\n    a => [],\n    b => \"00\",\n}",
	"{\n    a => [],\n    b => \"1234567890\",\n}",
	"{\n    \" foo\" => 123,\n}",
	"{\n    \"z\x{123}Z\" => [\n        \"a\x{123}A\",\n    ],\n}";

is pond_write_datum(pond_read_datum($_), {}), $_ foreach
	'""',
	'"abc"',
	'"a b"',
	"\"a'b\"",
	'"a\tb"',
	'"a\nb"',
	"\"a\\\\b\"",
	"\"a\\\"b\"",
	"\"a\\\$b\"",
	"\"a*b\"",
	'"a\x{e3}b"',
	'"a\x00b"',
	'"a\x7fb"',
	'"a\x80b"',
	'"a\xa0b"',
	'"a\x{123}b"',
	'123',
	'7',
	'0',
	'"0123"',
	'"00"',
	'"1234567890"',
	'[]',
	'[1]',
	'["a",2]',
	'["a",[2]]',
	'{}',
	'{1=>2}',
	'{a=>"b"}',
	'{a=>[],b=>123}',
	'{a=>[],b=>"0123"}',
	'{a=>[],b=>"00"}',
	'{a=>[],b=>"1234567890"}',
	'{" foo"=>123}',
	"{\"z\\x{123}Z\"=>[\"a\\x{123}A\"]}";

is pond_write_datum(pond_read_datum($_), {indent=>0}), $_ foreach
	'""',
	'"abc"',
	'"a b"',
	"\"a'b\"",
	'"a\tb"',
	'"a\nb"',
	"\"a\\\\b\"",
	"\"a\\\"b\"",
	"\"a\\\$b\"",
	"\"a*b\"",
	"\"a\\x{e3}b\"",
	'"a\x00b"',
	'"a\x7fb"',
	'"a\x80b"',
	'"a\xa0b"',
	"\"a\\x{123}b\"",
	'123',
	'7',
	'0',
	'"0123"',
	'"00"',
	'"1234567890"',
	'[]',
	"[\n    1,\n]",
	"[\n    \"a\",\n    2,\n]",
	"[\n    \"a\",\n    [\n        2,\n    ],\n]",
	"{}",
	"{\n    1 => 2,\n}",
	"{\n    a => \"b\",\n}",
	"{\n    a => [],\n    b => 123,\n}",
	"{\n    a => [],\n    b => \"0123\",\n}",
	"{\n    a => [],\n    b => \"00\",\n}",
	"{\n    a => [],\n    b => \"1234567890\",\n}",
	"{\n    \" foo\" => 123,\n}",
	"{\n    \"z\\x{123}Z\" => [\n        \"a\\x{123}A\",\n    ],\n}";

1;
