/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock;

import org.couchbase.mock.Bucket;
import org.jetbrains.annotations.NotNull;

public class BucketConfiguration {
    public int numVBuckets = 1024;
    public int numNodes = 10;
    public int numReplicas = 2;
    public Bucket.BucketType type = Bucket.BucketType.COUCHBASE;
    public String name;
    @NotNull
    public String password = "";
    public String hostname = "localhost";
    public int bucketStartPort = 0;

    public boolean validate() {
        return this.name != null && this.bucketStartPort >= 0;
    }

    public BucketConfiguration() {
    }

    public BucketConfiguration(BucketConfiguration other) {
        this.numVBuckets = other.numVBuckets;
        this.numNodes = other.numNodes;
        this.numReplicas = other.numReplicas;
        this.type = other.type;
        this.hostname = other.hostname;
    }

    public String getName() {
        return this.name;
    }

    @NotNull
    public String getPassword() {
        return this.password;
    }

    public Bucket.BucketType getType() {
        return this.type;
    }
}

