use Unicode::Collate::CJK::Korean;
+{
   locale_version => 0.93,
   overrideCJK => \&Unicode::Collate::CJK::Korean::weightKorean,
   entry => <<'ENTRY', # for DUCET v6.2.0
F967      ; [.315D.0021.0002.4E0D][.31E1.0020.0002.4E0D] # CJK COMPATIBILITY IDEOGRAPH-F967
FA70      ; [.315D.0032.0002.4E26][.31DA.0020.0002.4E26][.3246.0020.0002.4E26] # CJK COMPATIBILITY IDEOGRAPH-FA70
F905      ; [.3156.0021.0002.4E32][.31DC.0020.0002.4E32][.3247.0020.0002.4E32] # CJK COMPATIBILITY IDEOGRAPH-F905
2F801     ; [.3168.0021.0002.4E38][.31DD.0020.0002.4E38][.3235.0020.0002.4E38] # CJK COMPATIBILITY IDEOGRAPH-2F801
F95E      ; [.3159.0021.0002.4E39][.31D4.0020.0002.4E39][.3235.0020.0002.4E39] # CJK COMPATIBILITY IDEOGRAPH-F95E
F91B      ; [.315B.0021.0002.4E82][.31D4.0020.0002.4E82][.3235.0020.0002.4E82] # CJK COMPATIBILITY IDEOGRAPH-F91B
F9BA      ; [.315B.0021.0002.4E86][.31E0.0020.0002.4E86] # CJK COMPATIBILITY IDEOGRAPH-F9BA
F977      ; [.315B.0021.0002.4EAE][.31D6.0020.0002.4EAE][.3246.0020.0002.4EAE] # CJK COMPATIBILITY IDEOGRAPH-F977
F9FD      ; [.315F.0021.0002.4EC0][.31E8.0020.0002.4EC0][.3242.0020.0002.4EC0] # CJK COMPATIBILITY IDEOGRAPH-F9FD
F9A8      ; [.315B.0021.0002.4EE4][.31DA.0020.0002.4EE4][.3246.0020.0002.4EE4] # CJK COMPATIBILITY IDEOGRAPH-F9A8
F92D      ; [.315B.0021.0002.4F86][.31D5.0020.0002.4F86] # CJK COMPATIBILITY IDEOGRAPH-F92D
F9B5      ; [.315B.0021.0002.4F8B][.31DB.0020.0002.4F8B] # CJK COMPATIBILITY IDEOGRAPH-F9B5
FA30      ; [.315C.0021.0002.4FAE][.31DC.0020.0002.4FAE] # CJK COMPATIBILITY IDEOGRAPH-FA30
2F805     ; [.315C.0021.0002.4FAE][.31DC.0020.0002.4FAE] # CJK COMPATIBILITY IDEOGRAPH-2F805
2F806     ; [.3166.0023.0002.4FBB][.31D4.0020.0002.4FBB][.3239.0020.0002.4FBB] # CJK COMPATIBILITY IDEOGRAPH-2F806
F965      ; [.3167.0021.0002.4FBF][.31DA.0020.0002.4FBF][.3235.0020.0002.4FBF] # CJK COMPATIBILITY IDEOGRAPH-F965
2F807     ; [.315D.0022.0002.5002][.31DA.0020.0002.5002][.3246.0020.0002.5002] # CJK COMPATIBILITY IDEOGRAPH-2F807
F9D4      ; [.315B.0022.0002.502B][.31E5.0020.0002.502B][.3235.0020.0002.502B] # CJK COMPATIBILITY IDEOGRAPH-F9D4
2F809     ; [.315D.0022.0002.5099][.31E8.0020.0002.5099] # CJK COMPATIBILITY IDEOGRAPH-2F809
2F80B     ; [.315F.0023.0002.50CF][.31D4.0020.0002.50CF][.3246.0020.0002.50CF] # CJK COMPATIBILITY IDEOGRAPH-2F80B
F9BB      ; [.315B.0022.0002.50DA][.31E0.0020.0002.50DA] # CJK COMPATIBILITY IDEOGRAPH-F9BB
FA31      ; [.315F.0023.0002.50E7][.31E6.0020.0002.50E7][.3246.0020.0002.50E7] # CJK COMPATIBILITY IDEOGRAPH-FA31
2F80A     ; [.315F.0023.0002.50E7][.31E6.0020.0002.50E7][.3246.0020.0002.50E7] # CJK COMPATIBILITY IDEOGRAPH-2F80A
FA0C      ; [.3161.0021.0002.5140][.31DC.0020.0002.5140][.3239.0020.0002.5140] # CJK COMPATIBILITY IDEOGRAPH-FA0C
FA74      ; [.3164.0021.0002.5145][.31E1.0020.0002.5145][.3246.0020.0002.5145] # CJK COMPATIBILITY IDEOGRAPH-FA74
FA32      ; [.315C.0021.0002.514D][.31DA.0020.0002.514D][.3235.0020.0002.514D] # CJK COMPATIBILITY IDEOGRAPH-FA32
2F80E     ; [.315C.0021.0002.514D][.31DA.0020.0002.514D][.3235.0020.0002.514D] # CJK COMPATIBILITY IDEOGRAPH-2F80E
2F814     ; [.3158.0022.0002.5167][.31D5.0020.0002.5167] # CJK COMPATIBILITY IDEOGRAPH-2F814
FA72      ; [.3162.0024.0002.5168][.31D8.0020.0002.5168][.3235.0020.0002.5168] # CJK COMPATIBILITY IDEOGRAPH-FA72
F978      ; [.315B.0023.0002.5169][.31D6.0020.0002.5169][.3246.0020.0002.5169] # CJK COMPATIBILITY IDEOGRAPH-F978
F9D1      ; [.315B.0021.0002.516D][.31E5.0020.0002.516D][.3232.0020.0002.516D] # CJK COMPATIBILITY IDEOGRAPH-F9D1
2F811     ; [.3156.0026.0002.5177][.31E1.0020.0002.5177] # CJK COMPATIBILITY IDEOGRAPH-2F811
FA75      ; [.3156.0024.0002.5180][.31E8.0020.0002.5180] # CJK COMPATIBILITY IDEOGRAPH-FA75
2F815     ; [.3162.0021.0002.518D][.31D5.0020.0002.518D] # CJK COMPATIBILITY IDEOGRAPH-2F815
2F8D2     ; [.315C.0022.0002.5192][.31DC.0020.0002.5192] # CJK COMPATIBILITY IDEOGRAPH-2F8D2
2F8D3     ; [.315C.0022.0002.5195][.31DA.0020.0002.5195][.3235.0020.0002.5195] # CJK COMPATIBILITY IDEOGRAPH-2F8D3
2F817     ; [.3161.0023.0002.5197][.31E0.0020.0002.5197][.3246.0020.0002.5197] # CJK COMPATIBILITY IDEOGRAPH-2F817
2F818     ; [.3161.003B.0002.51A4][.31E2.0020.0002.51A4][.3235.0020.0002.51A4] # CJK COMPATIBILITY IDEOGRAPH-2F818
2F81A     ; [.3159.0022.0002.51AC][.31DC.0020.0002.51AC][.3246.0020.0002.51AC] # CJK COMPATIBILITY IDEOGRAPH-2F81A
F92E      ; [.315B.0021.0002.51B7][.31D5.0020.0002.51B7][.3246.0020.0002.51B7] # CJK COMPATIBILITY IDEOGRAPH-F92E
F979      ; [.315B.0024.0002.51C9][.31D6.0020.0002.51C9][.3246.0020.0002.51C9] # CJK COMPATIBILITY IDEOGRAPH-F979
F955      ; [.315B.0021.0002.51CC][.31E6.0020.0002.51CC][.3246.0020.0002.51CC] # CJK COMPATIBILITY IDEOGRAPH-F955
F954      ; [.315B.0021.0002.51DC][.31E6.0020.0002.51DC][.3241.0020.0002.51DC] # CJK COMPATIBILITY IDEOGRAPH-F954
FA15      ; [.3168.0022.0002.51DE][.31E7.0020.0002.51DE] # CJK COMPATIBILITY IDEOGRAPH-FA15
2F81E     ; [.3161.0023.0002.5203][.31E8.0020.0002.5203][.3235.0020.0002.5203] # CJK COMPATIBILITY IDEOGRAPH-2F81E
FA00      ; [.3162.0021.0002.5207][.31D8.0020.0002.5207][.3239.0020.0002.5207] # CJK COMPATIBILITY IDEOGRAPH-FA00
2F850     ; [.3162.0021.0002.5207][.31D8.0020.0002.5207][.3239.0020.0002.5207] # CJK COMPATIBILITY IDEOGRAPH-2F850
F99C      ; [.315B.0022.0002.5217][.31DA.0020.0002.5217][.3239.0020.0002.5217] # CJK COMPATIBILITY IDEOGRAPH-F99C
F9DD      ; [.315B.0022.0002.5229][.31E8.0020.0002.5229] # CJK COMPATIBILITY IDEOGRAPH-F9DD
F9FF      ; [.3162.0022.0002.523A][.31D4.0020.0002.523A] # CJK COMPATIBILITY IDEOGRAPH-F9FF
2F820     ; [.3156.0021.0002.523B][.31D4.0020.0002.523B][.3232.0020.0002.523B] # CJK COMPATIBILITY IDEOGRAPH-2F820
2F822     ; [.3168.0021.0002.5272][.31D4.0020.0002.5272][.3239.0020.0002.5272] # CJK COMPATIBILITY IDEOGRAPH-2F822
2F823     ; [.315F.002D.0002.5277][.31D4.0020.0002.5277][.3235.0020.0002.5277] # CJK COMPATIBILITY IDEOGRAPH-2F823
F9C7      ; [.315B.0021.0002.5289][.31E5.0020.0002.5289] # CJK COMPATIBILITY IDEOGRAPH-F9C7
F98A      ; [.315B.0021.0002.529B][.31DA.0020.0002.529B][.3232.0020.0002.529B] # CJK COMPATIBILITY IDEOGRAPH-F98A
F99D      ; [.315B.0023.0002.52A3][.31DA.0020.0002.52A3][.3239.0020.0002.52A3] # CJK COMPATIBILITY IDEOGRAPH-F99D
FA76      ; [.3161.0024.0002.52C7][.31E0.0020.0002.52C7][.3246.0020.0002.52C7] # CJK COMPATIBILITY IDEOGRAPH-FA76
2F825     ; [.3161.0024.0002.52C7][.31E0.0020.0002.52C7][.3246.0020.0002.52C7] # CJK COMPATIBILITY IDEOGRAPH-2F825
FA33      ; [.315C.0023.0002.52C9][.31DA.0020.0002.52C9][.3235.0020.0002.52C9] # CJK COMPATIBILITY IDEOGRAPH-FA33
2F826     ; [.315C.0023.0002.52C9][.31DA.0020.0002.52C9][.3235.0020.0002.52C9] # CJK COMPATIBILITY IDEOGRAPH-2F826
F952      ; [.315B.0021.0002.52D2][.31E6.0020.0002.52D2][.3232.0020.0002.52D2] # CJK COMPATIBILITY IDEOGRAPH-F952
F92F      ; [.315B.0021.0002.52DE][.31DC.0020.0002.52DE] # CJK COMPATIBILITY IDEOGRAPH-F92F
FA34      ; [.3156.0023.0002.52E4][.31E6.0020.0002.52E4][.3235.0020.0002.52E4] # CJK COMPATIBILITY IDEOGRAPH-FA34
2F827     ; [.3156.0023.0002.52E4][.31E6.0020.0002.52E4][.3235.0020.0002.52E4] # CJK COMPATIBILITY IDEOGRAPH-2F827
F97F      ; [.315B.0023.0002.52F5][.31DA.0020.0002.52F5] # CJK COMPATIBILITY IDEOGRAPH-F97F
FA77      ; [.3162.0022.0002.52FA][.31D4.0020.0002.52FA][.3232.0020.0002.52FA] # CJK COMPATIBILITY IDEOGRAPH-FA77
2F828     ; [.3162.0022.0002.52FA][.31D4.0020.0002.52FA][.3232.0020.0002.52FA] # CJK COMPATIBILITY IDEOGRAPH-2F828
2F829     ; [.3167.0022.0002.5305][.31DC.0020.0002.5305] # CJK COMPATIBILITY IDEOGRAPH-2F829
F963      ; [.315D.0021.0002.5317][.31E1.0020.0002.5317][.3232.0020.0002.5317] # CJK COMPATIBILITY IDEOGRAPH-F963
2F82B     ; [.315D.0021.0002.5317][.31E1.0020.0002.5317][.3232.0020.0002.5317] # CJK COMPATIBILITY IDEOGRAPH-2F82B
F9EB      ; [.3158.0021.0002.533F][.31E8.0020.0002.533F][.3232.0020.0002.533F] # CJK COMPATIBILITY IDEOGRAPH-F9EB
2F82C     ; [.3168.0021.0002.5349][.31E3.0020.0002.5349] # CJK COMPATIBILITY IDEOGRAPH-2F82C
FA35      ; [.315D.0025.0002.5351][.31E8.0020.0002.5351] # CJK COMPATIBILITY IDEOGRAPH-FA35
2F82D     ; [.315D.0025.0002.5351][.31E8.0020.0002.5351] # CJK COMPATIBILITY IDEOGRAPH-2F82D
2F82E     ; [.315D.0022.0002.535A][.31D4.0020.0002.535A][.3232.0020.0002.535A] # CJK COMPATIBILITY IDEOGRAPH-2F82E
2F82F     ; [.3162.0022.0002.5373][.31E6.0020.0002.5373][.3232.0020.0002.5373] # CJK COMPATIBILITY IDEOGRAPH-2F82F
F91C      ; [.315B.0022.0002.5375][.31D4.0020.0002.5375][.3235.0020.0002.5375] # CJK COMPATIBILITY IDEOGRAPH-F91C
2F830     ; [.3162.0021.0002.537D][.31E6.0020.0002.537D][.3232.0020.0002.537D] # CJK COMPATIBILITY IDEOGRAPH-2F830
2F831     ; [.3156.0028.0002.537F][.31DA.0020.0002.537F][.3246.0020.0002.537F] # CJK COMPATIBILITY IDEOGRAPH-2F831
2F832     ; [.3156.0028.0002.537F][.31DA.0020.0002.537F][.3246.0020.0002.537F] # CJK COMPATIBILITY IDEOGRAPH-2F832
2F833     ; [.3156.0028.0002.537F][.31DA.0020.0002.537F][.3246.0020.0002.537F] # CJK COMPATIBILITY IDEOGRAPH-2F833
F96B      ; [.3164.0022.0002.53C3][.31D4.0020.0002.53C3][.3241.0020.0002.53C3] # CJK COMPATIBILITY IDEOGRAPH-F96B
2F836     ; [.3156.0022.0002.53CA][.31E6.0020.0002.53CA][.3242.0020.0002.53CA] # CJK COMPATIBILITY IDEOGRAPH-2F836
2F837     ; [.315F.005E.0002.53DF][.31E1.0020.0002.53DF] # CJK COMPATIBILITY IDEOGRAPH-2F837
F906      ; [.3156.002A.0002.53E5][.31E1.0020.0002.53E5] # CJK COMPATIBILITY IDEOGRAPH-F906
2F839     ; [.3156.0021.0002.53EB][.31E5.0020.0002.53EB] # CJK COMPATIBILITY IDEOGRAPH-2F839
2F83A     ; [.3162.0022.0002.53F1][.31E8.0020.0002.53F1][.3239.0020.0002.53F1] # CJK COMPATIBILITY IDEOGRAPH-2F83A
F9DE      ; [.315B.0024.0002.540F][.31E8.0020.0002.540F] # CJK COMPATIBILITY IDEOGRAPH-F9DE
F9ED      ; [.315B.0021.0002.541D][.31E8.0020.0002.541D][.3235.0020.0002.541D] # CJK COMPATIBILITY IDEOGRAPH-F9ED
2F83D     ; [.3168.0021.0002.5438][.31E6.0020.0002.5438][.3242.0020.0002.5438] # CJK COMPATIBILITY IDEOGRAPH-2F83D
F980      ; [.315B.0024.0002.5442][.31DA.0020.0002.5442] # CJK COMPATIBILITY IDEOGRAPH-F980
2F83E     ; [.3162.0026.0002.5448][.31D8.0020.0002.5448][.3246.0020.0002.5448] # CJK COMPATIBILITY IDEOGRAPH-2F83E
2F83F     ; [.3162.0028.0002.5468][.31E1.0020.0002.5468] # CJK COMPATIBILITY IDEOGRAPH-2F83F
2F840     ; [.3161.0031.0002.54A2][.31D4.0020.0002.54A2][.3232.0020.0002.54A2] # CJK COMPATIBILITY IDEOGRAPH-2F840
F99E      ; [.3161.0025.0002.54BD][.31E8.0020.0002.54BD][.3235.0020.0002.54BD] # CJK COMPATIBILITY IDEOGRAPH-F99E
2F842     ; [.3159.0021.0002.5510][.31D4.0020.0002.5510][.3246.0020.0002.5510] # CJK COMPATIBILITY IDEOGRAPH-2F842
2F843     ; [.3156.0022.0002.5553][.31DB.0020.0002.5553] # CJK COMPATIBILITY IDEOGRAPH-2F843
2F844     ; [.3168.0024.0002.5563][.31D4.0020.0002.5563][.3241.0020.0002.5563] # CJK COMPATIBILITY IDEOGRAPH-2F844
2F845     ; [.315F.0024.0002.5584][.31D8.0020.0002.5584][.3235.0020.0002.5584] # CJK COMPATIBILITY IDEOGRAPH-2F845
2F846     ; [.315F.0024.0002.5584][.31D8.0020.0002.5584][.3235.0020.0002.5584] # CJK COMPATIBILITY IDEOGRAPH-2F846
F90B      ; [.315B.0021.0002.5587][.31D4.0020.0002.5587] # CJK COMPATIBILITY IDEOGRAPH-F90B
FA7A      ; [.3168.0022.0002.5599][.31E3.0020.0002.5599] # CJK COMPATIBILITY IDEOGRAPH-FA7A
2F847     ; [.3168.0022.0002.5599][.31E3.0020.0002.5599] # CJK COMPATIBILITY IDEOGRAPH-2F847
FA36      ; [.3156.0022.0002.559D][.31D4.0020.0002.559D][.3239.0020.0002.559D] # CJK COMPATIBILITY IDEOGRAPH-FA36
FA78      ; [.3156.0022.0002.559D][.31D4.0020.0002.559D][.3239.0020.0002.559D] # CJK COMPATIBILITY IDEOGRAPH-FA78
2F848     ; [.3157.0021.0002.55AB][.31E8.0020.0002.55AB][.3232.0020.0002.55AB] # CJK COMPATIBILITY IDEOGRAPH-2F848
FA7B      ; [.3161.0022.0002.55E2][.31DC.0020.0002.55E2][.3239.0020.0002.55E2] # CJK COMPATIBILITY IDEOGRAPH-FA7B
FA37      ; [.3166.0022.0002.5606][.31D4.0020.0002.5606][.3235.0020.0002.5606] # CJK COMPATIBILITY IDEOGRAPH-FA37
2F84C     ; [.3166.0022.0002.5606][.31D4.0020.0002.5606][.3235.0020.0002.5606] # CJK COMPATIBILITY IDEOGRAPH-2F84C
FA38      ; [.3156.0026.0002.5668][.31E8.0020.0002.5668] # CJK COMPATIBILITY IDEOGRAPH-FA38
2F84F     ; [.315D.0023.0002.5674][.31E1.0020.0002.5674][.3235.0020.0002.5674] # CJK COMPATIBILITY IDEOGRAPH-2F84F
F9A9      ; [.315B.0023.0002.56F9][.31DA.0020.0002.56F9][.3246.0020.0002.56F9] # CJK COMPATIBILITY IDEOGRAPH-F9A9
2F84B     ; [.3159.0024.0002.5716][.31DC.0020.0002.5716] # CJK COMPATIBILITY IDEOGRAPH-2F84B
2F855     ; [.3168.0024.0002.578B][.31DA.0020.0002.578B][.3246.0020.0002.578B] # CJK COMPATIBILITY IDEOGRAPH-2F855
2F852     ; [.315F.0021.0002.57CE][.31D8.0020.0002.57CE][.3246.0020.0002.57CE] # CJK COMPATIBILITY IDEOGRAPH-2F852
2F853     ; [.315F.0021.0002.57F4][.31E8.0020.0002.57F4][.3232.0020.0002.57F4] # CJK COMPATIBILITY IDEOGRAPH-2F853
2F857     ; [.315D.0023.0002.5831][.31DC.0020.0002.5831] # CJK COMPATIBILITY IDEOGRAPH-2F857
FA39      ; [.315D.0033.0002.5840][.31DA.0020.0002.5840][.3246.0020.0002.5840] # CJK COMPATIBILITY IDEOGRAPH-FA39
FA10      ; [.3164.0022.0002.585A][.31DC.0020.0002.585A][.3246.0020.0002.585A] # CJK COMPATIBILITY IDEOGRAPH-FA10
FA7C      ; [.3164.0022.0002.585A][.31DC.0020.0002.585A][.3246.0020.0002.585A] # CJK COMPATIBILITY IDEOGRAPH-FA7C
F96C      ; [.315F.0021.0002.585E][.31D5.0020.0002.585E] # CJK COMPATIBILITY IDEOGRAPH-F96C
FA3A      ; [.315C.0021.0002.58A8][.31E1.0020.0002.58A8][.3232.0020.0002.58A8] # CJK COMPATIBILITY IDEOGRAPH-FA3A
FA7D      ; [.315D.0024.0002.58B3][.31E1.0020.0002.58B3][.3235.0020.0002.58B3] # CJK COMPATIBILITY IDEOGRAPH-FA7D
F94A      ; [.315B.0021.0002.58D8][.31E1.0020.0002.58D8] # CJK COMPATIBILITY IDEOGRAPH-F94A
F942      ; [.315B.0021.0002.58DF][.31DC.0020.0002.58DF][.3246.0020.0002.58DF] # CJK COMPATIBILITY IDEOGRAPH-F942
2F85C     ; [.315D.0032.0002.5906][.31DC.0020.0002.5906][.3246.0020.0002.5906] # CJK COMPATIBILITY IDEOGRAPH-2F85C
2F85D     ; [.3159.0021.0002.591A][.31D4.0020.0002.591A] # CJK COMPATIBILITY IDEOGRAPH-2F85D
2F85E     ; [.315C.0021.0002.5922][.31DC.0020.0002.5922][.3246.0020.0002.5922] # CJK COMPATIBILITY IDEOGRAPH-2F85E
FA7E      ; [.3161.0024.0002.5944][.31D8.0020.0002.5944][.3241.0020.0002.5944] # CJK COMPATIBILITY IDEOGRAPH-FA7E
F90C      ; [.3158.0023.0002.5948][.31D5.0020.0002.5948] # CJK COMPATIBILITY IDEOGRAPH-F90C
F909      ; [.3156.0024.0002.5951][.31DB.0020.0002.5951] # CJK COMPATIBILITY IDEOGRAPH-F909
FA7F      ; [.315D.0025.0002.5954][.31E1.0020.0002.5954][.3235.0020.0002.5954] # CJK COMPATIBILITY IDEOGRAPH-FA7F
2F85F     ; [.315F.0030.0002.5962][.31D4.0020.0002.5962] # CJK COMPATIBILITY IDEOGRAPH-2F85F
F981      ; [.3158.0021.0002.5973][.31DA.0020.0002.5973] # CJK COMPATIBILITY IDEOGRAPH-F981
2F862     ; [.3168.0026.0002.59EC][.31E7.0020.0002.59EC] # CJK COMPATIBILITY IDEOGRAPH-2F862
2F863     ; [.3161.002C.0002.5A1B][.31DC.0020.0002.5A1B] # CJK COMPATIBILITY IDEOGRAPH-2F863
2F864     ; [.3166.0030.0002.5A27][.31D5.0020.0002.5A27] # CJK COMPATIBILITY IDEOGRAPH-2F864
FA80      ; [.315D.0027.0002.5A62][.31E8.0020.0002.5A62] # CJK COMPATIBILITY IDEOGRAPH-FA80
2F866     ; [.315D.002B.0002.5A66][.31E1.0020.0002.5A66] # CJK COMPATIBILITY IDEOGRAPH-2F866
2F986     ; [.3161.0025.0002.5AB5][.31E8.0020.0002.5AB5][.3246.0020.0002.5AB5] # CJK COMPATIBILITY IDEOGRAPH-2F986
2F869     ; [.3161.0041.0002.5B08][.31E0.0020.0002.5B08] # CJK COMPATIBILITY IDEOGRAPH-2F869
FA81      ; [.3162.003C.0002.5B28][.31D4.0020.0002.5B28] # CJK COMPATIBILITY IDEOGRAPH-FA81
2F86A     ; [.315B.0029.0002.5B3E][.31D4.0020.0002.5B3E][.3235.0020.0002.5B3E] # CJK COMPATIBILITY IDEOGRAPH-2F86A
2F86B     ; [.315B.0029.0002.5B3E][.31D4.0020.0002.5B3E][.3235.0020.0002.5B3E] # CJK COMPATIBILITY IDEOGRAPH-2F86B
FA04      ; [.3159.0021.0002.5B85][.31D5.0020.0002.5B85][.3232.0020.0002.5B85] # CJK COMPATIBILITY IDEOGRAPH-FA04
2F86D     ; [.3161.0029.0002.5BC3][.31E2.0020.0002.5BC3][.3235.0020.0002.5BC3] # CJK COMPATIBILITY IDEOGRAPH-2F86D
2F86E     ; [.3164.003B.0002.5BD8][.31E8.0020.0002.5BD8] # CJK COMPATIBILITY IDEOGRAPH-2F86E
F95F      ; [.3158.0021.0002.5BE7][.31DA.0020.0002.5BE7][.3246.0020.0002.5BE7] # CJK COMPATIBILITY IDEOGRAPH-F95F
F9AA      ; [.3158.0021.0002.5BE7][.31DA.0020.0002.5BE7][.3246.0020.0002.5BE7] # CJK COMPATIBILITY IDEOGRAPH-F9AA
2F86F     ; [.3158.0021.0002.5BE7][.31DA.0020.0002.5BE7][.3246.0020.0002.5BE7] # CJK COMPATIBILITY IDEOGRAPH-2F86F
F9BC      ; [.315B.0023.0002.5BEE][.31E0.0020.0002.5BEE] # CJK COMPATIBILITY IDEOGRAPH-F9BC
F9BD      ; [.3158.0021.0002.5C3F][.31E0.0020.0002.5C3F] # CJK COMPATIBILITY IDEOGRAPH-F9BD
2F877     ; [.3159.0028.0002.5C60][.31DC.0020.0002.5C60] # CJK COMPATIBILITY IDEOGRAPH-2F877
F94B      ; [.315B.0023.0002.5C62][.31E1.0020.0002.5C62] # CJK COMPATIBILITY IDEOGRAPH-F94B
FA3B      ; [.3164.0021.0002.5C64][.31E6.0020.0002.5C64][.3246.0020.0002.5C64] # CJK COMPATIBILITY IDEOGRAPH-FA3B
F9DF      ; [.315B.0026.0002.5C65][.31E8.0020.0002.5C65] # CJK COMPATIBILITY IDEOGRAPH-F9DF
2F879     ; [.315F.002A.0002.5CC0][.31E1.0020.0002.5CC0] # CJK COMPATIBILITY IDEOGRAPH-2F879
F9D5      ; [.315B.0023.0002.5D19][.31E5.0020.0002.5D19][.3235.0020.0002.5D19] # CJK COMPATIBILITY IDEOGRAPH-F9D5
F921      ; [.315B.0021.0002.5D50][.31D4.0020.0002.5D50][.3241.0020.0002.5D50] # CJK COMPATIBILITY IDEOGRAPH-F921
F9AB      ; [.315B.0025.0002.5DBA][.31DA.0020.0002.5DBA][.3246.0020.0002.5DBA] # CJK COMPATIBILITY IDEOGRAPH-F9AB
2F881     ; [.315F.0021.0002.5DE1][.31E1.0020.0002.5DE1][.3235.0020.0002.5DE1] # CJK COMPATIBILITY IDEOGRAPH-2F881
2F882     ; [.315F.0027.0002.5DE2][.31DC.0020.0002.5DE2] # CJK COMPATIBILITY IDEOGRAPH-2F882
2F884     ; [.315F.0022.0002.5DFD][.31DC.0020.0002.5DFD][.3235.0020.0002.5DFD] # CJK COMPATIBILITY IDEOGRAPH-2F884
2F885     ; [.315F.0029.0002.5E28][.31D9.0020.0002.5E28] # CJK COMPATIBILITY IDEOGRAPH-2F885
2F886     ; [.315C.0025.0002.5E3D][.31DC.0020.0002.5E3D] # CJK COMPATIBILITY IDEOGRAPH-2F886
F98E      ; [.3158.0021.0002.5E74][.31DA.0020.0002.5E74][.3235.0020.0002.5E74] # CJK COMPATIBILITY IDEOGRAPH-F98E
FA01      ; [.3159.002B.0002.5EA6][.31DC.0020.0002.5EA6] # CJK COMPATIBILITY IDEOGRAPH-FA01
2F88C     ; [.315D.0052.0002.5EB3][.31E8.0020.0002.5EB3] # CJK COMPATIBILITY IDEOGRAPH-2F88C
2F88D     ; [.315F.0025.0002.5EB6][.31D8.0020.0002.5EB6] # CJK COMPATIBILITY IDEOGRAPH-2F88D
F9A2      ; [.315B.0021.0002.5EC9][.31DA.0020.0002.5EC9][.3241.0020.0002.5EC9] # CJK COMPATIBILITY IDEOGRAPH-F9A2
F928      ; [.315B.0021.0002.5ECA][.31D4.0020.0002.5ECA][.3246.0020.0002.5ECA] # CJK COMPATIBILITY IDEOGRAPH-F928
2F88E     ; [.315B.0021.0002.5ECA][.31D4.0020.0002.5ECA][.3246.0020.0002.5ECA] # CJK COMPATIBILITY IDEOGRAPH-2F88E
FA0B      ; [.3156.0021.0002.5ED3][.31DD.0020.0002.5ED3][.3232.0020.0002.5ED3] # CJK COMPATIBILITY IDEOGRAPH-FA0B
F982      ; [.315B.0025.0002.5EEC][.31DA.0020.0002.5EEC] # CJK COMPATIBILITY IDEOGRAPH-F982
F943      ; [.315B.0022.0002.5F04][.31DC.0020.0002.5F04][.3246.0020.0002.5F04] # CJK COMPATIBILITY IDEOGRAPH-F943
2F894     ; [.3159.004B.0002.5F22][.31DC.0020.0002.5F22] # CJK COMPATIBILITY IDEOGRAPH-2F894
2F895     ; [.3159.004B.0002.5F22][.31DC.0020.0002.5F22] # CJK COMPATIBILITY IDEOGRAPH-2F895
2F899     ; [.3168.0025.0002.5F62][.31DA.0020.0002.5F62][.3246.0020.0002.5F62] # CJK COMPATIBILITY IDEOGRAPH-2F899
FA84      ; [.3164.0025.0002.5F69][.31D5.0020.0002.5F69] # CJK COMPATIBILITY IDEOGRAPH-FA84
2F89A     ; [.3162.0027.0002.5F6B][.31DC.0020.0002.5F6B] # CJK COMPATIBILITY IDEOGRAPH-2F89A
F9D8      ; [.315B.0021.0002.5F8B][.31E5.0020.0002.5F8B][.3239.0020.0002.5F8B] # CJK COMPATIBILITY IDEOGRAPH-F9D8
F966      ; [.315D.0026.0002.5FA9][.31DC.0020.0002.5FA9][.3232.0020.0002.5FA9] # CJK COMPATIBILITY IDEOGRAPH-F966
FA85      ; [.3161.0043.0002.5FAD][.31E0.0020.0002.5FAD] # CJK COMPATIBILITY IDEOGRAPH-FA85
2F89D     ; [.3161.002A.0002.5FCD][.31E8.0020.0002.5FCD][.3235.0020.0002.5FCD] # CJK COMPATIBILITY IDEOGRAPH-2F89D
2F89E     ; [.3162.0026.0002.5FD7][.31E8.0020.0002.5FD7] # CJK COMPATIBILITY IDEOGRAPH-2F89E
F9A3      ; [.3158.0021.0002.5FF5][.31DA.0020.0002.5FF5][.3241.0020.0002.5FF5] # CJK COMPATIBILITY IDEOGRAPH-F9A3
F960      ; [.3158.0024.0002.6012][.31DC.0020.0002.6012] # CJK COMPATIBILITY IDEOGRAPH-F960
F9AC      ; [.315B.0026.0002.601C][.31DA.0020.0002.601C][.3246.0020.0002.601C] # CJK COMPATIBILITY IDEOGRAPH-F9AC
2F8A0     ; [.3161.0042.0002.6081][.31DA.0020.0002.6081][.3235.0020.0002.6081] # CJK COMPATIBILITY IDEOGRAPH-2F8A0
FA3D      ; [.3168.0026.0002.6094][.31DF.0020.0002.6094] # CJK COMPATIBILITY IDEOGRAPH-FA3D
2F8A3     ; [.3168.0026.0002.6094][.31DF.0020.0002.6094] # CJK COMPATIBILITY IDEOGRAPH-2F8A3
2F8A5     ; [.3159.0022.0002.60C7][.31DC.0020.0002.60C7][.3235.0020.0002.60C7] # CJK COMPATIBILITY IDEOGRAPH-2F8A5
FA86      ; [.315C.002D.0002.60D8][.31D4.0020.0002.60D8][.3246.0020.0002.60D8] # CJK COMPATIBILITY IDEOGRAPH-FA86
F9B9      ; [.3161.0025.0002.60E1][.31D4.0020.0002.60E1][.3232.0020.0002.60E1] # CJK COMPATIBILITY IDEOGRAPH-F9B9
FA88      ; [.3161.002E.0002.6108][.31E5.0020.0002.6108] # CJK COMPATIBILITY IDEOGRAPH-FA88
F9D9      ; [.315B.0022.0002.6144][.31E5.0020.0002.6144][.3239.0020.0002.6144] # CJK COMPATIBILITY IDEOGRAPH-F9D9
2F8A6     ; [.3162.002A.0002.6148][.31D4.0020.0002.6148] # CJK COMPATIBILITY IDEOGRAPH-2F8A6
2F8A7     ; [.3168.0027.0002.614C][.31DD.0020.0002.614C][.3246.0020.0002.614C] # CJK COMPATIBILITY IDEOGRAPH-2F8A7
2F8A9     ; [.3168.0027.0002.614C][.31DD.0020.0002.614C][.3246.0020.0002.614C] # CJK COMPATIBILITY IDEOGRAPH-2F8A9
FA8A      ; [.3161.0047.0002.6160][.31DC.0020.0002.6160] # CJK COMPATIBILITY IDEOGRAPH-FA8A
FA3E      ; [.3156.0028.0002.6168][.31D5.0020.0002.6168] # CJK COMPATIBILITY IDEOGRAPH-FA3E
2F8AA     ; [.315B.0031.0002.617A][.31E1.0020.0002.617A] # CJK COMPATIBILITY IDEOGRAPH-2F8AA
FA3F      ; [.3162.0022.0002.618E][.31E6.0020.0002.618E][.3246.0020.0002.618E] # CJK COMPATIBILITY IDEOGRAPH-FA3F
FA89      ; [.3162.0022.0002.618E][.31E6.0020.0002.618E][.3246.0020.0002.618E] # CJK COMPATIBILITY IDEOGRAPH-FA89
2F8AB     ; [.3162.0022.0002.618E][.31E6.0020.0002.618E][.3246.0020.0002.618E] # CJK COMPATIBILITY IDEOGRAPH-2F8AB
F98F      ; [.315B.0021.0002.6190][.31DA.0020.0002.6190][.3235.0020.0002.6190] # CJK COMPATIBILITY IDEOGRAPH-F98F
2F8AD     ; [.315D.0028.0002.61A4][.31E1.0020.0002.61A4][.3235.0020.0002.61A4] # CJK COMPATIBILITY IDEOGRAPH-2F8AD
2F8AE     ; [.3164.0030.0002.61AF][.31D4.0020.0002.61AF][.3241.0020.0002.61AF] # CJK COMPATIBILITY IDEOGRAPH-2F8AE
2F8AC     ; [.3168.0021.0002.61B2][.31D8.0020.0002.61B2][.3235.0020.0002.61B2] # CJK COMPATIBILITY IDEOGRAPH-2F8AC
2F8AF     ; [.315C.0025.0002.61DE][.31DC.0020.0002.61DE][.3246.0020.0002.61DE] # CJK COMPATIBILITY IDEOGRAPH-2F8AF
FA40      ; [.3162.0022.0002.61F2][.31E8.0020.0002.61F2][.3246.0020.0002.61F2] # CJK COMPATIBILITY IDEOGRAPH-FA40
FA8B      ; [.3162.0022.0002.61F2][.31E8.0020.0002.61F2][.3246.0020.0002.61F2] # CJK COMPATIBILITY IDEOGRAPH-FA8B
2F8B0     ; [.3162.0022.0002.61F2][.31E8.0020.0002.61F2][.3246.0020.0002.61F2] # CJK COMPATIBILITY IDEOGRAPH-2F8B0
F90D      ; [.315B.0022.0002.61F6][.31D4.0020.0002.61F6] # CJK COMPATIBILITY IDEOGRAPH-F90D
2F8B1     ; [.315B.0022.0002.61F6][.31D4.0020.0002.61F6] # CJK COMPATIBILITY IDEOGRAPH-2F8B1
F990      ; [.315B.0022.0002.6200][.31DA.0020.0002.6200][.3235.0020.0002.6200] # CJK COMPATIBILITY IDEOGRAPH-F990
2F8B2     ; [.315F.0026.0002.6210][.31D8.0020.0002.6210][.3246.0020.0002.6210] # CJK COMPATIBILITY IDEOGRAPH-2F8B2
F9D2      ; [.315B.0022.0002.622E][.31E5.0020.0002.622E][.3232.0020.0002.622E] # CJK COMPATIBILITY IDEOGRAPH-F9D2
FA8C      ; [.3159.0029.0002.6234][.31D5.0020.0002.6234] # CJK COMPATIBILITY IDEOGRAPH-FA8C
2F8B5     ; [.3167.002B.0002.62B1][.31DC.0020.0002.62B1] # CJK COMPATIBILITY IDEOGRAPH-2F8B5
F925      ; [.315B.0021.0002.62C9][.31D4.0020.0002.62C9][.3242.0020.0002.62C9] # CJK COMPATIBILITY IDEOGRAPH-F925
F95B      ; [.3158.0024.0002.62CF][.31D4.0020.0002.62CF] # CJK COMPATIBILITY IDEOGRAPH-F95B
FA02      ; [.3164.0026.0002.62D3][.31D8.0020.0002.62D3][.3232.0020.0002.62D3] # CJK COMPATIBILITY IDEOGRAPH-FA02
2F8B6     ; [.315D.0022.0002.62D4][.31D4.0020.0002.62D4][.3239.0020.0002.62D4] # CJK COMPATIBILITY IDEOGRAPH-2F8B6
F973      ; [.315F.0022.0002.62FE][.31E6.0020.0002.62FE][.3242.0020.0002.62FE] # CJK COMPATIBILITY IDEOGRAPH-F973
2F8B9     ; [.315C.0027.0002.633D][.31D4.0020.0002.633D][.3235.0020.0002.633D] # CJK COMPATIBILITY IDEOGRAPH-2F8B9
2F8B7     ; [.3161.0027.0002.6350][.31DA.0020.0002.6350][.3235.0020.0002.6350] # CJK COMPATIBILITY IDEOGRAPH-2F8B7
2F8BB     ; [.315F.0039.0002.6368][.31D4.0020.0002.6368] # CJK COMPATIBILITY IDEOGRAPH-2F8BB
F9A4      ; [.3158.0024.0002.637B][.31DA.0020.0002.637B][.3241.0020.0002.637B] # CJK COMPATIBILITY IDEOGRAPH-F9A4
2F8BC     ; [.315F.0029.0002.6383][.31DC.0020.0002.6383] # CJK COMPATIBILITY IDEOGRAPH-2F8BC
F975      ; [.315B.0021.0002.63A0][.31D6.0020.0002.63A0][.3232.0020.0002.63A0] # CJK COMPATIBILITY IDEOGRAPH-F975
2F8C1     ; [.3161.0025.0002.63A9][.31D8.0020.0002.63A9][.3241.0020.0002.63A9] # CJK COMPATIBILITY IDEOGRAPH-2F8C1
FA8D      ; [.3161.0030.0002.63C4][.31E5.0020.0002.63C4] # CJK COMPATIBILITY IDEOGRAPH-FA8D
FA8E      ; [.315F.0030.0002.641C][.31E1.0020.0002.641C] # CJK COMPATIBILITY IDEOGRAPH-FA8E
2F8BF     ; [.3162.0025.0002.6422][.31E8.0020.0002.6422][.3235.0020.0002.6422] # CJK COMPATIBILITY IDEOGRAPH-2F8BF
2F8C3     ; [.315C.0021.0002.6469][.31D4.0020.0002.6469] # CJK COMPATIBILITY IDEOGRAPH-2F8C3
F991      ; [.3158.0022.0002.649A][.31DA.0020.0002.649A][.3235.0020.0002.649A] # CJK COMPATIBILITY IDEOGRAPH-F991
2F8C5     ; [.3168.0029.0002.649D][.31E4.0020.0002.649D] # CJK COMPATIBILITY IDEOGRAPH-2F8C5
F930      ; [.315B.0023.0002.64C4][.31DC.0020.0002.64C4] # CJK COMPATIBILITY IDEOGRAPH-F930
FA41      ; [.315C.0025.0002.654F][.31E8.0020.0002.654F][.3235.0020.0002.654F] # CJK COMPATIBILITY IDEOGRAPH-FA41
2F8C8     ; [.315C.0025.0002.654F][.31E8.0020.0002.654F][.3235.0020.0002.654F] # CJK COMPATIBILITY IDEOGRAPH-2F8C8
FA90      ; [.3161.0030.0002.6556][.31DC.0020.0002.6556] # CJK COMPATIBILITY IDEOGRAPH-FA90
2F8C9     ; [.3156.0030.0002.656C][.31DA.0020.0002.656C][.3246.0020.0002.656C] # CJK COMPATIBILITY IDEOGRAPH-2F8C9
F969      ; [.315F.0032.0002.6578][.31E1.0020.0002.6578] # CJK COMPATIBILITY IDEOGRAPH-F969
F9BE      ; [.315B.0025.0002.6599][.31E0.0020.0002.6599] # CJK COMPATIBILITY IDEOGRAPH-F9BE
F983      ; [.315B.0028.0002.65C5][.31DA.0020.0002.65C5] # CJK COMPATIBILITY IDEOGRAPH-F983
2F8CB     ; [.3156.0035.0002.65E3][.31E8.0020.0002.65E3] # CJK COMPATIBILITY IDEOGRAPH-2F8CB
F9E0      ; [.3161.0024.0002.6613][.31DA.0020.0002.6613][.3232.0020.0002.6613] # CJK COMPATIBILITY IDEOGRAPH-F9E0
2F8CD     ; [.3162.0026.0002.6649][.31E8.0020.0002.6649][.3235.0020.0002.6649] # CJK COMPATIBILITY IDEOGRAPH-2F8CD
FA12      ; [.3164.0022.0002.6674][.31D8.0020.0002.6674][.3246.0020.0002.6674] # CJK COMPATIBILITY IDEOGRAPH-FA12
FA91      ; [.3164.0022.0002.6674][.31D8.0020.0002.6674][.3246.0020.0002.6674] # CJK COMPATIBILITY IDEOGRAPH-FA91
F9C5      ; [.3168.002A.0002.6688][.31E1.0020.0002.6688][.3235.0020.0002.6688] # CJK COMPATIBILITY IDEOGRAPH-F9C5
FA43      ; [.315F.002B.0002.6691][.31D8.0020.0002.6691] # CJK COMPATIBILITY IDEOGRAPH-FA43
2F8CF     ; [.315F.002B.0002.6691][.31D8.0020.0002.6691] # CJK COMPATIBILITY IDEOGRAPH-2F8CF
FA06      ; [.3167.0022.0002.66B4][.31DC.0020.0002.66B4][.3232.0020.0002.66B4] # CJK COMPATIBILITY IDEOGRAPH-FA06
F98B      ; [.315B.0022.0002.66C6][.31DA.0020.0002.66C6][.3232.0020.0002.66C6] # CJK COMPATIBILITY IDEOGRAPH-F98B
F901      ; [.3156.0033.0002.66F4][.31DA.0020.0002.66F4][.3246.0020.0002.66F4] # CJK COMPATIBILITY IDEOGRAPH-F901
2F8CC     ; [.315F.002D.0002.66F8][.31D8.0020.0002.66F8] # CJK COMPATIBILITY IDEOGRAPH-2F8CC
2F8D4     ; [.3164.0023.0002.6700][.31DF.0020.0002.6700] # CJK COMPATIBILITY IDEOGRAPH-2F8D4
F929      ; [.315B.0022.0002.6717][.31D4.0020.0002.6717][.3246.0020.0002.6717] # CJK COMPATIBILITY IDEOGRAPH-F929
FA92      ; [.315B.0022.0002.6717][.31D4.0020.0002.6717][.3246.0020.0002.6717] # CJK COMPATIBILITY IDEOGRAPH-FA92
2F8D8     ; [.315B.0022.0002.6717][.31D4.0020.0002.6717][.3246.0020.0002.6717] # CJK COMPATIBILITY IDEOGRAPH-2F8D8
FA93      ; [.315C.0025.0002.671B][.31D4.0020.0002.671B][.3246.0020.0002.671B] # CJK COMPATIBILITY IDEOGRAPH-FA93
2F8D9     ; [.315C.0025.0002.671B][.31D4.0020.0002.671B][.3246.0020.0002.671B] # CJK COMPATIBILITY IDEOGRAPH-2F8D9
F9E1      ; [.315B.0028.0002.674E][.31E8.0020.0002.674E] # CJK COMPATIBILITY IDEOGRAPH-F9E1
2F8DC     ; [.3167.0025.0002.6753][.31E0.0020.0002.6753] # CJK COMPATIBILITY IDEOGRAPH-2F8DC
FA94      ; [.3162.002E.0002.6756][.31D4.0020.0002.6756][.3246.0020.0002.6756] # CJK COMPATIBILITY IDEOGRAPH-FA94
2F8DB     ; [.3156.0038.0002.675E][.31E8.0020.0002.675E] # CJK COMPATIBILITY IDEOGRAPH-2F8DB
F9C8      ; [.3158.0021.0002.677B][.31E5.0020.0002.677B] # CJK COMPATIBILITY IDEOGRAPH-F9C8
F9F4      ; [.315B.0021.0002.6797][.31E8.0020.0002.6797][.3241.0020.0002.6797] # CJK COMPATIBILITY IDEOGRAPH-F9F4
F9C9      ; [.315B.0023.0002.67F3][.31E5.0020.0002.67F3] # CJK COMPATIBILITY IDEOGRAPH-F9C9
F9DA      ; [.315B.0023.0002.6817][.31E5.0020.0002.6817][.3239.0020.0002.6817] # CJK COMPATIBILITY IDEOGRAPH-F9DA
F97A      ; [.315B.0025.0002.6881][.31D6.0020.0002.6881][.3246.0020.0002.6881] # CJK COMPATIBILITY IDEOGRAPH-F97A
FA44      ; [.315C.0027.0002.6885][.31D5.0020.0002.6885] # CJK COMPATIBILITY IDEOGRAPH-FA44
2F8E2     ; [.315C.0027.0002.6885][.31D5.0020.0002.6885] # CJK COMPATIBILITY IDEOGRAPH-2F8E2
F9E2      ; [.315B.0029.0002.68A8][.31E8.0020.0002.68A8] # CJK COMPATIBILITY IDEOGRAPH-F9E2
2F8E8     ; [.315F.0062.0002.6942][.31D4.0020.0002.6942] # CJK COMPATIBILITY IDEOGRAPH-2F8E8
2F8EA     ; [.3156.002A.0002.69EA][.31D5.0020.0002.69EA] # CJK COMPATIBILITY IDEOGRAPH-2F8EA
F914      ; [.3161.0028.0002.6A02][.31D4.0020.0002.6A02][.3232.0020.0002.6A02] # CJK COMPATIBILITY IDEOGRAPH-F914
F95C      ; [.3161.0028.0002.6A02][.31D4.0020.0002.6A02][.3232.0020.0002.6A02] # CJK COMPATIBILITY IDEOGRAPH-F95C
F9BF      ; [.3161.0028.0002.6A02][.31D4.0020.0002.6A02][.3232.0020.0002.6A02] # CJK COMPATIBILITY IDEOGRAPH-F9BF
F94C      ; [.315B.0024.0002.6A13][.31E1.0020.0002.6A13] # CJK COMPATIBILITY IDEOGRAPH-F94C
F931      ; [.315B.0024.0002.6AD3][.31DC.0020.0002.6AD3] # CJK COMPATIBILITY IDEOGRAPH-F931
2F8ED     ; [.3162.0021.0002.6ADB][.31E6.0020.0002.6ADB][.3239.0020.0002.6ADB] # CJK COMPATIBILITY IDEOGRAPH-2F8ED
F91D      ; [.315B.0023.0002.6B04][.31D4.0020.0002.6B04][.3235.0020.0002.6B04] # CJK COMPATIBILITY IDEOGRAPH-F91D
2F8EF     ; [.3164.0028.0002.6B21][.31D4.0020.0002.6B21] # CJK COMPATIBILITY IDEOGRAPH-2F8EF
2F8F1     ; [.3168.0025.0002.6B54][.31D8.0020.0002.6B54] # CJK COMPATIBILITY IDEOGRAPH-2F8F1
2F8F3     ; [.315F.0023.0002.6B72][.31D9.0020.0002.6B72] # CJK COMPATIBILITY IDEOGRAPH-2F8F3
F98C      ; [.315B.0023.0002.6B77][.31DA.0020.0002.6B77][.3232.0020.0002.6B77] # CJK COMPATIBILITY IDEOGRAPH-F98C
F9A5      ; [.315B.0023.0002.6BAE][.31DA.0020.0002.6BAE][.3241.0020.0002.6BAE] # CJK COMPATIBILITY IDEOGRAPH-F9A5
F970      ; [.315F.0023.0002.6BBA][.31D4.0020.0002.6BBA][.3239.0020.0002.6BBA] # CJK COMPATIBILITY IDEOGRAPH-F970
FA96      ; [.315F.0023.0002.6BBA][.31D4.0020.0002.6BBA][.3239.0020.0002.6BBA] # CJK COMPATIBILITY IDEOGRAPH-FA96
2F8F5     ; [.315F.0023.0002.6BBA][.31D4.0020.0002.6BBA][.3239.0020.0002.6BBA] # CJK COMPATIBILITY IDEOGRAPH-2F8F5
2F8FA     ; [.315D.0025.0002.6C4E][.31D8.0020.0002.6C4E][.3241.0020.0002.6C4E] # CJK COMPATIBILITY IDEOGRAPH-2F8FA
F972      ; [.3164.0024.0002.6C88][.31E8.0020.0002.6C88][.3241.0020.0002.6C88] # CJK COMPATIBILITY IDEOGRAPH-F972
2F8FC     ; [.3161.002B.0002.6CBF][.31DA.0020.0002.6CBF][.3235.0020.0002.6CBF] # CJK COMPATIBILITY IDEOGRAPH-2F8FC
F968      ; [.3167.0024.0002.6CCC][.31E8.0020.0002.6CCC][.3239.0020.0002.6CCC] # CJK COMPATIBILITY IDEOGRAPH-F968
F9E3      ; [.3158.0022.0002.6CE5][.31E8.0020.0002.6CE5] # CJK COMPATIBILITY IDEOGRAPH-F9E3
F915      ; [.315B.0021.0002.6D1B][.31D4.0020.0002.6D1B][.3232.0020.0002.6D1B] # CJK COMPATIBILITY IDEOGRAPH-F915
FA05      ; [.3159.002A.0002.6D1E][.31DC.0020.0002.6D1E][.3246.0020.0002.6D1E] # CJK COMPATIBILITY IDEOGRAPH-FA05
2F900     ; [.3167.0029.0002.6D3E][.31D4.0020.0002.6D3E] # CJK COMPATIBILITY IDEOGRAPH-2F900
F9CA      ; [.315B.0025.0002.6D41][.31E5.0020.0002.6D41] # CJK COMPATIBILITY IDEOGRAPH-F9CA
FA97      ; [.315B.0025.0002.6D41][.31E5.0020.0002.6D41] # CJK COMPATIBILITY IDEOGRAPH-FA97
2F902     ; [.315B.0025.0002.6D41][.31E5.0020.0002.6D41] # CJK COMPATIBILITY IDEOGRAPH-2F902
2F903     ; [.3168.002E.0002.6D69][.31DC.0020.0002.6D69] # CJK COMPATIBILITY IDEOGRAPH-2F903
F92A      ; [.315B.0023.0002.6D6A][.31D4.0020.0002.6D6A][.3246.0020.0002.6D6A] # CJK COMPATIBILITY IDEOGRAPH-F92A
FA45      ; [.3168.002A.0002.6D77][.31D5.0020.0002.6D77] # CJK COMPATIBILITY IDEOGRAPH-FA45
2F901     ; [.3168.002A.0002.6D77][.31D5.0020.0002.6D77] # CJK COMPATIBILITY IDEOGRAPH-2F901
2F904     ; [.3164.0025.0002.6D78][.31E8.0020.0002.6D78][.3241.0020.0002.6D78] # CJK COMPATIBILITY IDEOGRAPH-2F904
2F905     ; [.3161.0022.0002.6D85][.31DA.0020.0002.6D85][.3239.0020.0002.6D85] # CJK COMPATIBILITY IDEOGRAPH-2F905
F9F5      ; [.315B.0022.0002.6DCB][.31E8.0020.0002.6DCB][.3241.0020.0002.6DCB] # CJK COMPATIBILITY IDEOGRAPH-F9F5
F94D      ; [.315B.0025.0002.6DDA][.31E1.0020.0002.6DDA] # CJK COMPATIBILITY IDEOGRAPH-F94D
F9D6      ; [.315B.0024.0002.6DEA][.31E5.0020.0002.6DEA][.3235.0020.0002.6DEA] # CJK COMPATIBILITY IDEOGRAPH-F9D6
2F90E     ; [.3161.0026.0002.6DF9][.31D8.0020.0002.6DF9][.3241.0020.0002.6DF9] # CJK COMPATIBILITY IDEOGRAPH-2F90E
FA46      ; [.3162.002C.0002.6E1A][.31D8.0020.0002.6E1A] # CJK COMPATIBILITY IDEOGRAPH-FA46
2F908     ; [.3168.002B.0002.6E2F][.31D4.0020.0002.6E2F][.3246.0020.0002.6E2F] # CJK COMPATIBILITY IDEOGRAPH-2F908
2F909     ; [.3161.002B.0002.6E6E][.31E8.0020.0002.6E6E][.3235.0020.0002.6E6E] # CJK COMPATIBILITY IDEOGRAPH-2F909
F9CB      ; [.315B.0026.0002.6E9C][.31E5.0020.0002.6E9C] # CJK COMPATIBILITY IDEOGRAPH-F9CB
F9EC      ; [.3158.0022.0002.6EBA][.31E8.0020.0002.6EBA][.3232.0020.0002.6EBA] # CJK COMPATIBILITY IDEOGRAPH-F9EC
FA99      ; [.3162.002B.0002.6ECB][.31D4.0020.0002.6ECB] # CJK COMPATIBILITY IDEOGRAPH-FA99
2F90B     ; [.3162.002B.0002.6ECB][.31D4.0020.0002.6ECB] # CJK COMPATIBILITY IDEOGRAPH-2F90B
F904      ; [.3168.0022.0002.6ED1][.31DD.0020.0002.6ED1][.3239.0020.0002.6ED1] # CJK COMPATIBILITY IDEOGRAPH-F904
F94E      ; [.315B.0026.0002.6F0F][.31E1.0020.0002.6F0F] # CJK COMPATIBILITY IDEOGRAPH-F94E
FA47      ; [.3168.0026.0002.6F22][.31D4.0020.0002.6F22][.3235.0020.0002.6F22] # CJK COMPATIBILITY IDEOGRAPH-FA47
FA9A      ; [.3168.0026.0002.6F22][.31D4.0020.0002.6F22][.3235.0020.0002.6F22] # CJK COMPATIBILITY IDEOGRAPH-FA9A
F992      ; [.315B.0024.0002.6F23][.31DA.0020.0002.6F23][.3235.0020.0002.6F23] # CJK COMPATIBILITY IDEOGRAPH-F992
2F90F     ; [.3162.0033.0002.6F6E][.31DC.0020.0002.6F6E] # CJK COMPATIBILITY IDEOGRAPH-2F90F
2F912     ; [.315D.003C.0002.6FC6][.31E1.0020.0002.6FC6][.3235.0020.0002.6FC6] # CJK COMPATIBILITY IDEOGRAPH-2F912
F922      ; [.315B.0025.0002.6FEB][.31D4.0020.0002.6FEB][.3241.0020.0002.6FEB] # CJK COMPATIBILITY IDEOGRAPH-F922
F984      ; [.315B.002A.0002.6FFE][.31DA.0020.0002.6FFE] # CJK COMPATIBILITY IDEOGRAPH-F984
2F915     ; [.3161.002D.0002.701B][.31DA.0020.0002.701B][.3246.0020.0002.701B] # CJK COMPATIBILITY IDEOGRAPH-2F915
FA9B      ; [.3162.003D.0002.701E][.31D8.0020.0002.701E][.3246.0020.0002.701E] # CJK COMPATIBILITY IDEOGRAPH-FA9B
2F914     ; [.3162.003D.0002.701E][.31D8.0020.0002.701E][.3246.0020.0002.701E] # CJK COMPATIBILITY IDEOGRAPH-2F914
2F835     ; [.3168.002D.0002.7070][.31DF.0020.0002.7070] # CJK COMPATIBILITY IDEOGRAPH-2F835
2F918     ; [.3162.002B.0002.707D][.31D5.0020.0002.707D] # CJK COMPATIBILITY IDEOGRAPH-2F918
F9FB      ; [.3162.002C.0002.7099][.31D4.0020.0002.7099] # CJK COMPATIBILITY IDEOGRAPH-F9FB
2F91A     ; [.3166.0028.0002.70AD][.31D4.0020.0002.70AD][.3235.0020.0002.70AD] # CJK COMPATIBILITY IDEOGRAPH-2F91A
F99F      ; [.315B.0025.0002.70C8][.31DA.0020.0002.70C8][.3239.0020.0002.70C8] # CJK COMPATIBILITY IDEOGRAPH-F99F
F916      ; [.315B.0022.0002.70D9][.31D4.0020.0002.70D9][.3232.0020.0002.70D9] # CJK COMPATIBILITY IDEOGRAPH-F916
F993      ; [.315B.0025.0002.7149][.31DA.0020.0002.7149][.3235.0020.0002.7149] # CJK COMPATIBILITY IDEOGRAPH-F993
FA48      ; [.3162.002D.0002.716E][.31D4.0020.0002.716E] # CJK COMPATIBILITY IDEOGRAPH-FA48
FA9C      ; [.3162.002D.0002.716E][.31D4.0020.0002.716E] # CJK COMPATIBILITY IDEOGRAPH-FA9C
F9C0      ; [.315B.0026.0002.71CE][.31E0.0020.0002.71CE] # CJK COMPATIBILITY IDEOGRAPH-F9C0
F9EE      ; [.315B.0023.0002.71D0][.31E8.0020.0002.71D0][.3235.0020.0002.71D0] # CJK COMPATIBILITY IDEOGRAPH-F9EE
F932      ; [.315B.0027.0002.7210][.31DC.0020.0002.7210] # CJK COMPATIBILITY IDEOGRAPH-F932
F91E      ; [.315B.0026.0002.721B][.31D4.0020.0002.721B][.3235.0020.0002.721B] # CJK COMPATIBILITY IDEOGRAPH-F91E
2F920     ; [.3164.0036.0002.7228][.31D4.0020.0002.7228][.3235.0020.0002.7228] # CJK COMPATIBILITY IDEOGRAPH-2F920
FA9E      ; [.3162.0028.0002.7235][.31D4.0020.0002.7235][.3232.0020.0002.7235] # CJK COMPATIBILITY IDEOGRAPH-FA9E
2F921     ; [.3162.0028.0002.7235][.31D4.0020.0002.7235][.3232.0020.0002.7235] # CJK COMPATIBILITY IDEOGRAPH-2F921
F946      ; [.315B.0023.0002.7262][.31DF.0020.0002.7262] # CJK COMPATIBILITY IDEOGRAPH-F946
2F924     ; [.315F.0030.0002.7280][.31D8.0020.0002.7280] # CJK COMPATIBILITY IDEOGRAPH-2F924
FA9F      ; [.315D.0027.0002.72AF][.31D8.0020.0002.72AF][.3241.0020.0002.72AF] # CJK COMPATIBILITY IDEOGRAPH-FA9F
F9FA      ; [.315F.0035.0002.72C0][.31D4.0020.0002.72C0][.3246.0020.0002.72C0] # CJK COMPATIBILITY IDEOGRAPH-F9FA
F92B      ; [.315B.0024.0002.72FC][.31D4.0020.0002.72FC][.3246.0020.0002.72FC] # CJK COMPATIBILITY IDEOGRAPH-F92B
FA16      ; [.3162.002E.0002.732A][.31D8.0020.0002.732A] # CJK COMPATIBILITY IDEOGRAPH-FA16
FAA0      ; [.3162.002E.0002.732A][.31D8.0020.0002.732A] # CJK COMPATIBILITY IDEOGRAPH-FAA0
F9A7      ; [.315B.0021.0002.7375][.31DA.0020.0002.7375][.3242.0020.0002.7375] # CJK COMPATIBILITY IDEOGRAPH-F9A7
2F928     ; [.3159.0023.0002.737A][.31D4.0020.0002.737A][.3239.0020.0002.737A] # CJK COMPATIBILITY IDEOGRAPH-2F928
F961      ; [.315F.0021.0002.7387][.31DC.0020.0002.7387][.3239.0020.0002.7387] # CJK COMPATIBILITY IDEOGRAPH-F961
F9DB      ; [.315F.0021.0002.7387][.31DC.0020.0002.7387][.3239.0020.0002.7387] # CJK COMPATIBILITY IDEOGRAPH-F9DB
2F929     ; [.3161.0025.0002.738B][.31DD.0020.0002.738B][.3246.0020.0002.738B] # CJK COMPATIBILITY IDEOGRAPH-2F929
F9AD      ; [.315B.0027.0002.73B2][.31DA.0020.0002.73B2][.3246.0020.0002.73B2] # CJK COMPATIBILITY IDEOGRAPH-F9AD
F917      ; [.315B.0023.0002.73DE][.31D4.0020.0002.73DE][.3232.0020.0002.73DE] # CJK COMPATIBILITY IDEOGRAPH-F917
F9E4      ; [.315B.002D.0002.7406][.31E8.0020.0002.7406] # CJK COMPATIBILITY IDEOGRAPH-F9E4
F9CC      ; [.315B.0028.0002.7409][.31E5.0020.0002.7409] # CJK COMPATIBILITY IDEOGRAPH-F9CC
FA4A      ; [.3166.002B.0002.7422][.31D4.0020.0002.7422][.3232.0020.0002.7422] # CJK COMPATIBILITY IDEOGRAPH-FA4A
2F92F     ; [.3161.003D.0002.745C][.31E5.0020.0002.745C] # CJK COMPATIBILITY IDEOGRAPH-2F92F
F9AE      ; [.3168.002D.0002.7469][.31DA.0020.0002.7469][.3246.0020.0002.7469] # CJK COMPATIBILITY IDEOGRAPH-F9AE
FAA1      ; [.3162.0057.0002.7471][.31D8.0020.0002.7471][.3235.0020.0002.7471] # CJK COMPATIBILITY IDEOGRAPH-FAA1
2F930     ; [.3162.0057.0002.7471][.31D8.0020.0002.7471][.3235.0020.0002.7471] # CJK COMPATIBILITY IDEOGRAPH-2F930
F994      ; [.315B.0026.0002.7489][.31DA.0020.0002.7489][.3235.0020.0002.7489] # CJK COMPATIBILITY IDEOGRAPH-F994
F9EF      ; [.315B.0024.0002.7498][.31E8.0020.0002.7498][.3235.0020.0002.7498] # CJK COMPATIBILITY IDEOGRAPH-F9EF
2F932     ; [.3156.003A.0002.74CA][.31DA.0020.0002.74CA][.3246.0020.0002.74CA] # CJK COMPATIBILITY IDEOGRAPH-2F932
F9CD      ; [.315B.002A.0002.7559][.31E5.0020.0002.7559] # CJK COMPATIBILITY IDEOGRAPH-F9CD
F976      ; [.315B.0022.0002.7565][.31D6.0020.0002.7565][.3232.0020.0002.7565] # CJK COMPATIBILITY IDEOGRAPH-F976
F962      ; [.3161.002C.0002.7570][.31E8.0020.0002.7570] # CJK COMPATIBILITY IDEOGRAPH-F962
2F938     ; [.3161.002C.0002.7570][.31E8.0020.0002.7570] # CJK COMPATIBILITY IDEOGRAPH-2F938
F9E5      ; [.315B.002F.0002.75E2][.31E8.0020.0002.75E2] # CJK COMPATIBILITY IDEOGRAPH-F9E5
2F93A     ; [.3161.0059.0002.7610][.31E5.0020.0002.7610] # CJK COMPATIBILITY IDEOGRAPH-2F93A
FAA5      ; [.3161.0023.0002.761F][.31DC.0020.0002.761F][.3235.0020.0002.761F] # CJK COMPATIBILITY IDEOGRAPH-FAA5
F9C1      ; [.315B.0027.0002.7642][.31E0.0020.0002.7642] # CJK COMPATIBILITY IDEOGRAPH-F9C1
F90E      ; [.315B.0023.0002.7669][.31D4.0020.0002.7669] # CJK COMPATIBILITY IDEOGRAPH-F90E
FA17      ; [.3161.0022.0002.76CA][.31E8.0020.0002.76CA][.3232.0020.0002.76CA] # CJK COMPATIBILITY IDEOGRAPH-FA17
FAA6      ; [.3161.0022.0002.76CA][.31E8.0020.0002.76CA][.3232.0020.0002.76CA] # CJK COMPATIBILITY IDEOGRAPH-FAA6
FAA7      ; [.315F.002B.0002.76DB][.31D8.0020.0002.76DB][.3246.0020.0002.76DB] # CJK COMPATIBILITY IDEOGRAPH-FAA7
F933      ; [.315B.0028.0002.76E7][.31DC.0020.0002.76E7] # CJK COMPATIBILITY IDEOGRAPH-F933
FAA8      ; [.3162.0021.0002.76F4][.31E8.0020.0002.76F4][.3232.0020.0002.76F4] # CJK COMPATIBILITY IDEOGRAPH-FAA8
2F940     ; [.3162.0021.0002.76F4][.31E8.0020.0002.76F4][.3232.0020.0002.76F4] # CJK COMPATIBILITY IDEOGRAPH-2F940
F96D      ; [.315F.002C.0002.7701][.31D8.0020.0002.7701][.3246.0020.0002.7701] # CJK COMPATIBILITY IDEOGRAPH-F96D
2F945     ; [.3162.0033.0002.771E][.31E8.0020.0002.771E][.3235.0020.0002.771E] # CJK COMPATIBILITY IDEOGRAPH-2F945
FAAA      ; [.3164.0023.0002.7740][.31D4.0020.0002.7740][.3232.0020.0002.7740] # CJK COMPATIBILITY IDEOGRAPH-FAAA
2F94A     ; [.3162.0034.0002.778B][.31E8.0020.0002.778B][.3235.0020.0002.778B] # CJK COMPATIBILITY IDEOGRAPH-2F94A
F9CE      ; [.315B.002C.0002.786B][.31E5.0020.0002.786B] # CJK COMPATIBILITY IDEOGRAPH-F9CE
F93B      ; [.315B.0021.0002.788C][.31DC.0020.0002.788C][.3232.0020.0002.788C] # CJK COMPATIBILITY IDEOGRAPH-F93B
2F94F     ; [.315B.0021.0002.788C][.31DC.0020.0002.788C][.3232.0020.0002.788C] # CJK COMPATIBILITY IDEOGRAPH-2F94F
FA4B      ; [.315D.0038.0002.7891][.31E8.0020.0002.7891] # CJK COMPATIBILITY IDEOGRAPH-FA4B
F947      ; [.315B.0024.0002.78CA][.31DF.0020.0002.78CA] # CJK COMPATIBILITY IDEOGRAPH-F947
F964      ; [.315D.0032.0002.78FB][.31D4.0020.0002.78FB][.3235.0020.0002.78FB] # CJK COMPATIBILITY IDEOGRAPH-F964
F985      ; [.315B.002B.0002.792A][.31DA.0020.0002.792A] # CJK COMPATIBILITY IDEOGRAPH-F985
FA4C      ; [.315F.0046.0002.793E][.31D4.0020.0002.793E] # CJK COMPATIBILITY IDEOGRAPH-FA4C
FA4E      ; [.3156.004C.0002.7948][.31E8.0020.0002.7948] # CJK COMPATIBILITY IDEOGRAPH-FA4E
FA4D      ; [.3162.0035.0002.7949][.31E8.0020.0002.7949] # CJK COMPATIBILITY IDEOGRAPH-FA4D
FA4F      ; [.3161.0032.0002.7950][.31E1.0020.0002.7950] # CJK COMPATIBILITY IDEOGRAPH-FA4F
FA50      ; [.3162.0039.0002.7956][.31DC.0020.0002.7956] # CJK COMPATIBILITY IDEOGRAPH-FA50
2F953     ; [.3162.0039.0002.7956][.31DC.0020.0002.7956] # CJK COMPATIBILITY IDEOGRAPH-2F953
FA51      ; [.3164.0023.0002.795D][.31E1.0020.0002.795D][.3232.0020.0002.795D] # CJK COMPATIBILITY IDEOGRAPH-FA51
FA19      ; [.315F.002C.0002.795E][.31E8.0020.0002.795E][.3235.0020.0002.795E] # CJK COMPATIBILITY IDEOGRAPH-FA19
FA1A      ; [.315F.0037.0002.7965][.31D4.0020.0002.7965][.3246.0020.0002.7965] # CJK COMPATIBILITY IDEOGRAPH-FA1A
F93C      ; [.315B.0022.0002.797F][.31DC.0020.0002.797F][.3232.0020.0002.797F] # CJK COMPATIBILITY IDEOGRAPH-F93C
FA52      ; [.3168.0027.0002.798D][.31DD.0020.0002.798D] # CJK COMPATIBILITY IDEOGRAPH-FA52
FA53      ; [.3162.0044.0002.798E][.31D8.0020.0002.798E][.3246.0020.0002.798E] # CJK COMPATIBILITY IDEOGRAPH-FA53
FA1B      ; [.315D.0028.0002.798F][.31DC.0020.0002.798F][.3232.0020.0002.798F] # CJK COMPATIBILITY IDEOGRAPH-FA1B
2F956     ; [.315D.0028.0002.798F][.31DC.0020.0002.798F][.3232.0020.0002.798F] # CJK COMPATIBILITY IDEOGRAPH-2F956
F9B6      ; [.315B.0023.0002.79AE][.31DB.0020.0002.79AE] # CJK COMPATIBILITY IDEOGRAPH-F9B6
F995      ; [.3158.0023.0002.79CA][.31DA.0020.0002.79CA][.3235.0020.0002.79CA] # CJK COMPATIBILITY IDEOGRAPH-F995
2F957     ; [.3164.0024.0002.79EB][.31E1.0020.0002.79EB][.3239.0020.0002.79EB] # CJK COMPATIBILITY IDEOGRAPH-2F957
F956      ; [.315B.0023.0002.7A1C][.31E6.0020.0002.7A1C][.3246.0020.0002.7A1C] # CJK COMPATIBILITY IDEOGRAPH-F956
FA54      ; [.3156.0025.0002.7A40][.31DC.0020.0002.7A40][.3232.0020.0002.7A40] # CJK COMPATIBILITY IDEOGRAPH-FA54
2F959     ; [.3156.0025.0002.7A40][.31DC.0020.0002.7A40][.3232.0020.0002.7A40] # CJK COMPATIBILITY IDEOGRAPH-2F959
FA55      ; [.3159.0022.0002.7A81][.31DC.0020.0002.7A81][.3239.0020.0002.7A81] # CJK COMPATIBILITY IDEOGRAPH-FA55
F9F7      ; [.315B.0022.0002.7ACB][.31E8.0020.0002.7ACB][.3242.0020.0002.7ACB] # CJK COMPATIBILITY IDEOGRAPH-F9F7
F9F8      ; [.315B.0023.0002.7B20][.31E8.0020.0002.7B20][.3242.0020.0002.7B20] # CJK COMPATIBILITY IDEOGRAPH-F9F8
FA56      ; [.3162.0027.0002.7BC0][.31D8.0020.0002.7BC0][.3239.0020.0002.7BC0] # CJK COMPATIBILITY IDEOGRAPH-FA56
FAAD      ; [.3162.0027.0002.7BC0][.31D8.0020.0002.7BC0][.3239.0020.0002.7BC0] # CJK COMPATIBILITY IDEOGRAPH-FAAD
2F962     ; [.3162.003D.0002.7BC6][.31D8.0020.0002.7BC6][.3235.0020.0002.7BC6] # CJK COMPATIBILITY IDEOGRAPH-2F962
2F963     ; [.3164.0026.0002.7BC9][.31E1.0020.0002.7BC9][.3232.0020.0002.7BC9] # CJK COMPATIBILITY IDEOGRAPH-2F963
F9A6      ; [.315B.0025.0002.7C3E][.31DA.0020.0002.7C3E][.3241.0020.0002.7C3E] # CJK COMPATIBILITY IDEOGRAPH-F9A6
F944      ; [.315B.0026.0002.7C60][.31DC.0020.0002.7C60][.3246.0020.0002.7C60] # CJK COMPATIBILITY IDEOGRAPH-F944
F9F9      ; [.315B.0024.0002.7C92][.31E8.0020.0002.7C92][.3242.0020.0002.7C92] # CJK COMPATIBILITY IDEOGRAPH-F9F9
FA1D      ; [.3162.0047.0002.7CBE][.31D8.0020.0002.7CBE][.3246.0020.0002.7CBE] # CJK COMPATIBILITY IDEOGRAPH-FA1D
FA03      ; [.3159.0029.0002.7CD6][.31D4.0020.0002.7CD6][.3246.0020.0002.7CD6] # CJK COMPATIBILITY IDEOGRAPH-FA03
F97B      ; [.315B.0029.0002.7CE7][.31D6.0020.0002.7CE7][.3246.0020.0002.7CE7] # CJK COMPATIBILITY IDEOGRAPH-F97B
2F96A     ; [.3156.004F.0002.7D00][.31E8.0020.0002.7D00] # CJK COMPATIBILITY IDEOGRAPH-2F96A
F9CF      ; [.3158.0022.0002.7D10][.31E5.0020.0002.7D10] # CJK COMPATIBILITY IDEOGRAPH-F9CF
F96A      ; [.315F.0023.0002.7D22][.31D5.0020.0002.7D22][.3232.0020.0002.7D22] # CJK COMPATIBILITY IDEOGRAPH-F96A
F94F      ; [.315B.0028.0002.7D2F][.31E1.0020.0002.7D2F] # CJK COMPATIBILITY IDEOGRAPH-F94F
FAAF      ; [.3162.0063.0002.7D5B][.31DC.0020.0002.7D5B] # CJK COMPATIBILITY IDEOGRAPH-FAAF
2F96C     ; [.315D.0034.0002.7D63][.31DA.0020.0002.7D63][.3246.0020.0002.7D63] # CJK COMPATIBILITY IDEOGRAPH-2F96C
F93D      ; [.315B.0023.0002.7DA0][.31DC.0020.0002.7DA0][.3232.0020.0002.7DA0] # CJK COMPATIBILITY IDEOGRAPH-F93D
F957      ; [.315B.0024.0002.7DBE][.31E6.0020.0002.7DBE][.3246.0020.0002.7DBE] # CJK COMPATIBILITY IDEOGRAPH-F957
2F96E     ; [.3164.0030.0002.7DC7][.31E8.0020.0002.7DC7] # CJK COMPATIBILITY IDEOGRAPH-2F96E
F996      ; [.315B.0027.0002.7DF4][.31DA.0020.0002.7DF4][.3235.0020.0002.7DF4] # CJK COMPATIBILITY IDEOGRAPH-F996
FA57      ; [.315B.0027.0002.7DF4][.31DA.0020.0002.7DF4][.3235.0020.0002.7DF4] # CJK COMPATIBILITY IDEOGRAPH-FA57
FAB0      ; [.315B.0027.0002.7DF4][.31DA.0020.0002.7DF4][.3235.0020.0002.7DF4] # CJK COMPATIBILITY IDEOGRAPH-FAB0
FA58      ; [.3162.0036.0002.7E09][.31E8.0020.0002.7E09][.3235.0020.0002.7E09] # CJK COMPATIBILITY IDEOGRAPH-FA58
F950      ; [.315B.0029.0002.7E37][.31E1.0020.0002.7E37] # CJK COMPATIBILITY IDEOGRAPH-F950
FA59      ; [.315D.0026.0002.7E41][.31D8.0020.0002.7E41][.3235.0020.0002.7E41] # CJK COMPATIBILITY IDEOGRAPH-FA59
2F970     ; [.315F.0052.0002.7E45][.31DC.0020.0002.7E45] # CJK COMPATIBILITY IDEOGRAPH-2F970
FAB1      ; [.315D.0035.0002.7F3E][.31DA.0020.0002.7F3E][.3246.0020.0002.7F3E] # CJK COMPATIBILITY IDEOGRAPH-FAB1
FA5A      ; [.315F.0035.0002.7F72][.31D8.0020.0002.7F72] # CJK COMPATIBILITY IDEOGRAPH-FA5A
F9E6      ; [.315B.0031.0002.7F79][.31E8.0020.0002.7F79] # CJK COMPATIBILITY IDEOGRAPH-F9E6
F90F      ; [.315B.0024.0002.7F85][.31D4.0020.0002.7F85] # CJK COMPATIBILITY IDEOGRAPH-F90F
F9AF      ; [.315B.0029.0002.7F9A][.31DA.0020.0002.7F9A][.3246.0020.0002.7F9A] # CJK COMPATIBILITY IDEOGRAPH-F9AF
FA1E      ; [.3161.0036.0002.7FBD][.31E1.0020.0002.7FBD] # CJK COMPATIBILITY IDEOGRAPH-FA1E
2F979     ; [.3156.005A.0002.7FFA][.31DC.0020.0002.7FFA] # CJK COMPATIBILITY IDEOGRAPH-2F979
F934      ; [.315B.0029.0002.8001][.31DC.0020.0002.8001] # CJK COMPATIBILITY IDEOGRAPH-F934
FA5B      ; [.3162.0033.0002.8005][.31D4.0020.0002.8005] # CJK COMPATIBILITY IDEOGRAPH-FA5B
FAB2      ; [.3162.0033.0002.8005][.31D4.0020.0002.8005] # CJK COMPATIBILITY IDEOGRAPH-FAB2
2F97A     ; [.3162.0033.0002.8005][.31D4.0020.0002.8005] # CJK COMPATIBILITY IDEOGRAPH-2F97A
F9B0      ; [.315B.002B.0002.8046][.31DA.0020.0002.8046][.3246.0020.0002.8046] # CJK COMPATIBILITY IDEOGRAPH-F9B0
F997      ; [.315B.0028.0002.806F][.31DA.0020.0002.806F][.3235.0020.0002.806F] # CJK COMPATIBILITY IDEOGRAPH-F997
2F97F     ; [.3164.0028.0002.8070][.31DC.0020.0002.8070][.3246.0020.0002.8070] # CJK COMPATIBILITY IDEOGRAPH-2F97F
F945      ; [.315B.0027.0002.807E][.31DC.0020.0002.807E][.3246.0020.0002.807E] # CJK COMPATIBILITY IDEOGRAPH-F945
F953      ; [.315B.0022.0002.808B][.31E6.0020.0002.808B][.3232.0020.0002.808B] # CJK COMPATIBILITY IDEOGRAPH-F953
2F8D6     ; [.3158.0023.0002.80AD][.31E1.0020.0002.80AD][.3239.0020.0002.80AD] # CJK COMPATIBILITY IDEOGRAPH-2F8D6
2F982     ; [.3161.0024.0002.80B2][.31E5.0020.0002.80B2][.3232.0020.0002.80B2] # CJK COMPATIBILITY IDEOGRAPH-2F982
2F985     ; [.315D.003F.0002.813E][.31E8.0020.0002.813E] # CJK COMPATIBILITY IDEOGRAPH-2F985
F926      ; [.315B.0022.0002.81D8][.31D4.0020.0002.81D8][.3242.0020.0002.81D8] # CJK COMPATIBILITY IDEOGRAPH-F926
F9F6      ; [.315B.0024.0002.81E8][.31E8.0020.0002.81E8][.3241.0020.0002.81E8] # CJK COMPATIBILITY IDEOGRAPH-F9F6
FA5C      ; [.3164.002A.0002.81ED][.31E4.0020.0002.81ED] # CJK COMPATIBILITY IDEOGRAPH-FA5C
2F893     ; [.3161.002E.0002.8201][.31DA.0020.0002.8201] # CJK COMPATIBILITY IDEOGRAPH-2F893
2F98B     ; [.3161.002E.0002.8201][.31DA.0020.0002.8201] # CJK COMPATIBILITY IDEOGRAPH-2F98B
F97C      ; [.315B.002A.0002.826F][.31D6.0020.0002.826F][.3246.0020.0002.826F] # CJK COMPATIBILITY IDEOGRAPH-F97C
2F990     ; [.3161.0037.0002.828B][.31E1.0020.0002.828B] # CJK COMPATIBILITY IDEOGRAPH-2F990
2F991     ; [.3162.003B.0002.829D][.31E8.0020.0002.829D] # CJK COMPATIBILITY IDEOGRAPH-2F991
2F993     ; [.3168.0029.0002.82B1][.31DD.0020.0002.82B1] # CJK COMPATIBILITY IDEOGRAPH-2F993
2F994     ; [.315D.0035.0002.82B3][.31D4.0020.0002.82B3][.3246.0020.0002.82B3] # CJK COMPATIBILITY IDEOGRAPH-2F994
2F995     ; [.3161.0029.0002.82BD][.31D4.0020.0002.82BD] # CJK COMPATIBILITY IDEOGRAPH-2F995
F974      ; [.3161.0023.0002.82E5][.31D6.0020.0002.82E5][.3232.0020.0002.82E5] # CJK COMPATIBILITY IDEOGRAPH-F974
2F998     ; [.3161.0023.0002.82E5][.31D6.0020.0002.82E5][.3232.0020.0002.82E5] # CJK COMPATIBILITY IDEOGRAPH-2F998
2F996     ; [.3156.003A.0002.82E6][.31DC.0020.0002.82E6] # CJK COMPATIBILITY IDEOGRAPH-2F996
2F999     ; [.3164.002E.0002.831D][.31D5.0020.0002.831D] # CJK COMPATIBILITY IDEOGRAPH-2F999
2F99C     ; [.3161.004C.0002.8323][.31DC.0020.0002.8323] # CJK COMPATIBILITY IDEOGRAPH-2F99C
F9FE      ; [.3159.0022.0002.8336][.31D4.0020.0002.8336] # CJK COMPATIBILITY IDEOGRAPH-F9FE
FAB3      ; [.3168.0034.0002.8352][.31DD.0020.0002.8352][.3246.0020.0002.8352] # CJK COMPATIBILITY IDEOGRAPH-FAB3
2F99D     ; [.315C.002A.0002.83BD][.31D4.0020.0002.83BD][.3246.0020.0002.83BD] # CJK COMPATIBILITY IDEOGRAPH-2F99D
F93E      ; [.315B.0024.0002.83C9][.31DC.0020.0002.83C9][.3232.0020.0002.83C9] # CJK COMPATIBILITY IDEOGRAPH-F93E
2F9A1     ; [.3156.0023.0002.83CA][.31E1.0020.0002.83CA][.3232.0020.0002.83CA] # CJK COMPATIBILITY IDEOGRAPH-2F9A1
2F9A2     ; [.3156.0025.0002.83CC][.31E5.0020.0002.83CC][.3235.0020.0002.83CC] # CJK COMPATIBILITY IDEOGRAPH-2F9A2
2F9A3     ; [.3164.0029.0002.83DC][.31D5.0020.0002.83DC] # CJK COMPATIBILITY IDEOGRAPH-2F9A3
FAB4      ; [.3168.002A.0002.83EF][.31DD.0020.0002.83EF] # CJK COMPATIBILITY IDEOGRAPH-FAB4
F958      ; [.315B.0025.0002.83F1][.31E6.0020.0002.83F1][.3246.0020.0002.83F1] # CJK COMPATIBILITY IDEOGRAPH-F958
F918      ; [.315B.0025.0002.843D][.31D4.0020.0002.843D][.3232.0020.0002.843D] # CJK COMPATIBILITY IDEOGRAPH-F918
F96E      ; [.3161.0023.0002.8449][.31DA.0020.0002.8449][.3242.0020.0002.8449] # CJK COMPATIBILITY IDEOGRAPH-F96E
FA5F      ; [.3162.0034.0002.8457][.31D8.0020.0002.8457] # CJK COMPATIBILITY IDEOGRAPH-FA5F
2F99F     ; [.3162.0034.0002.8457][.31D8.0020.0002.8457] # CJK COMPATIBILITY IDEOGRAPH-2F99F
F999      ; [.315B.0029.0002.84EE][.31DA.0020.0002.84EE][.3235.0020.0002.84EE] # CJK COMPATIBILITY IDEOGRAPH-F999
2F9A8     ; [.3167.002A.0002.84F1][.31DA.0020.0002.84F1][.3246.0020.0002.84F1] # CJK COMPATIBILITY IDEOGRAPH-2F9A8
F9C2      ; [.315B.002A.0002.84FC][.31E0.0020.0002.84FC] # CJK COMPATIBILITY IDEOGRAPH-F9C2
2F9AC     ; [.3161.0062.0002.8564][.31E5.0020.0002.8564] # CJK COMPATIBILITY IDEOGRAPH-2F9AC
F923      ; [.315B.0028.0002.85CD][.31D4.0020.0002.85CD][.3241.0020.0002.85CD] # CJK COMPATIBILITY IDEOGRAPH-F923
F9F0      ; [.315B.0025.0002.85FA][.31E8.0020.0002.85FA][.3235.0020.0002.85FA] # CJK COMPATIBILITY IDEOGRAPH-F9F0
F935      ; [.315B.002A.0002.8606][.31DC.0020.0002.8606] # CJK COMPATIBILITY IDEOGRAPH-F935
F91F      ; [.315B.0027.0002.862D][.31D4.0020.0002.862D][.3235.0020.0002.862D] # CJK COMPATIBILITY IDEOGRAPH-F91F
F910      ; [.315B.0025.0002.863F][.31D4.0020.0002.863F] # CJK COMPATIBILITY IDEOGRAPH-F910
2F9B3     ; [.3168.0023.0002.8650][.31D4.0020.0002.8650][.3232.0020.0002.8650] # CJK COMPATIBILITY IDEOGRAPH-2F9B3
F936      ; [.315B.002B.0002.865C][.31DC.0020.0002.865C] # CJK COMPATIBILITY IDEOGRAPH-F936
2F9B4     ; [.315B.002B.0002.865C][.31DC.0020.0002.865C] # CJK COMPATIBILITY IDEOGRAPH-2F9B4
2F9B5     ; [.3168.0025.0002.8667][.31E5.0020.0002.8667] # CJK COMPATIBILITY IDEOGRAPH-2F9B5
2F9B7     ; [.3164.0034.0002.86A9][.31E8.0020.0002.86A9] # CJK COMPATIBILITY IDEOGRAPH-2F9B7
2F9BC     ; [.3162.0026.0002.8728][.31D8.0020.0002.8728][.3242.0020.0002.8728] # CJK COMPATIBILITY IDEOGRAPH-2F9BC
F911      ; [.315B.0026.0002.87BA][.31D4.0020.0002.87BA] # CJK COMPATIBILITY IDEOGRAPH-F911
F927      ; [.315B.0023.0002.881F][.31D4.0020.0002.881F][.3242.0020.0002.881F] # CJK COMPATIBILITY IDEOGRAPH-F927
FA08      ; [.3168.0025.0002.884C][.31D5.0020.0002.884C][.3246.0020.0002.884C] # CJK COMPATIBILITY IDEOGRAPH-FA08
2F9C4     ; [.3161.0030.0002.8863][.31E7.0020.0002.8863] # CJK COMPATIBILITY IDEOGRAPH-2F9C4
F9A0      ; [.315B.0026.0002.88C2][.31DA.0020.0002.88C2][.3239.0020.0002.88C2] # CJK COMPATIBILITY IDEOGRAPH-F9A0
F9E7      ; [.315B.0034.0002.88CF][.31E8.0020.0002.88CF] # CJK COMPATIBILITY IDEOGRAPH-F9E7
F9E8      ; [.315B.0035.0002.88E1][.31E8.0020.0002.88E1] # CJK COMPATIBILITY IDEOGRAPH-F9E8
F912      ; [.315B.0027.0002.88F8][.31D4.0020.0002.88F8] # CJK COMPATIBILITY IDEOGRAPH-F912
FA60      ; [.3156.0028.0002.8910][.31D4.0020.0002.8910][.3239.0020.0002.8910] # CJK COMPATIBILITY IDEOGRAPH-FA60
FAB6      ; [.3156.0034.0002.8941][.31D4.0020.0002.8941][.3246.0020.0002.8941] # CJK COMPATIBILITY IDEOGRAPH-FAB6
F924      ; [.315B.0029.0002.8964][.31D4.0020.0002.8964][.3241.0020.0002.8964] # CJK COMPATIBILITY IDEOGRAPH-F924
FAB7      ; [.315D.002D.0002.8986][.31DC.0020.0002.8986][.3232.0020.0002.8986] # CJK COMPATIBILITY IDEOGRAPH-FAB7
FA0A      ; [.3156.0028.0002.898B][.31DA.0020.0002.898B][.3235.0020.0002.898B] # CJK COMPATIBILITY IDEOGRAPH-FA0A
FA61      ; [.315F.0037.0002.8996][.31E8.0020.0002.8996] # CJK COMPATIBILITY IDEOGRAPH-FA61
FAB8      ; [.315F.0037.0002.8996][.31E8.0020.0002.8996] # CJK COMPATIBILITY IDEOGRAPH-FAB8
2F9CF     ; [.315F.0031.0002.8AA0][.31D8.0020.0002.8AA0][.3246.0020.0002.8AA0] # CJK COMPATIBILITY IDEOGRAPH-2F9CF
F96F      ; [.315F.002B.0002.8AAA][.31D8.0020.0002.8AAA][.3239.0020.0002.8AAA] # CJK COMPATIBILITY IDEOGRAPH-F96F
F9A1      ; [.315F.002B.0002.8AAA][.31D8.0020.0002.8AAA][.3239.0020.0002.8AAA] # CJK COMPATIBILITY IDEOGRAPH-F9A1
FAB9      ; [.3162.0046.0002.8ABF][.31DC.0020.0002.8ABF] # CJK COMPATIBILITY IDEOGRAPH-FAB9
FABB      ; [.3164.0026.0002.8ACB][.31D8.0020.0002.8ACB][.3246.0020.0002.8ACB] # CJK COMPATIBILITY IDEOGRAPH-FABB
F97D      ; [.315B.002B.0002.8AD2][.31D6.0020.0002.8AD2][.3246.0020.0002.8AD2] # CJK COMPATIBILITY IDEOGRAPH-F97D
F941      ; [.315B.0021.0002.8AD6][.31DC.0020.0002.8AD6][.3235.0020.0002.8AD6] # CJK COMPATIBILITY IDEOGRAPH-F941
FABE      ; [.3161.0046.0002.8AED][.31E5.0020.0002.8AED] # CJK COMPATIBILITY IDEOGRAPH-FABE
2F9D0     ; [.3161.0046.0002.8AED][.31E5.0020.0002.8AED] # CJK COMPATIBILITY IDEOGRAPH-2F9D0
FA22      ; [.3162.0030.0002.8AF8][.31D9.0020.0002.8AF8] # CJK COMPATIBILITY IDEOGRAPH-FA22
FABA      ; [.3162.0030.0002.8AF8][.31D9.0020.0002.8AF8] # CJK COMPATIBILITY IDEOGRAPH-FABA
F95D      ; [.3158.0021.0002.8AFE][.31D4.0020.0002.8AFE][.3232.0020.0002.8AFE] # CJK COMPATIBILITY IDEOGRAPH-F95D
FABD      ; [.3158.0021.0002.8AFE][.31D4.0020.0002.8AFE][.3232.0020.0002.8AFE] # CJK COMPATIBILITY IDEOGRAPH-FABD
FA62      ; [.3161.0022.0002.8B01][.31D4.0020.0002.8B01][.3239.0020.0002.8B01] # CJK COMPATIBILITY IDEOGRAPH-FA62
FABC      ; [.3161.0022.0002.8B01][.31D4.0020.0002.8B01][.3239.0020.0002.8B01] # CJK COMPATIBILITY IDEOGRAPH-FABC
FA63      ; [.3156.002D.0002.8B39][.31E6.0020.0002.8B39][.3235.0020.0002.8B39] # CJK COMPATIBILITY IDEOGRAPH-FA63
FABF      ; [.3156.002D.0002.8B39][.31E6.0020.0002.8B39][.3235.0020.0002.8B39] # CJK COMPATIBILITY IDEOGRAPH-FABF
F9FC      ; [.315F.002C.0002.8B58][.31E8.0020.0002.8B58][.3232.0020.0002.8B58] # CJK COMPATIBILITY IDEOGRAPH-F9FC
F95A      ; [.3159.002A.0002.8B80][.31DC.0020.0002.8B80][.3232.0020.0002.8B80] # CJK COMPATIBILITY IDEOGRAPH-F95A
FAC0      ; [.315D.0023.0002.8B8A][.31DA.0020.0002.8B8A][.3235.0020.0002.8B8A] # CJK COMPATIBILITY IDEOGRAPH-FAC0
2F9D1     ; [.315D.0023.0002.8B8A][.31DA.0020.0002.8B8A][.3235.0020.0002.8B8A] # CJK COMPATIBILITY IDEOGRAPH-2F9D1
F900      ; [.3156.0057.0002.8C48][.31E8.0020.0002.8C48] # CJK COMPATIBILITY IDEOGRAPH-F900
2F9D2     ; [.315F.003B.0002.8C55][.31E8.0020.0002.8C55] # CJK COMPATIBILITY IDEOGRAPH-2F9D2
2F9D4     ; [.3156.002E.0002.8CAB][.31DD.0020.0002.8CAB][.3235.0020.0002.8CAB] # CJK COMPATIBILITY IDEOGRAPH-2F9D4
2F9D5     ; [.315D.0032.0002.8CC1][.31E1.0020.0002.8CC1][.3235.0020.0002.8CC1] # CJK COMPATIBILITY IDEOGRAPH-2F9D5
F948      ; [.315B.0025.0002.8CC2][.31DF.0020.0002.8CC2] # CJK COMPATIBILITY IDEOGRAPH-F948
F903      ; [.3156.0039.0002.8CC8][.31D4.0020.0002.8CC8] # CJK COMPATIBILITY IDEOGRAPH-F903
FA64      ; [.315D.002D.0002.8CD3][.31E8.0020.0002.8CD3][.3235.0020.0002.8CD3] # CJK COMPATIBILITY IDEOGRAPH-FA64
FA65      ; [.3162.002B.0002.8D08][.31E6.0020.0002.8D08][.3246.0020.0002.8D08] # CJK COMPATIBILITY IDEOGRAPH-FA65
FAC1      ; [.3162.002B.0002.8D08][.31E6.0020.0002.8D08][.3246.0020.0002.8D08] # CJK COMPATIBILITY IDEOGRAPH-FAC1
2F9D6     ; [.3156.0039.0002.8D1B][.31DC.0020.0002.8D1B][.3246.0020.0002.8D1B] # CJK COMPATIBILITY IDEOGRAPH-2F9D6
2F9D7     ; [.3156.0058.0002.8D77][.31E8.0020.0002.8D77] # CJK COMPATIBILITY IDEOGRAPH-2F9D7
2F9DA     ; [.315D.0027.0002.8DCB][.31D4.0020.0002.8DCB][.3239.0020.0002.8DCB] # CJK COMPATIBILITY IDEOGRAPH-2F9DA
F937      ; [.315B.002C.0002.8DEF][.31DC.0020.0002.8DEF] # CJK COMPATIBILITY IDEOGRAPH-F937
F902      ; [.3164.002D.0002.8ECA][.31D4.0020.0002.8ECA] # CJK COMPATIBILITY IDEOGRAPH-F902
F998      ; [.315B.002A.0002.8F26][.31DA.0020.0002.8F26][.3235.0020.0002.8F26] # CJK COMPATIBILITY IDEOGRAPH-F998
F9D7      ; [.315B.0026.0002.8F2A][.31E5.0020.0002.8F2A][.3235.0020.0002.8F2A] # CJK COMPATIBILITY IDEOGRAPH-F9D7
FAC2      ; [.315F.004F.0002.8F38][.31E1.0020.0002.8F38] # CJK COMPATIBILITY IDEOGRAPH-FAC2
2F9DF     ; [.315F.004F.0002.8F38][.31E1.0020.0002.8F38] # CJK COMPATIBILITY IDEOGRAPH-2F9DF
FA07      ; [.315D.002F.0002.8F3B][.31DC.0020.0002.8F3B][.3232.0020.0002.8F3B] # CJK COMPATIBILITY IDEOGRAPH-FA07
F98D      ; [.315B.0026.0002.8F62][.31DA.0020.0002.8F62][.3232.0020.0002.8F62] # CJK COMPATIBILITY IDEOGRAPH-F98D
F971      ; [.3162.003E.0002.8FB0][.31E8.0020.0002.8FB0][.3235.0020.0002.8FB0] # CJK COMPATIBILITY IDEOGRAPH-F971
F99A      ; [.315B.002B.0002.9023][.31DA.0020.0002.9023][.3235.0020.0002.9023] # CJK COMPATIBILITY IDEOGRAPH-F99A
FA25      ; [.3161.0027.0002.9038][.31E8.0020.0002.9038][.3239.0020.0002.9038] # CJK COMPATIBILITY IDEOGRAPH-FA25
FA67      ; [.3161.0027.0002.9038][.31E8.0020.0002.9038][.3239.0020.0002.9038] # CJK COMPATIBILITY IDEOGRAPH-FA67
FAC3      ; [.3162.0041.0002.9072][.31E8.0020.0002.9072] # CJK COMPATIBILITY IDEOGRAPH-FAC3
F9C3      ; [.315B.002B.0002.907C][.31E0.0020.0002.907C] # CJK COMPATIBILITY IDEOGRAPH-F9C3
F913      ; [.315B.0028.0002.908F][.31D4.0020.0002.908F] # CJK COMPATIBILITY IDEOGRAPH-F913
FA2E      ; [.315B.0028.0002.90DE][.31D4.0020.0002.90DE][.3246.0020.0002.90DE] # CJK COMPATIBILITY IDEOGRAPH-FA2E
FA26      ; [.3159.0045.0002.90FD][.31DC.0020.0002.90FD] # CJK COMPATIBILITY IDEOGRAPH-FA26
F919      ; [.315B.0026.0002.916A][.31D4.0020.0002.916A][.3232.0020.0002.916A] # CJK COMPATIBILITY IDEOGRAPH-F919
F9B7      ; [.315B.0024.0002.91B4][.31DB.0020.0002.91B4] # CJK COMPATIBILITY IDEOGRAPH-F9B7
F9E9      ; [.315B.0036.0002.91CC][.31E8.0020.0002.91CC] # CJK COMPATIBILITY IDEOGRAPH-F9E9
F97E      ; [.315B.002D.0002.91CF][.31D6.0020.0002.91CF][.3246.0020.0002.91CF] # CJK COMPATIBILITY IDEOGRAPH-F97E
F90A      ; [.3156.0021.0002.91D1][.31E8.0020.0002.91D1][.3241.0020.0002.91D1] # CJK COMPATIBILITY IDEOGRAPH-F90A
F9B1      ; [.315B.002D.0002.9234][.31DA.0020.0002.9234][.3246.0020.0002.9234] # CJK COMPATIBILITY IDEOGRAPH-F9B1
2F9E7     ; [.315D.002F.0002.9238][.31D4.0020.0002.9238][.3239.0020.0002.9238] # CJK COMPATIBILITY IDEOGRAPH-2F9E7
2F9EA     ; [.315D.0039.0002.927C][.31DA.0020.0002.927C][.3246.0020.0002.927C] # CJK COMPATIBILITY IDEOGRAPH-2F9EA
2F9E8     ; [.3168.003F.0002.92D7][.31DA.0020.0002.92D7][.3235.0020.0002.92D7] # CJK COMPATIBILITY IDEOGRAPH-2F9E8
F93F      ; [.315B.0025.0002.9304][.31DC.0020.0002.9304][.3232.0020.0002.9304] # CJK COMPATIBILITY IDEOGRAPH-F93F
F99B      ; [.315B.002C.0002.934A][.31DA.0020.0002.934A][.3235.0020.0002.934A] # CJK COMPATIBILITY IDEOGRAPH-F99B
2F9EE     ; [.3156.0033.0002.958B][.31D5.0020.0002.958B] # CJK COMPATIBILITY IDEOGRAPH-2F9EE
F986      ; [.315B.002E.0002.95AD][.31DA.0020.0002.95AD] # CJK COMPATIBILITY IDEOGRAPH-F986
F9C6      ; [.3161.0031.0002.962E][.31DD.0020.0002.962E][.3235.0020.0002.962E] # CJK COMPATIBILITY IDEOGRAPH-F9C6
F951      ; [.315B.002D.0002.964B][.31E1.0020.0002.964B] # CJK COMPATIBILITY IDEOGRAPH-F951
FA09      ; [.3156.0037.0002.964D][.31D4.0020.0002.964D][.3246.0020.0002.964D] # CJK COMPATIBILITY IDEOGRAPH-FA09
F959      ; [.315B.0026.0002.9675][.31E6.0020.0002.9675][.3246.0020.0002.9675] # CJK COMPATIBILITY IDEOGRAPH-F959
F9D3      ; [.315B.0023.0002.9678][.31E5.0020.0002.9678][.3232.0020.0002.9678] # CJK COMPATIBILITY IDEOGRAPH-F9D3
FAC6      ; [.3162.004E.0002.967C][.31D8.0020.0002.967C] # CJK COMPATIBILITY IDEOGRAPH-FAC6
F9DC      ; [.315B.0021.0002.9686][.31E5.0020.0002.9686][.3246.0020.0002.9686] # CJK COMPATIBILITY IDEOGRAPH-F9DC
F9F1      ; [.315B.0027.0002.96A3][.31E8.0020.0002.96A3][.3235.0020.0002.96A3] # CJK COMPATIBILITY IDEOGRAPH-F9F1
FA2F      ; [.315B.0025.0002.96B7][.31DB.0020.0002.96B7] # CJK COMPATIBILITY IDEOGRAPH-FA2F
F9B8      ; [.315B.0026.0002.96B8][.31DB.0020.0002.96B8] # CJK COMPATIBILITY IDEOGRAPH-F9B8
F9EA      ; [.315B.0038.0002.96E2][.31E8.0020.0002.96E2] # CJK COMPATIBILITY IDEOGRAPH-F9EA
FA68      ; [.3158.0023.0002.96E3][.31D4.0020.0002.96E3][.3235.0020.0002.96E3] # CJK COMPATIBILITY IDEOGRAPH-FA68
FAC7      ; [.3158.0023.0002.96E3][.31D4.0020.0002.96E3][.3235.0020.0002.96E3] # CJK COMPATIBILITY IDEOGRAPH-FAC7
F9B2      ; [.315B.002E.0002.96F6][.31DA.0020.0002.96F6][.3246.0020.0002.96F6] # CJK COMPATIBILITY IDEOGRAPH-F9B2
F949      ; [.315B.0028.0002.96F7][.31DF.0020.0002.96F7] # CJK COMPATIBILITY IDEOGRAPH-F949
2F9F5     ; [.3161.0031.0002.9723][.31E1.0020.0002.9723][.3235.0020.0002.9723] # CJK COMPATIBILITY IDEOGRAPH-2F9F5
F938      ; [.315B.002E.0002.9732][.31DC.0020.0002.9732] # CJK COMPATIBILITY IDEOGRAPH-F938
F9B3      ; [.315B.002F.0002.9748][.31DA.0020.0002.9748][.3246.0020.0002.9748] # CJK COMPATIBILITY IDEOGRAPH-F9B3
FA1C      ; [.3162.0054.0002.9756][.31D8.0020.0002.9756][.3246.0020.0002.9756] # CJK COMPATIBILITY IDEOGRAPH-FA1C
FAC8      ; [.3162.0054.0002.9756][.31D8.0020.0002.9756][.3246.0020.0002.9756] # CJK COMPATIBILITY IDEOGRAPH-FAC8
2F9FA     ; [.3167.0034.0002.97E0][.31E8.0020.0002.97E0][.3239.0020.0002.97E0] # CJK COMPATIBILITY IDEOGRAPH-2F9FA
FA69      ; [.3168.0026.0002.97FF][.31D6.0020.0002.97FF][.3246.0020.0002.97FF] # CJK COMPATIBILITY IDEOGRAPH-FA69
FACA      ; [.3168.0026.0002.97FF][.31D6.0020.0002.97FF][.3246.0020.0002.97FF] # CJK COMPATIBILITY IDEOGRAPH-FACA
F9B4      ; [.315B.0030.0002.9818][.31DA.0020.0002.9818][.3246.0020.0002.9818] # CJK COMPATIBILITY IDEOGRAPH-F9B4
FA6A      ; [.315D.002E.0002.983B][.31E8.0020.0002.983B][.3235.0020.0002.983B] # CJK COMPATIBILITY IDEOGRAPH-FA6A
FACC      ; [.315D.002E.0002.983B][.31E8.0020.0002.983B][.3235.0020.0002.983B] # CJK COMPATIBILITY IDEOGRAPH-FACC
F9D0      ; [.315B.002E.0002.985E][.31E5.0020.0002.985E] # CJK COMPATIBILITY IDEOGRAPH-F9D0
2FA02     ; [.3156.005B.0002.98E2][.31E8.0020.0002.98E2] # CJK COMPATIBILITY IDEOGRAPH-2FA02
FA2A      ; [.315D.0039.0002.98EF][.31D4.0020.0002.98EF][.3235.0020.0002.98EF] # CJK COMPATIBILITY IDEOGRAPH-FA2A
FA2B      ; [.315F.005A.0002.98FC][.31D4.0020.0002.98FC] # CJK COMPATIBILITY IDEOGRAPH-FA2B
FA2C      ; [.3156.0030.0002.9928][.31DD.0020.0002.9928][.3235.0020.0002.9928] # CJK COMPATIBILITY IDEOGRAPH-FA2C
F91A      ; [.315B.0027.0002.99F1][.31D4.0020.0002.99F1][.3232.0020.0002.99F1] # CJK COMPATIBILITY IDEOGRAPH-F91A
F987      ; [.315B.0030.0002.9A6A][.31DA.0020.0002.9A6A] # CJK COMPATIBILITY IDEOGRAPH-F987
FACD      ; [.3162.004C.0002.9B12][.31E8.0020.0002.9B12][.3235.0020.0002.9B12] # CJK COMPATIBILITY IDEOGRAPH-FACD
2FA0A     ; [.3162.004C.0002.9B12][.31E8.0020.0002.9B12][.3235.0020.0002.9B12] # CJK COMPATIBILITY IDEOGRAPH-2FA0A
F939      ; [.315B.002F.0002.9B6F][.31DC.0020.0002.9B6F] # CJK COMPATIBILITY IDEOGRAPH-F939
F9F2      ; [.315B.0028.0002.9C57][.31E8.0020.0002.9C57][.3235.0020.0002.9C57] # CJK COMPATIBILITY IDEOGRAPH-F9F2
FA2D      ; [.3168.0025.0002.9DB4][.31D4.0020.0002.9DB4][.3232.0020.0002.9DB4] # CJK COMPATIBILITY IDEOGRAPH-FA2D
F93A      ; [.315B.0030.0002.9DFA][.31DC.0020.0002.9DFA] # CJK COMPATIBILITY IDEOGRAPH-F93A
F920      ; [.315B.0028.0002.9E1E][.31D4.0020.0002.9E1E][.3235.0020.0002.9E1E] # CJK COMPATIBILITY IDEOGRAPH-F920
F940      ; [.315B.0026.0002.9E7F][.31DC.0020.0002.9E7F][.3232.0020.0002.9E7F] # CJK COMPATIBILITY IDEOGRAPH-F940
F988      ; [.315B.0031.0002.9E97][.31DA.0020.0002.9E97] # CJK COMPATIBILITY IDEOGRAPH-F988
F9F3      ; [.315B.0029.0002.9E9F][.31E8.0020.0002.9E9F][.3235.0020.0002.9E9F] # CJK COMPATIBILITY IDEOGRAPH-F9F3
2FA15     ; [.315C.0028.0002.9EBB][.31D4.0020.0002.9EBB] # CJK COMPATIBILITY IDEOGRAPH-2FA15
F989      ; [.315B.0032.0002.9ECE][.31DA.0020.0002.9ECE] # CJK COMPATIBILITY IDEOGRAPH-F989
2FA1C     ; [.315D.004A.0002.9F3B][.31E8.0020.0002.9F3B] # CJK COMPATIBILITY IDEOGRAPH-2FA1C
F9C4      ; [.315B.0021.0002.9F8D][.31E0.0020.0002.9F8D][.3246.0020.0002.9F8D] # CJK COMPATIBILITY IDEOGRAPH-F9C4
FAD9      ; [.315B.002E.0002.9F8E][.31DC.0020.0002.9F8E][.3246.0020.0002.9F8E] # CJK COMPATIBILITY IDEOGRAPH-FAD9
F907      ; [.3156.0056.0002.9F9C][.31E1.0020.0002.9F9C] # CJK COMPATIBILITY IDEOGRAPH-F907
F908      ; [.3156.0056.0002.9F9C][.31E1.0020.0002.9F9C] # CJK COMPATIBILITY IDEOGRAPH-F908
FACE      ; [.3156.0056.0002.9F9C][.31E1.0020.0002.9F9C] # CJK COMPATIBILITY IDEOGRAPH-FACE
ENTRY
};
