BEGIN {
  use strict; use warnings;
  unless(eval q{ use 5.008; 1}) {
    print "Perl 5.008 or better required\n";
    exit;
  }
}
# This file was automatically generated by Dist::Zilla::Plugin::Author::Plicease::MakeMaker v2.66.
use strict;
use warnings;
use 5.008;
use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT"           => "A simple, extensible Perl debugger",
  "AUTHOR"             => "Graham Ollis <plicease\@cpan.org>, Leon Brocard <acme\@astray.com>, Brock Wilcox <awwaiid\@thelackthereof.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => 0
  },
  "DISTNAME"  => "Devel-ebug",
  "EXE_FILES" => [
    "bin/ebug",
    "bin/ebug_backend_perl",
    "bin/ebug_client",
    "bin/ebug_server"
  ],
  "LICENSE"          => "perl",
  "MIN_PERL_VERSION" => "5.008",
  "NAME"             => "Devel::ebug",
  "PM"               => {
    "lib/Devel/ebug.pm"                             => "\$(INST_LIB)/Devel/ebug.pm",
    "lib/Devel/ebug/Backend.pm"                     => "\$(INST_LIB)/Devel/ebug/Backend.pm",
    "lib/Devel/ebug/Backend/Plugin/ActionPoints.pm" => "\$(INST_LIB)/Devel/ebug/Backend/Plugin/ActionPoints.pm",
    "lib/Devel/ebug/Backend/Plugin/Basic.pm"        => "\$(INST_LIB)/Devel/ebug/Backend/Plugin/Basic.pm",
    "lib/Devel/ebug/Backend/Plugin/Codelines.pm"    => "\$(INST_LIB)/Devel/ebug/Backend/Plugin/Codelines.pm",
    "lib/Devel/ebug/Backend/Plugin/Commands.pm"     => "\$(INST_LIB)/Devel/ebug/Backend/Plugin/Commands.pm",
    "lib/Devel/ebug/Backend/Plugin/Eval.pm"         => "\$(INST_LIB)/Devel/ebug/Backend/Plugin/Eval.pm",
    "lib/Devel/ebug/Backend/Plugin/Filenames.pm"    => "\$(INST_LIB)/Devel/ebug/Backend/Plugin/Filenames.pm",
    "lib/Devel/ebug/Backend/Plugin/Output.pm"       => "\$(INST_LIB)/Devel/ebug/Backend/Plugin/Output.pm",
    "lib/Devel/ebug/Backend/Plugin/Pad.pm"          => "\$(INST_LIB)/Devel/ebug/Backend/Plugin/Pad.pm",
    "lib/Devel/ebug/Backend/Plugin/Ping.pm"         => "\$(INST_LIB)/Devel/ebug/Backend/Plugin/Ping.pm",
    "lib/Devel/ebug/Backend/Plugin/Run.pm"          => "\$(INST_LIB)/Devel/ebug/Backend/Plugin/Run.pm",
    "lib/Devel/ebug/Backend/Plugin/StackTrace.pm"   => "\$(INST_LIB)/Devel/ebug/Backend/Plugin/StackTrace.pm",
    "lib/Devel/ebug/Console.pm"                     => "\$(INST_LIB)/Devel/ebug/Console.pm",
    "lib/Devel/ebug/Plugin/ActionPoints.pm"         => "\$(INST_LIB)/Devel/ebug/Plugin/ActionPoints.pm",
    "lib/Devel/ebug/Plugin/Basic.pm"                => "\$(INST_LIB)/Devel/ebug/Plugin/Basic.pm",
    "lib/Devel/ebug/Plugin/Codelines.pm"            => "\$(INST_LIB)/Devel/ebug/Plugin/Codelines.pm",
    "lib/Devel/ebug/Plugin/Eval.pm"                 => "\$(INST_LIB)/Devel/ebug/Plugin/Eval.pm",
    "lib/Devel/ebug/Plugin/Filenames.pm"            => "\$(INST_LIB)/Devel/ebug/Plugin/Filenames.pm",
    "lib/Devel/ebug/Plugin/Output.pm"               => "\$(INST_LIB)/Devel/ebug/Plugin/Output.pm",
    "lib/Devel/ebug/Plugin/Pad.pm"                  => "\$(INST_LIB)/Devel/ebug/Plugin/Pad.pm",
    "lib/Devel/ebug/Plugin/Run.pm"                  => "\$(INST_LIB)/Devel/ebug/Plugin/Run.pm",
    "lib/Devel/ebug/Plugin/StackTrace.pm"           => "\$(INST_LIB)/Devel/ebug/Plugin/StackTrace.pm"
  },
  "PREREQ_PM" => {
    "Class::Accessor::Chained" => 0,
    "Devel::StackTrace"        => "2.00",
    "IO::Socket::INET"         => 0,
    "Module::Pluggable"        => 0,
    "PadWalker"                => 0,
    "Proc::Background"         => 0,
    "String::Koremutake"       => 0,
    "Term::ReadLine"           => 0,
    "YAML"                     => 0,
    "base"                     => 0,
    "strict"                   => 0,
    "warnings"                 => 0
  },
  "TEST_REQUIRES" => {
    "Test::More" => "0.94"
  },
  "VERSION" => "0.64",
  "test"    => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "Class::Accessor::Chained" => 0,
  "Devel::StackTrace"        => "2.00",
  "IO::Socket::INET"         => 0,
  "Module::Pluggable"        => 0,
  "PadWalker"                => 0,
  "Proc::Background"         => 0,
  "String::Koremutake"       => 0,
  "Term::ReadLine"           => 0,
  "Test::More"               => "0.94",
  "YAML"                     => 0,
  "base"                     => 0,
  "strict"                   => 0,
  "warnings"                 => 0
);

# inserted by Dist::Zilla::Plugin::DynamicPrereqs 0.039
if ( $^O ne 'MSWin32' ) {
  test_requires('Test::Expect');
}

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

# inserted by Dist::Zilla::Plugin::DynamicPrereqs 0.039
sub _add_prereq {
  my ( $mm_key, $module, $version_or_range ) = @_;
  $version_or_range ||= 0;
  warn "$module already exists in $mm_key (at version $WriteMakefileArgs{$mm_key}{$module}) -- need to do a sane metamerge!"
    if exists $WriteMakefileArgs{$mm_key}{$module}
    and $WriteMakefileArgs{$mm_key}{$module} ne '0'
    and $WriteMakefileArgs{$mm_key}{$module} ne $version_or_range;
  warn "$module already exists in FallbackPrereqs (at version $FallbackPrereqs{$module}) -- need to do a sane metamerge!"
    if exists $FallbackPrereqs{$module} and $FallbackPrereqs{$module} ne '0'
    and $FallbackPrereqs{$module} ne $version_or_range;
  $WriteMakefileArgs{$mm_key}{$module} = $FallbackPrereqs{$module} = $version_or_range;
  return;
}

sub test_requires {
  my ( $module, $version_or_range ) = @_;
  _add_prereq( TEST_REQUIRES => $module, $version_or_range );
}