#!/usr/local/bin/ruby
require "dir-compare"
require "ftools"

class Cp_r < DirPairWalker
  def file_file(s, t)
    File.cp(s, t)
  end

  def file_dir(s, t)
    raise "cannot overwrite directory `#{t}' with non-directory `#{s}'"
  end

  def file_non(s, t)
    File.cp(s, t)
  end

  def dir_file(s, t)
    raise "cannot overwrite non-directory `#{t}' with directory `#{s}'"
  end

  def dir_non(s, t)
    File.mkpath(t)
  end
end

raise "missing destination file" if ARGV.size < 2
target = ARGV.pop
target.chomp!(File::SEPARATOR)

visitor = Cp_r.new
dc = DirCompare.new(visitor)

ARGV.each do |source|
  source.chomp!(File::SEPARATOR)
  begin
    target0 = if File.directory?(target)
		File.join(target, File.basename(source))
	      else
		target
	      end
    dc.compare(source, target0)
  rescue
    $stderr.puts $!
    exit(1)
  end
end
