#!/usr/local/bin/ruby
require "dir-compare"
require "ftools"

class Rm_rf < DirWalker
  def file(s)
    File.unlink(s)
  end

  def dir_out(s)
    Dir.unlink(s)
  end
end

def rm_rf(paths)
  rm = Rm_rf.new
  dc = DirCompare.new(rm)
  Dir.glob(paths).each do |path|
    dc.run(path)
  end
end

if $0 == __FILE__
  ARGV.each do |target|
    rm_rf(target.chomp("/"))
  end
end
